/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.cookingforblockheads.block.BlockDyeableKitchen;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.SinkBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SinkBlock
extends BlockDyeableKitchen {
    public static final String name = "sink";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "sink");

    public SinkBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(5.0f, 10.0f), registryName);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, COLOR, HAS_COLOR, FLIPPED});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return (BlockState)state.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.m_61143_((Property)FACING))));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        if (this.tryRecolorBlock(state, heldItem, level, pos, player, rayTraceResult)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack resultStack = CookingRegistry.getSinkOutput(heldItem);
        if (!resultStack.m_41619_()) {
            CompoundTag tagCompound = heldItem.m_41783_();
            ItemStack newItem = resultStack.m_41777_();
            if (tagCompound != null) {
                newItem.m_41751_(tagCompound);
            }
            if (heldItem.m_41613_() <= 1) {
                player.m_21008_(hand, newItem);
            } else if (player.m_150109_().m_36054_(newItem)) {
                heldItem.m_41774_(1);
            }
            this.spawnParticles(level, pos, state);
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, level.f_46441_.nextFloat() + 0.5f);
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SinkBlockEntity) {
            SinkBlockEntity sink = (SinkBlockEntity)blockEntity;
            FluidTank fluidTank = sink.getFluidTank();
            if (!Balm.getHooks().useFluidTank(state, level, pos, player, hand, rayTraceResult)) {
                if (heldItem.m_41720_() == Items.f_42590_) {
                    int simulated = fluidTank.drain((Fluid)Fluids.f_76193_, 333, true);
                    if (simulated == 333) {
                        fluidTank.drain((Fluid)Fluids.f_76193_, 333, false);
                        if (player.m_36356_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_))) {
                            heldItem.m_41774_(1);
                        }
                    } else {
                        this.spawnParticles(level, pos, state);
                    }
                } else {
                    this.spawnParticles(level, pos, state);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void spawnParticles(Level level, BlockPos pos, BlockState state) {
        float dripWaterX = 0.0f;
        float dripWaterZ = 0.0f;
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                dripWaterZ = 0.25f;
                dripWaterX = -0.05f;
                break;
            }
            case SOUTH: {
                dripWaterX = 0.25f;
                break;
            }
            case WEST: {
                dripWaterX = 0.25f;
                dripWaterZ = 0.25f;
                break;
            }
            case EAST: {
                dripWaterZ = -0.05f;
            }
        }
        float particleX = (float)pos.m_123341_() + 0.5f;
        float particleY = (float)pos.m_123342_() + 1.25f;
        float particleZ = (float)pos.m_123343_() + 0.5f;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)particleX + (double)dripWaterX, (double)particleY - (double)0.45f, (double)particleZ + (double)dripWaterZ, 0.0, 0.0, 0.0);
        for (int i = 0; i < 5; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)particleX + Math.random() - 0.5, (double)particleY + Math.random() - 0.5, (double)particleZ + Math.random() - 0.5, 0.0, 0.0, 0.0);
        }
        level.m_5594_(null, pos, SoundEvents.f_12540_, SoundSource.BLOCKS, 0.1f, level.f_46441_.nextFloat() + 0.5f);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SinkBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : SinkBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.sink.get()), SinkBlockEntity::serverTick);
    }
}

