/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import java.util.function.Supplier;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IMCHandler {
    public static final Logger logger = LogManager.getLogger();
    private static final NonNullList<ItemStack> imcNonFoodRecipes = NonNullList.m_122779_();

    private static <T> T getMessageData(InterModComms.IMCMessage message) {
        Supplier supplier = message.messageSupplier();
        return supplier.get();
    }

    public static void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            switch (message.method()) {
                case "RegisterTool": {
                    ItemStack itemStack = (ItemStack)IMCHandler.getMessageData(message);
                    CookingForBlockheadsAPI.addToolItem(itemStack);
                    break;
                }
                case "RegisterWaterItem": {
                    ItemStack itemStack = (ItemStack)IMCHandler.getMessageData(message);
                    CookingForBlockheadsAPI.addWaterItem(itemStack);
                    break;
                }
                case "RegisterMilkItem": {
                    ItemStack itemStack = (ItemStack)IMCHandler.getMessageData(message);
                    CookingForBlockheadsAPI.addMilkItem(itemStack);
                    break;
                }
                case "RegisterToast": {
                    CompoundTag tagCompound = (CompoundTag)IMCHandler.getMessageData(message);
                    ItemStack inputItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Input"));
                    ItemStack toastOutputItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Output"));
                    if (!inputItem.m_41619_() && !toastOutputItem.m_41619_()) {
                        CookingForBlockheadsAPI.addToasterHandler(inputItem, it -> toastOutputItem);
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterToast expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                    break;
                }
                case "RegisterOvenFuel": {
                    CompoundTag tagCompound = (CompoundTag)IMCHandler.getMessageData(message);
                    ItemStack inputItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Input"));
                    if (!inputItem.m_41619_() && tagCompound.m_128425_("FuelValue", 99)) {
                        CookingForBlockheadsAPI.addOvenFuel(inputItem, tagCompound.m_128451_("FuelValue"));
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterOvenFuel expected message of type NBT with structure {Input : ItemStack, FuelValue : numeric}");
                    break;
                }
                case "RegisterOvenRecipe": {
                    CompoundTag tagCompound = (CompoundTag)IMCHandler.getMessageData(message);
                    ItemStack inputItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Input"));
                    ItemStack outputItem = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Output"));
                    if (!inputItem.m_41619_() && !outputItem.m_41619_()) {
                        CookingForBlockheadsAPI.addOvenRecipe(inputItem, outputItem);
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterOvenRecipe expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                    break;
                }
                case "RegisterNonFoodRecipe": {
                    ItemStack itemStack = (ItemStack)IMCHandler.getMessageData(message);
                    imcNonFoodRecipes.add((Object)itemStack);
                    break;
                }
                case "RegisterCowClass": {
                    String cowClassName = (String)IMCHandler.getMessageData(message);
                    try {
                        Class<?> clazz = Class.forName(cowClassName);
                        CookingForBlockheadsAPI.addCowClass(clazz);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        CookingForBlockheads.logger.error("Could not register cow class " + cowClassName + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static void onFoodRegistryInit(FoodRegistryInitEvent event) {
        for (ItemStack itemStack : imcNonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }
}

