/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.InventoryCraftingDecompress;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class CompressMessage {
    private final int slotNumber;
    private final CompressType type;

    public CompressMessage(int slotNumber, CompressType type) {
        this.slotNumber = slotNumber;
        this.type = type;
    }

    public static CompressMessage decode(FriendlyByteBuf buf) {
        int slotNumber = buf.readInt();
        CompressType type = CompressType.values()[buf.readByte()];
        return new CompressMessage(slotNumber, type);
    }

    public static void encode(CompressMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.slotNumber);
        buf.writeByte(message.type.ordinal());
    }

    public static void handle(ServerPlayer player, CompressMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null) {
            return;
        }
        CompressType compressType = message.type;
        Slot mouseSlot = (Slot)menu.f_38839_.get(message.slotNumber);
        if (!(mouseSlot.f_40218_ instanceof Inventory)) {
            return;
        }
        ItemStack mouseStack = mouseSlot.m_7993_();
        if (mouseStack.m_41619_()) {
            return;
        }
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        if (!CraftingTweaksConfig.getActive().common.compressAnywhere && grid == null) {
            return;
        }
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_STACK || compressType == CompressType.DECOMPRESS_ONE) {
            boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
            block0: for (Slot slot : menu.f_38839_) {
                ItemStack result;
                if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot || !(slot.f_40218_ instanceof Inventory) || !slot.m_6657_() || !ItemStack.m_41746_((ItemStack)slot.m_7993_(), (ItemStack)mouseSlot.m_7993_()) || !ItemStack.m_41658_((ItemStack)slot.m_7993_(), (ItemStack)mouseSlot.m_7993_()) || (result = CompressMessage.findMatchingResult(new InventoryCraftingDecompress(menu, slot.m_7993_()), player)).m_41619_() || CompressMessage.isBlacklisted(result) || slot.m_7993_().m_41619_() || slot.m_7993_().m_41613_() < 1) continue;
                while (player.m_150109_().m_36054_(result.m_41777_())) {
                    CompressMessage.giveLeftoverItems(player, slot.m_7993_(), 1);
                    slot.m_6201_(1);
                    if (decompressAll && slot.m_6657_() && slot.m_7993_().m_41613_() >= 1) continue;
                    continue block0;
                }
            }
        } else {
            boolean compressAll = compressType != CompressType.COMPRESS_ONE;
            int size = grid != null ? grid.getGridSize((Player)player, menu) : 9;
            block2: for (Slot slot : menu.f_38839_) {
                ItemStack result;
                if (compressType != CompressType.COMPRESS_ALL && slot != mouseSlot) continue;
                ItemStack slotStack = slot.m_7993_();
                if (!(slot.f_40218_ instanceof Inventory) || !slot.m_6657_() || !ItemStack.m_41746_((ItemStack)slotStack, (ItemStack)mouseSlot.m_7993_()) || !ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)mouseSlot.m_7993_())) continue;
                if (size == 9 && !slotStack.m_41619_() && slotStack.m_41613_() >= 9) {
                    result = CompressMessage.findMatchingResult(new InventoryCraftingCompress(menu, 3, slotStack), player);
                    if (!result.m_41619_() && !CompressMessage.isBlacklisted(result)) {
                        while (player.m_150109_().m_36054_(result.m_41777_())) {
                            CompressMessage.giveLeftoverItems(player, slotStack, 9);
                            slot.m_6201_(9);
                            if (compressAll && slot.m_6657_() && slotStack.m_41613_() >= 9) continue;
                            continue block2;
                        }
                        continue;
                    }
                    result = CompressMessage.findMatchingResult(new InventoryCraftingCompress(menu, 2, slotStack), player);
                    if (result.m_41619_() || CompressMessage.isBlacklisted(result)) continue;
                    while (player.m_150109_().m_36054_(result.m_41777_())) {
                        CompressMessage.giveLeftoverItems(player, slotStack, 4);
                        slot.m_6201_(4);
                        if (compressAll && slot.m_6657_() && slotStack.m_41613_() >= 4) continue;
                        continue block2;
                    }
                    continue;
                }
                if (size < 4 || slotStack.m_41619_() || slotStack.m_41613_() < 4 || (result = CompressMessage.findMatchingResult(new InventoryCraftingCompress(menu, 2, slotStack), player)).m_41619_() || CompressMessage.isBlacklisted(result)) continue;
                while (player.m_150109_().m_36054_(result.m_41777_())) {
                    CompressMessage.giveLeftoverItems(player, slotStack, 4);
                    slot.m_6201_(4);
                    if (compressAll && slot.m_6657_() && slotStack.m_41613_() >= 4) continue;
                    continue block2;
                }
            }
        }
        menu.m_38946_();
    }

    private static void giveLeftoverItems(ServerPlayer player, ItemStack slotStack, int count) {
        for (int i = 0; i < count; ++i) {
            ItemEntity itemEntity;
            ItemStack containerItem = Balm.getHooks().getCraftingRemainingItem(slotStack);
            if (player.m_36356_(containerItem) || (itemEntity = player.m_36176_(containerItem, false)) == null) continue;
            itemEntity.m_32061_();
            itemEntity.m_32047_(player.m_142081_());
        }
    }

    private static <T extends CraftingContainer> ItemStack findMatchingResult(T craftingInventory, ServerPlayer player) {
        RecipeManager recipeManager = Objects.requireNonNull(player.m_20194_()).m_129894_();
        CraftingRecipe recipe = recipeManager.m_44015_(RecipeType.f_44107_, craftingInventory, player.f_19853_).orElse(null);
        if (recipe != null && ((RecipeHolder)craftingInventory).m_40135_(player.f_19853_, player, (Recipe)recipe)) {
            return recipe.m_5874_(craftingInventory);
        }
        return ItemStack.f_41583_;
    }

    private static boolean isBlacklisted(ItemStack result) {
        ResourceLocation registryName = Registry.f_122827_.m_7981_((Object)result.m_41720_());
        return CraftingTweaksConfig.getActive().common.compressBlacklist.contains(registryName.toString());
    }
}

