/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksMode;

@Config(name="craftingtweaks")
public class CraftingTweaksConfigData
implements BalmConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public Common common = new Common();
    @ConfigEntry.Gui.CollapsibleObject
    public Client client = new Client();

    public CraftingTweaksMode getCraftingTweaksMode(String modId) {
        if (this.client.disabledAddons.contains(modId)) {
            return CraftingTweaksMode.DISABLED;
        }
        return this.client.craftingTweaksMode;
    }

    public static class Common {
        @Comment(value="Set this to true if you want the (de)compress feature to work outside of crafting GUIs (only works if installed on server)")
        public boolean compressAnywhere = false;
        @Comment(value="A list of modid:name entries that will not be crafted by the compress key.")
        public List<String> compressBlacklist = Arrays.asList("minecraft:sandstone", "minecraft:iron_trapdoor");
    }

    public static class Client {
        @Comment(value="This option is toggled by the 'Toggle Buttons' key that can be defined in the Controls settings.")
        public boolean hideButtons = false;
        @Comment(value="If set to true, right-clicking the result slot in a crafting table will craft a full stack.")
        public boolean rightClickCraftsStack = true;
        @Comment(value="Set this to true if you don't want the tweak buttons' tooltips to show.")
        public boolean hideButtonTooltips = false;
        @Comment(value="We both know JEI is much better. This option hides Vanilla's crafting book button instead of moving it.")
        public boolean hideVanillaCraftingGuide = false;
        @Comment(value="Set to 'DEFAULT' to enable both buttons and hotkeys. Set to 'BUTTONS' to enable buttons only. Set to 'HOTKEYS' to enable hotkeys only.")
        public CraftingTweaksMode craftingTweaksMode = CraftingTweaksMode.DEFAULT;
        @Comment(value="Add mod ids here of mods that you wish to disable Crafting Tweaks support for.")
        public List<String> disabledAddons = new ArrayList<String>();
    }
}

