/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.LinkedList;
import java.util.List;
import jeresources.profiling.EmptyChunkJER;
import jeresources.profiling.ProfilingExecutor;
import jeresources.util.LogHelper;
import net.minecraft.ReportedException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class ChunkGetter
implements Runnable {
    public static final int CHUNKS_PER_RUN = 25;
    private final int maxRunCount;
    private final Runnable runnable;
    private IChunkGetterStrategy strategy;
    private int runCount;

    public ChunkGetter(final int chunkCount, final ServerLevel level, final ProfilingExecutor executor) {
        this.maxRunCount = (int)Math.ceil((float)chunkCount / 25.0f);
        this.strategy = new ChunkGetterRandom(level);
        this.runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ChunkGetter.this.getRunCount() < ChunkGetter.this.getMaxRunCount()) {
                        List<ChunkAccess> chunks = ChunkGetter.this.strategy.generateChunks(level);
                        if (ChunkGetter.this.strategy instanceof ChunkGetterRandom && ChunkGetter.this.areAllChunksEmpty(chunks)) {
                            ChunkGetter.this.strategy = new ChunkGetterOrigin(level, chunkCount);
                            chunks = ChunkGetter.this.strategy.generateChunks(level);
                        }
                        ++ChunkGetter.this.runCount;
                        executor.addChunkProfiler(level, chunks);
                        executor.execute(() -> level.m_142572_().m_129946_(ChunkGetter.this.runnable));
                    } else {
                        executor.shutdown();
                    }
                }
                catch (ReportedException re) {
                    LogHelper.info("Chunk getting failed: " + re.getMessage(), new Object[0]);
                    executor.shutdown();
                }
            }
        };
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    private int getMaxRunCount() {
        return this.maxRunCount;
    }

    private int getRunCount() {
        return this.runCount;
    }

    private boolean areAllChunksEmpty(List<ChunkAccess> chunks) {
        for (ChunkAccess chunk : chunks) {
            if (chunk.m_62098_() == 0) continue;
            return false;
        }
        return true;
    }

    private static List<ChunkAccess> centerChunks(ServerLevel level, ChunkGenerator chunkGenerator, int chunkX, int chunkZ, int generate_size) {
        LinkedList<ChunkAccess> centerChunks = new LinkedList<ChunkAccess>();
        for (int i = 0; i < generate_size; ++i) {
            for (int j = 0; j < generate_size; ++j) {
                if (i <= 0 || i >= generate_size - 1 || j <= 0 || j >= generate_size - 1) continue;
                centerChunks.add((ChunkAccess)new EmptyChunkJER(level, chunkX + i, chunkZ + j));
            }
        }
        return centerChunks;
    }

    private static class ChunkGetterRandom
    implements IChunkGetterStrategy {
        private static final int GENERATE_SIZE = (int)Math.ceil(Math.sqrt(25.0)) + 2;
        private final ChunkGenerator chunkGenerator;

        public ChunkGetterRandom(ServerLevel level) {
            this.chunkGenerator = level.m_7726_().m_8481_().m_6819_(level.f_46441_.nextLong());
        }

        @Override
        public List<ChunkAccess> generateChunks(ServerLevel level) {
            WorldBorder worldBorder = level.m_6857_();
            int maxChunkPos = (int)(worldBorder.m_61959_() / 16.0) - GENERATE_SIZE;
            int chunkX = level.f_46441_.nextInt(2 * maxChunkPos) - maxChunkPos + (int)worldBorder.m_6347_();
            int chunkZ = level.f_46441_.nextInt(2 * maxChunkPos) - maxChunkPos + (int)worldBorder.m_6345_();
            return ChunkGetter.centerChunks(level, this.chunkGenerator, chunkX, chunkZ, GENERATE_SIZE);
        }
    }

    private static interface IChunkGetterStrategy {
        public List<ChunkAccess> generateChunks(ServerLevel var1);
    }

    private static class ChunkGetterOrigin
    implements IChunkGetterStrategy {
        private static final int GENERATE_SIZE = (int)Math.ceil(Math.sqrt(25.0)) + 2;
        private final ChunkGenerator chunkGenerator;
        private final int sideLength;
        private final int minX;
        private final int maxX;
        private int posX;
        private int posZ;

        public ChunkGetterOrigin(ServerLevel level, int chunkCount) {
            this.chunkGenerator = level.m_7726_().m_8481_().m_6819_(level.f_46441_.nextLong());
            this.sideLength = (int)Math.ceil(Math.sqrt(chunkCount));
            WorldBorder worldBorder = level.m_6857_();
            this.minX = (int)worldBorder.m_6347_() - this.sideLength / 2;
            this.maxX = (int)worldBorder.m_6347_() + this.sideLength / 2;
            this.posX = this.minX;
            this.posZ = (int)worldBorder.m_6345_() - this.sideLength / 2;
        }

        @Override
        public List<ChunkAccess> generateChunks(ServerLevel level) {
            int chunkX = this.posX;
            int chunkZ = this.posZ;
            this.posX += GENERATE_SIZE - 1;
            if (this.posX > this.maxX) {
                this.posX = this.minX;
                this.posZ += GENERATE_SIZE - 1;
            }
            return ChunkGetter.centerChunks(level, this.chunkGenerator, chunkX, chunkZ, GENERATE_SIZE);
        }
    }
}

