/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.Size2i;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.plugin.jei.JEIPlugin;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe;

public class RetexturableRecipeExtension
implements ICraftingCategoryExtension,
ICustomCraftingCategoryExtension,
ITooltipCallback<ItemStack> {
    private final ShapedRetexturedRecipe recipe;
    private final Size2i size;
    private final List<List<ItemStack>> allOutputs;
    private final List<ItemStack> displayOutputs;

    RetexturableRecipeExtension(ShapedRetexturedRecipe recipe) {
        this.recipe = recipe;
        this.size = new Size2i(recipe.getRecipeWidth(), recipe.getRecipeHeight());
        ItemStack output = this.recipe.m_8043_();
        List displayVariants = Arrays.stream(recipe.getTexture().m_43908_()).map(stack -> recipe.getRecipeOutput(stack.m_41720_())).collect(Collectors.toList());
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(displayVariants);
        builder.add((Object)output);
        ImmutableList allVariants = builder.build();
        this.allOutputs = ImmutableList.of((Object)allVariants);
        this.displayOutputs = displayVariants.isEmpty() ? allVariants : displayVariants;
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.m_6423_();
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputIngredients((List)this.recipe.m_7527_());
        ingredients.setOutputLists(VanillaTypes.ITEM, this.allOutputs);
    }

    public Size2i getSize() {
        return this.size;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((ITooltipCallback)this);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        ImmutableList outputs = this.displayOutputs;
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        if (focus != null) {
            focus.getValue();
            IGuiIngredientGroup guiIngredients = recipeLayout.getIngredientsGroup(VanillaTypes.ITEM);
            ItemStack focusStack = (ItemStack)focus.getValue();
            IFocus.Mode mode = focus.getMode();
            if (mode == IFocus.Mode.INPUT && this.recipe.getTexture().test(focusStack)) {
                outputs = ImmutableList.of((Object)this.recipe.getRecipeOutput(focusStack.m_41720_()));
            } else if (mode == IFocus.Mode.OUTPUT) {
                Block textureBlock = RetexturedBlockItem.getTexture(focusStack);
                if (textureBlock != Blocks.f_50016_) {
                    ItemStack output = focusStack.m_41777_();
                    output.m_41764_(this.recipe.m_8043_().m_41613_());
                    outputs = ImmutableList.of((Object)output);
                    guiIngredients.setOverrideDisplayFocus(JEIPlugin.recipeManager.createFocus(IFocus.Mode.INPUT, (Object)new ItemStack((ItemLike)textureBlock)));
                } else {
                    guiIngredients.setOverrideDisplayFocus(null);
                }
            }
        }
        JEIPlugin.vanillaCraftingHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, this.size.width, this.size.height);
        guiItemStacks.set(0, outputs);
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<Component> tooltip) {
        ResourceLocation registryName = this.getRegistryName();
        if (slotIndex == 0 && registryName != null) {
            boolean showAdvanced;
            if (JEIPlugin.modIdHelper.isDisplayingModNameEnabled()) {
                String recipeModId = this.getRegistryName().m_135827_();
                boolean modIdDifferent = false;
                ResourceLocation itemRegistryName = ingredient.m_41720_().getRegistryName();
                if (itemRegistryName != null) {
                    String itemModId = itemRegistryName.m_135827_();
                    boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                }
                if (modIdDifferent) {
                    String modName = JEIPlugin.modIdHelper.getFormattedModNameForModId(recipeModId);
                    tooltip.add((Component)new TranslatableComponent("jei.tooltip.recipe.by", new Object[]{modName}).m_130940_(ChatFormatting.GRAY));
                }
            }
            boolean bl = showAdvanced = Minecraft.m_91087_().f_91066_.f_92125_ || Screen.m_96638_();
            if (showAdvanced) {
                tooltip.add((Component)new TranslatableComponent("jei.tooltip.recipe.id", new Object[]{registryName}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

