/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import com.mojang.datafixers.util.Pair;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import squeek.appleskin.api.food.FoodValues;

public class FoodHelper {
    public static float REGEN_EXHAUSTION_INCREMENT = 6.0f;
    public static float MAX_EXHAUSTION = 4.0f;

    public static boolean isFood(ItemStack itemStack) {
        return itemStack.m_41720_().m_41473_() != null;
    }

    public static boolean canConsume(ItemStack itemStack, Player player) {
        if (!FoodHelper.isFood(itemStack)) {
            return false;
        }
        FoodProperties itemFood = itemStack.m_41720_().m_41473_();
        if (itemFood == null) {
            return false;
        }
        return player.m_36391_(itemFood.m_38747_());
    }

    public static FoodValues getDefaultFoodValues(ItemStack itemStack) {
        FoodProperties itemFood = itemStack.m_41720_().m_41473_();
        int hunger = itemFood != null ? itemFood.m_38744_() : 0;
        float saturationModifier = itemFood != null ? itemFood.m_38745_() : 0.0f;
        return new FoodValues(hunger, saturationModifier);
    }

    public static FoodValues getModifiedFoodValues(ItemStack itemStack, Player player) {
        return FoodHelper.getDefaultFoodValues(itemStack);
    }

    public static boolean isRotten(ItemStack itemStack) {
        if (!FoodHelper.isFood(itemStack)) {
            return false;
        }
        for (Pair effect : itemStack.m_41720_().m_41473_().m_38749_()) {
            if (effect.getFirst() == null || ((MobEffectInstance)effect.getFirst()).m_19544_() == null || ((MobEffectInstance)effect.getFirst()).m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            return true;
        }
        return false;
    }

    public static float getEstimatedHealthIncrement(ItemStack itemStack, FoodValues modifiedFoodValues, Player player) {
        if (!FoodHelper.isFood(itemStack)) {
            return 0.0f;
        }
        if (!player.m_36325_()) {
            return 0.0f;
        }
        FoodData stats = player.m_36324_();
        Level world = player.m_20193_();
        int foodLevel = Math.min(stats.m_38702_() + modifiedFoodValues.hunger, 20);
        float healthIncrement = 0.0f;
        if ((float)foodLevel >= 18.0f && world != null && world.m_46469_().m_46207_(GameRules.f_46139_)) {
            float saturationLevel = Math.min(stats.m_38722_() + modifiedFoodValues.getSaturationIncrement(), (float)foodLevel);
            float exhaustionLevel = stats.m_150380_();
            healthIncrement = FoodHelper.getEstimatedHealthIncrement(foodLevel, saturationLevel, exhaustionLevel);
        }
        for (Pair effect : itemStack.m_41720_().m_41473_().m_38749_()) {
            MobEffectInstance effectInstance = (MobEffectInstance)effect.getFirst();
            if (effectInstance == null || effectInstance.m_19544_() != MobEffects.f_19605_) continue;
            int amplifier = effectInstance.m_19564_();
            int duration = effectInstance.m_19557_();
            healthIncrement += (float)Math.floor(duration / Math.max(50 >> amplifier, 1));
            break;
        }
        return healthIncrement;
    }

    public static float getEstimatedHealthIncrement(int foodLevel, float saturationLevel, float exhaustionLevel) {
        float health = 0.0f;
        if (!Float.isFinite(exhaustionLevel) || !Float.isFinite(saturationLevel)) {
            return 0.0f;
        }
        while (foodLevel >= 18) {
            while (exhaustionLevel > MAX_EXHAUSTION) {
                exhaustionLevel -= MAX_EXHAUSTION;
                if (saturationLevel > 0.0f) {
                    saturationLevel = Math.max(saturationLevel - 1.0f, 0.0f);
                    continue;
                }
                --foodLevel;
            }
            if (foodLevel >= 20 && Float.compare(saturationLevel, Float.MIN_NORMAL) > 0) {
                float limitedSaturationLevel = Math.min(saturationLevel, REGEN_EXHAUSTION_INCREMENT);
                float exhaustionUntilAboveMax = Math.nextUp(MAX_EXHAUSTION) - exhaustionLevel;
                int numIterationsUntilAboveMax = Math.max(1, (int)Math.ceil(exhaustionUntilAboveMax / limitedSaturationLevel));
                health += limitedSaturationLevel / REGEN_EXHAUSTION_INCREMENT * (float)numIterationsUntilAboveMax;
                exhaustionLevel += limitedSaturationLevel * (float)numIterationsUntilAboveMax;
                continue;
            }
            if (foodLevel < 18) continue;
            health += 1.0f;
            exhaustionLevel += REGEN_EXHAUSTION_INCREMENT;
        }
        return health;
    }
}

