/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.trashcans.TrashCans;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrashCansAdvancementProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public TrashCansAdvancementProvider(GatherDataEvent e) {
        this.generator = e.getGenerator();
    }

    public void m_6865_(HashCache hashCache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path advancementPath = TrashCansAdvancementProvider.createPath(path, advancement);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)hashCache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)advancementPath);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)advancementPath, (Object)ioexception);
            }
        };
        Advancement trash_can = Advancement.Builder.m_138353_().m_138371_((ItemLike)TrashCans.item_trash_can.m_5456_(), (Component)TextComponents.translation((String)"trashcans.advancement.trash_can.title").get(), (Component)TextComponents.translation((String)"trashcans.advancement.trash_can.description").get(), new ResourceLocation("minecraft", "textures/block/cobblestone.png"), FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_).m_138386_("has_trash_can", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{TrashCans.item_trash_can})).m_138386_("has_trash_can2", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{TrashCans.liquid_trash_can})).m_138386_("has_trash_can3", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{TrashCans.energy_trash_can})).m_138389_(consumer, "trashcans:trash_can");
        Advancement ultimate_trash_can = Advancement.Builder.m_138353_().m_138398_(trash_can).m_138371_((ItemLike)TrashCans.ultimate_trash_can.m_5456_(), (Component)TextComponents.translation((String)"trashcans.advancement.ultimate_trash_can.title").get(), (Component)TextComponents.translation((String)"trashcans.advancement.ultimate_trash_can.description").get(), null, FrameType.TASK, true, true, false).m_138386_("has_trash_can", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{TrashCans.ultimate_trash_can})).m_138389_(consumer, "trashcans:ultimate_trash_can");
    }

    private static Path createPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Advancements";
    }
}

