/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.mekanism;

import com.supermartijn642.trashcans.compat.mekanism.GasFilterManager;
import com.supermartijn642.trashcans.compat.mekanism.MekanismCompatOff;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import java.util.ArrayList;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;

public class MekanismCompatOn
extends MekanismCompatOff {
    public MekanismCompatOn() {
        LiquidTrashCanFilters.register(new GasFilterManager(), "gas");
    }

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    public Capability<?> getGasHandlerCapability() {
        return Capabilities.GAS_HANDLER_CAPABILITY;
    }

    @Override
    public boolean doesItemHaveGasStored(ItemStack stack) {
        return stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).filter(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (((GasStack)handler.getChemicalInTank(i)).isEmpty()) continue;
                return true;
            }
            return false;
        }).isPresent();
    }

    @Override
    public boolean drainGasFromItem(ItemStack stack) {
        return stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).map(handler -> {
            boolean changed = false;
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                if (((GasStack)handler.getChemicalInTank(tank)).isEmpty()) continue;
                handler.extractChemical((ChemicalStack)((GasStack)handler.getChemicalInTank(tank)), Action.EXECUTE);
                changed = true;
            }
            return changed;
        }).orElse(false);
    }

    @Override
    public Object getGasHandler(final ArrayList<ItemFilter> filters, final Supplier<Boolean> whitelist) {
        return new IGasHandler(){

            public int getTanks() {
                return 1;
            }

            public GasStack getChemicalInTank(int i) {
                return GasStack.EMPTY;
            }

            public void setChemicalInTank(int i, GasStack gasStack) {
            }

            public long getTankCapacity(int i) {
                return Integer.MAX_VALUE;
            }

            public boolean isValid(int i, GasStack gasStack) {
                if (gasStack.has(GasAttributes.Radiation.class)) {
                    return false;
                }
                for (ItemFilter filter : filters) {
                    if (filter == null || !filter.matches(gasStack)) continue;
                    return (Boolean)whitelist.get();
                }
                return (Boolean)whitelist.get() == false;
            }

            public GasStack insertChemical(int i, GasStack gasStack, Action action) {
                if (this.isValid(i, gasStack)) {
                    return GasStack.EMPTY;
                }
                return gasStack;
            }

            public GasStack extractChemical(int i, long l, Action action) {
                return GasStack.EMPTY;
            }
        };
    }

    @Override
    public boolean isGasStack(Object obj) {
        return obj instanceof GasStack;
    }

    @Override
    public ItemStack getChemicalTankForGasStack(Object gasStack) {
        ItemStack stack = new ItemStack((ItemLike)MekanismBlocks.CREATIVE_CHEMICAL_TANK);
        stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).ifPresent(handler -> {
            GasStack gas = ((GasStack)gasStack).copy();
            gas.setAmount(handler.getTankCapacity(0));
            handler.setChemicalInTank(0, (ChemicalStack)gas);
        });
        return stack;
    }
}

