/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.RenderHelpers;

public class ParticleBlur
extends TextureSheetParticle {
    private static final int MAX_VIEW_DISTANCE = 30;
    private static final RenderType RENDER_TYPE = new RenderType();
    protected float originalScale;
    protected float scaleLife;

    public ParticleBlur(ParticleBlurData data, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.f_107227_ = data.getRed();
        this.f_107228_ = data.getGreen();
        this.f_107229_ = data.getBlue();
        this.f_107230_ = 0.9f;
        this.f_107226_ = 0.0f;
        this.originalScale = (this.f_107223_.nextFloat() * 0.5f + 0.5f) * 2.0f * data.getScale();
        this.f_107225_ = (int)((this.f_107223_.nextFloat() * 0.33f + 0.66f) * data.getAgeMultiplier());
        this.m_107250_(0.01f, 0.01f);
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
        this.scaleLife = (float)((double)this.f_107225_ / 2.5);
        this.validateDistance();
    }

    private void validateDistance() {
        LocalPlayer renderentity = Minecraft.m_91087_().f_91074_;
        int visibleDistance = 30;
        if (Minecraft.m_91087_().f_91066_.f_92115_.m_90773_() == 0) {
            visibleDistance /= 2;
        }
        if (renderentity == null || renderentity.m_20275_(this.f_107212_, this.f_107213_, this.f_107214_) > (double)(visibleDistance * visibleDistance)) {
            this.f_107225_ = 0;
        }
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        this.f_107216_ -= 0.04 * (double)this.f_107226_;
        this.f_107212_ += this.f_107215_;
        this.f_107213_ += this.f_107216_;
        this.f_107214_ += this.f_107217_;
        this.f_107215_ *= (double)0.98f;
        this.f_107216_ *= (double)0.98f;
        this.f_107217_ *= (double)0.98f;
    }

    protected int m_6355_(float partialTicks) {
        return 0xF000F0;
    }

    public void setGravity(float particleGravity) {
        this.f_107226_ = particleGravity;
    }

    public float m_5902_(float p_217561_1_) {
        float agescale = (float)this.f_107224_ / this.scaleLife;
        if (agescale > 1.0f) {
            agescale = 2.0f - agescale;
        }
        this.f_107663_ = this.originalScale * agescale * 0.5f;
        return this.f_107663_;
    }

    public static class RenderType
    implements ParticleRenderType {
        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)1);
            RenderHelpers.bindTexture(TextureAtlas.f_118260_);
            textureManager.m_118506_(TextureAtlas.f_118260_).setBlurMipmap(true, false);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tessellator) {
            tessellator.m_85914_();
            Minecraft.m_91087_().f_90987_.m_118506_(TextureAtlas.f_118260_).restoreLastBlurMipmap();
            RenderSystem.m_69461_();
            RenderSystem.m_69458_((boolean)true);
        }
    }
}

