/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.BedFrameTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;

public class BedFrameBlock
extends BedBlock {
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;

    public BedFrameBlock(DyeColor colorIn, BlockBehaviour.Properties properties) {
        super(colorIn, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CONTAINS_BLOCK, LIGHT_LEVEL, PART, OCCUPIED, HORIZONTAL_FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BedFrameTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        ItemStack item = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (BlockAppearanceHelper.setLightLevel(item, state, level, pos, player, hand) || BlockAppearanceHelper.setTexture(item, state, level, player, pos) || BlockAppearanceHelper.setDesign(level, pos, player, item) || BlockAppearanceHelper.setDesignTexture(level, pos, player, item) || BlockAppearanceHelper.setWoolColor(level, pos, player, hand) || BlockAppearanceHelper.setOverlay(level, pos, player, item) || BlockAppearanceHelper.setRotation(level, pos, player, item)) {
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue() && !item.m_204117_(Tags.Items.DYES) && !item.m_41720_().getRegistryName().m_135827_().equals("blockcarpentry") || item.m_41619_()) {
                if (state.m_61143_(PART) != BedPart.HEAD && !(state = level.m_8055_(pos = pos.m_142300_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)))).m_60713_((Block)this)) {
                    return InteractionResult.CONSUME;
                }
                if (!BedFrameBlock.m_49488_((Level)level)) {
                    level.m_7471_(pos, false);
                    BlockPos blockpos = pos.m_142300_(((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122424_());
                    if (level.m_8055_(blockpos).m_60713_((Block)this)) {
                        level.m_7471_(blockpos, false);
                    }
                    level.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
                    return InteractionResult.SUCCESS;
                }
                if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
                    if (!this.kickVillagerOutOfBed(level, pos)) {
                        player.m_5661_((Component)new TranslatableComponent("block.minecraft.bed.occupied"), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                player.m_7720_(pos).ifLeft(comp -> {
                    if (comp != null) {
                        player.m_5661_(comp.m_36423_(), true);
                    }
                });
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue() && player.m_6047_()) {
                this.dropContainedBlock(level, pos);
                state = (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                level.m_7731_(pos, state, 2);
            } else if (item.m_41720_() instanceof BlockItem) {
                if (Objects.requireNonNull(item.m_41720_().getRegistryName()).m_135827_().equals("blockcarpentry")) {
                    return InteractionResult.PASS;
                }
                BlockEntity tileEntity = level.m_7702_(pos);
                int count = player.m_21120_(hand).m_41613_();
                Block heldBlock = ((BlockItem)item.m_41720_()).m_40614_();
                if (tileEntity instanceof BedFrameTile && !item.m_41619_() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.m_41720_()).m_40614_().m_49966_();
                    this.insertBlock(level, pos, state, handBlockState);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41764_(count - 1);
                    }
                }
            }
            if (player.m_21120_(hand).m_41720_() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.m_6047_()) {
                if (!player.m_7500_()) {
                    this.dropContainedBlock(level, pos);
                }
                state = (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                level.m_7731_(pos, state, 2);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List list = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    protected void dropContainedBlock(Level levelIn, BlockPos pos) {
        BlockEntity tileentity;
        if (!levelIn.f_46443_ && (tileentity = levelIn.m_7702_(pos)) instanceof BedFrameTile) {
            BedFrameTile frameBlockEntity = (BedFrameTile)tileentity;
            BlockState blockState = frameBlockEntity.getMimic();
            if (blockState != null) {
                levelIn.m_46796_(1010, pos, 0);
                frameBlockEntity.clear();
                float f = 0.7f;
                double d0 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
                double d1 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                double d2 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
                ItemStack itemstack1 = blockState.m_60734_().m_5456_().m_7968_();
                ItemEntity itementity = new ItemEntity(levelIn, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemstack1);
                itementity.m_32060_();
                levelIn.m_7967_((Entity)itementity);
            }
            frameBlockEntity.clear();
        }
    }

    public void insertBlock(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock) {
        BlockEntity tileentity = levelIn.m_7702_(pos);
        if (tileentity instanceof BedFrameTile) {
            BedFrameTile frameBlockEntity = (BedFrameTile)tileentity;
            frameBlockEntity.clear();
            frameBlockEntity.setMimic(handBlock);
            levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void m_6810_(BlockState state, Level levelIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropContainedBlock(levelIn, pos);
            super.m_6810_(state, levelIn, pos, newState, isMoving);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.m_61143_((Property)LIGHT_LEVEL);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

