/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.PaneFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class PaneBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        Integer design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
        if (side != null) {
            return Collections.emptyList();
        }
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            if (state != null) {
                int overlayIndex;
                BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
                List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
                Integer tex = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
                if (textureList.size() <= tex) {
                    extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                    tex = 0;
                }
                if (textureList.size() == 0) {
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.block_not_available"), true);
                    }
                    for (int i = 0; i < 6; ++i) {
                        textureList.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("missing")));
                    }
                }
                TextureAtlasSprite texture = textureList.get(tex);
                TextureAtlasSprite glass = TextureHelper.getGlassTextures().get((Integer)extraData.getData(FrameBlockTile.GLASS_COLOR));
                boolean north = (Boolean)state.m_61143_((Property)PaneFrameBlock.f_52309_);
                boolean east = (Boolean)state.m_61143_((Property)PaneFrameBlock.f_52310_);
                boolean south = (Boolean)state.m_61143_((Property)PaneFrameBlock.f_52311_);
                boolean west = (Boolean)state.m_61143_((Property)PaneFrameBlock.f_52312_);
                boolean renderNorth = (Boolean)extraData.getData(FrameBlockTile.NORTH_VISIBLE);
                boolean renderEast = (Boolean)extraData.getData(FrameBlockTile.EAST_VISIBLE);
                boolean renderSouth = (Boolean)extraData.getData(FrameBlockTile.SOUTH_VISIBLE);
                boolean renderWest = (Boolean)extraData.getData(FrameBlockTile.WEST_VISIBLE);
                boolean renderUp = (Boolean)extraData.getData(FrameBlockTile.UP_VISIBLE);
                boolean renderDown = (Boolean)extraData.getData(FrameBlockTile.DOWN_VISIBLE);
                int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                if (design == 0) {
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, renderUp, renderDown));
                    if (north) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 1.0f, 0.0f, 0.4375f, texture, tintIndex, renderNorth, false, true, true, true, true));
                    }
                    if (east) {
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 1.0f, 0.0f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, true, true));
                    }
                    if (south) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 1.0f, 0.5625f, 1.0f, texture, tintIndex, false, renderSouth, true, true, true, true));
                    }
                    if (west) {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.4375f, 0.0f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, true, true));
                    }
                } else if (design == 1) {
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, false, renderDown));
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.125f, 0.875f, 0.4375f, 0.5625f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, renderUp, false));
                    if (north) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.125f, 0.4375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.125f, 0.4375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.0f, 0.125f, texture, tintIndex, renderNorth, false, true, true, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.125f, 0.875f, 0.0f, 0.125f, texture, tintIndex, renderNorth, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.0f, 0.125f, texture, tintIndex, renderNorth, false, true, true, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.125f, 0.875f, 0.125f, 0.4375f, glass, -1, false, false, true, true, false, false));
                    }
                    if (east) {
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.875f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.875f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.125f, 0.875f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.875f, 0.125f, 0.875f, 0.46875f, 0.53125f, glass, -1, true, true, false, false, false, false));
                    }
                    if (south) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.5625f, 0.875f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.5625f, 0.875f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.875f, 1.0f, texture, tintIndex, false, renderSouth, true, true, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.125f, 0.875f, 0.875f, 1.0f, texture, tintIndex, false, renderSouth, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.875f, 1.0f, texture, tintIndex, false, renderSouth, true, true, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.125f, 0.875f, 0.5625f, 0.875f, glass, -1, false, false, true, true, false, false));
                    }
                    if (west) {
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.4375f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.4375f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.125f, 0.875f, 0.4375f, 0.5625f, texture, tintIndex, true, true, true, renderWest, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.4375f, 0.125f, 0.875f, 0.46875f, 0.53125f, glass, -1, true, true, false, false, false, false));
                    }
                } else if (design == 2) {
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, true, renderDown));
                    quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.125f, 0.875f, 0.46875f, 0.53125f, glass, -1, !north, !south, !east, !west, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, renderUp, true));
                    if (north) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.0f, 0.4375f, texture, tintIndex, renderNorth, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.0f, 0.4375f, texture, tintIndex, renderNorth, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.125f, 0.875f, 0.0f, 0.46875f, glass, -1, renderNorth, false, true, true, false, false));
                    }
                    if (east) {
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 1.0f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 1.0f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.53125f, 1.0f, 0.125f, 0.875f, 0.46875f, 0.53125f, glass, -1, true, true, renderEast, false, false, false));
                    }
                    if (south) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.5625f, 1.0f, texture, tintIndex, false, renderSouth, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.5625f, 1.0f, texture, tintIndex, false, renderSouth, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.125f, 0.875f, 0.53125f, 1.0f, glass, -1, false, renderSouth, true, true, false, false));
                    }
                    if (west) {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.4375f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.4375f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.46875f, 0.125f, 0.875f, 0.46875f, 0.53125f, glass, -1, true, true, false, false, false, false));
                    }
                } else if (design == 3) {
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, true, renderDown));
                    quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.125f, 0.875f, 0.46875f, 0.53125f, glass, -1, !north, !south, !east, !west, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, renderUp, true));
                    if (north) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.125f, 0.4375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.125f, 0.4375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.0f, 0.125f, texture, tintIndex, renderNorth, false, true, true, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.125f, 0.875f, 0.0f, 0.125f, texture, tintIndex, renderNorth, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.0f, 0.125f, texture, tintIndex, renderNorth, false, true, true, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.125f, 0.875f, 0.125f, 0.46875f, glass, -1, false, false, true, true, false, false));
                    }
                    if (east) {
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.875f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.875f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.125f, 0.875f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.53125f, 0.875f, 0.125f, 0.875f, 0.46875f, 0.53125f, glass, -1, true, true, false, false, false, false));
                    }
                    if (south) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.5625f, 0.875f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.5625f, 0.875f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.125f, 0.875f, 1.0f, texture, tintIndex, false, renderSouth, true, true, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.125f, 0.875f, 0.875f, 1.0f, texture, tintIndex, false, renderSouth, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.875f, 1.0f, 0.875f, 1.0f, texture, tintIndex, false, renderSouth, true, true, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.125f, 0.875f, 0.53125f, 0.875f, glass, -1, false, false, true, true, false, false));
                    }
                    if (west) {
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.4375f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.4375f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 0.125f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.125f, 0.875f, 0.4375f, 0.5625f, texture, tintIndex, true, true, true, renderWest, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.875f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.46875f, 0.125f, 0.875f, 0.46875f, 0.53125f, glass, -1, true, true, false, false, false, false));
                    }
                } else if (design == 4) {
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.0625f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, true, renderDown));
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0625f, 0.9375f, 0.4375f, 0.5625f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.9375f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, !north, !south, !east, !west, renderUp, true));
                    if (north) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.0625f, 0.0625f, 0.4375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.9375f, 1.0f, 0.0625f, 0.4375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.0625f, 0.0f, 0.0625f, texture, tintIndex, renderNorth, false, true, true, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0625f, 0.9375f, 0.0f, 0.0625f, texture, tintIndex, renderNorth, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.9375f, 1.0f, 0.0f, 0.0625f, texture, tintIndex, renderNorth, false, true, true, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.4375f, 0.5625f, 0.0625f, 0.4375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.0625f, 0.9375f, 0.0625f, 0.4375f, glass, -1, false, false, true, true, false, false));
                    }
                    if (east) {
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.9375f, 0.0f, 0.0625f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.9375f, 0.9375f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0f, 0.0625f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0625f, 0.9375f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.9375f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, renderEast, false, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.9375f, 0.4375f, 0.5625f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.5625f, 0.9375f, 0.0625f, 0.9375f, 0.46875f, 0.53125f, glass, -1, true, true, false, false, false, false));
                    }
                    if (south) {
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.0625f, 0.5625f, 0.9375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.9375f, 1.0f, 0.5625f, 0.9375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0f, 0.0625f, 0.9375f, 1.0f, texture, tintIndex, false, renderSouth, true, true, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.0625f, 0.9375f, 0.9375f, 1.0f, texture, tintIndex, false, renderSouth, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.9375f, 1.0f, 0.9375f, 1.0f, texture, tintIndex, false, renderSouth, true, true, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.4375f, 0.5625f, 0.5625f, 0.9375f, texture, tintIndex, false, false, true, true, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.46875f, 0.53125f, 0.0625f, 0.9375f, 0.5625f, 0.9375f, glass, -1, false, false, true, true, false, false));
                    }
                    if (west) {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.4375f, 0.0f, 0.0625f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.4375f, 0.9375f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0f, 0.0625f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, false, renderDown));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0625f, 0.9375f, 0.4375f, 0.5625f, texture, tintIndex, true, true, true, renderWest, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.9375f, 1.0f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, renderWest, renderUp, false));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.4375f, 0.4375f, 0.5625f, 0.4375f, 0.5625f, texture, tintIndex, true, true, false, false, true, true));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.4375f, 0.0625f, 0.9375f, 0.46875f, 0.53125f, glass, -1, true, true, false, false, false, false));
                    }
                }
                if ((overlayIndex = ((Integer)extraData.getData(FrameBlockTile.OVERLAY)).intValue()) != 0) {
                    quads.addAll(ModelHelper.createOverlay(0.4375f, 0.5625f, 0.0f, 1.0f, 0.4375f, 0.5625f, overlayIndex, !north, !south, !east, !west, renderUp, renderDown, true));
                    if (north) {
                        quads.addAll(ModelHelper.createOverlay(0.4375f, 0.5625f, 0.0f, 1.0f, 0.0f, 0.4375f, overlayIndex, renderNorth, false, true, true, renderUp, renderDown, true));
                    }
                    if (east) {
                        quads.addAll(ModelHelper.createOverlay(0.5625f, 1.0f, 0.0f, 1.0f, 0.4375f, 0.5625f, overlayIndex, true, true, renderEast, false, renderUp, renderDown, true));
                    }
                    if (south) {
                        quads.addAll(ModelHelper.createOverlay(0.4375f, 0.5625f, 0.0f, 1.0f, 0.5625f, 1.0f, overlayIndex, false, renderSouth, true, true, renderUp, renderDown, true));
                    }
                    if (west) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.4375f, 0.0f, 1.0f, 0.4375f, 0.5625f, overlayIndex, true, true, false, renderWest, renderUp, renderDown, true));
                    }
                }
                return quads;
            }
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

