/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.LayeredBlock;
import mod.pianomanu.blockcarpentry.block.SixWaySlabFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class LayeredBlockBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side == null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        int tex = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
        if (mimic != null && state != null) {
            List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
            if (textureList.size() <= tex) {
                extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                tex = 0;
            }
            if (textureList.size() == 0) {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.block_not_available"), true);
                }
                return Collections.emptyList();
            }
            TextureAtlasSprite texture = textureList.get(tex);
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int layers = (Integer)state.m_61143_((Property)LayeredBlock.LAYERS);
            float layerHeight = (float)layers / 8.0f;
            boolean renderNorth = side == Direction.NORTH && (Boolean)extraData.getData(FrameBlockTile.NORTH_VISIBLE) != false;
            boolean renderEast = side == Direction.EAST && (Boolean)extraData.getData(FrameBlockTile.EAST_VISIBLE) != false;
            boolean renderSouth = side == Direction.SOUTH && (Boolean)extraData.getData(FrameBlockTile.SOUTH_VISIBLE) != false;
            boolean renderWest = side == Direction.WEST && (Boolean)extraData.getData(FrameBlockTile.WEST_VISIBLE) != false;
            boolean renderUp = side == Direction.UP && (Boolean)extraData.getData(FrameBlockTile.UP_VISIBLE) != false;
            boolean renderDown = side == Direction.DOWN && (Boolean)extraData.getData(FrameBlockTile.DOWN_VISIBLE) != false;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                case UP: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 1.0f - layerHeight, 1.0f, 0.0f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case DOWN: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, layerHeight, 0.0f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case WEST: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, layerHeight, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case SOUTH: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 1.0f - layerHeight, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case NORTH: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, layerHeight, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case EAST: {
                    quads.addAll(ModelHelper.createCuboid(1.0f - layerHeight, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown));
                }
            }
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            if ((Integer)extraData.getData(FrameBlockTile.OVERLAY) != 0) {
                switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                    case UP: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 1.0f - layerHeight, 1.0f, 0.0f, 1.0f, overlayIndex, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case DOWN: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, layerHeight, 0.0f, 1.0f, overlayIndex, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, layerHeight, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 1.0f - layerHeight, 1.0f, overlayIndex, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, layerHeight, overlayIndex, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createOverlay(1.0f - layerHeight, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

