/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.bakedmodels.helper.DoorKnobBakedModel;
import mod.pianomanu.blockcarpentry.block.DoorFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class DoorBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        int tex = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
        if (mimic != null && state != null && extraData.getData(FrameBlockTile.DESIGN) != null && extraData.getData(FrameBlockTile.DESIGN_TEXTURE) != null) {
            int overlayIndex;
            boolean eastSide;
            List<TextureAtlasSprite> glassBlockList = TextureHelper.getGlassTextures();
            TextureAtlasSprite glass = glassBlockList.get((Integer)extraData.getData(FrameBlockTile.GLASS_COLOR));
            List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
            if (textureList.size() <= tex) {
                extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                tex = 0;
            }
            if (textureList.size() == 0) {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.block_not_available"), true);
                }
                return Collections.emptyList();
            }
            TextureAtlasSprite texture = textureList.get(tex);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            Direction dir = (Direction)state.m_61143_((Property)DoorFrameBlock.f_52726_);
            boolean open = (Boolean)state.m_61143_((Property)DoorFrameBlock.f_52727_);
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorFrameBlock.f_52728_);
            Direction west = Direction.WEST;
            Direction east = Direction.EAST;
            Direction north = Direction.NORTH;
            Direction south = Direction.SOUTH;
            DoorHingeSide left = DoorHingeSide.LEFT;
            DoorHingeSide right = DoorHingeSide.RIGHT;
            int design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
            int desTex = (Integer)extraData.getData(FrameBlockTile.DESIGN_TEXTURE);
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_);
            DoubleBlockHalf lower = DoubleBlockHalf.LOWER;
            DoubleBlockHalf upper = DoubleBlockHalf.UPPER;
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            boolean northSide = dir == north && !open && hinge == right || dir == east && open && hinge == right || dir == west && open && hinge == left || dir == north && !open && hinge == left;
            boolean westSide = dir == west && !open && hinge == right || dir == north && open && hinge == right || dir == south && open && hinge == left || dir == west && !open && hinge == left;
            boolean bl = eastSide = dir == south && open && hinge == right || dir == east && !open && hinge == right || dir == east && !open && hinge == left || dir == north && open && hinge == left;
            if (design == 0) {
                if (northSide) {
                    if (half == lower) {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.25f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.25f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.0f, 0.25f, 0.8125f, 1.0f, texture, tintIndex, true, true, false, true, false, true));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.0f, 0.25f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, false, false, true));
                        quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.25f, 1.0f, 0.875f, 0.9375f, glass, -1));
                        quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 0.25f, 0.8125f, 1.0f, texture, tintIndex, true, true, false, false, true, true));
                    }
                    if (half == upper) {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.75f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, false, true, true, false));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.75f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, false, true, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.0f, 0.75f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.0f, 0.75f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 0.75f, 0.875f, 0.9375f, glass, -1));
                        quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.75f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, false, false, true, true));
                    }
                } else if (westSide) {
                    if (half == lower) {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.25f, 1.0f, 0.75f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.25f, 1.0f, 0.0f, 0.25f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.25f, 0.75f, 1.0f, texture, tintIndex, false, true, true, true, false, true));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.25f, 0.0f, 0.25f, texture, tintIndex, true, false, true, true, false, true));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.25f, 1.0f, 0.25f, 0.75f, glass, -1));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.25f, 0.25f, 0.75f, texture, tintIndex, false, false, true, true, true, true));
                    }
                    if (half == upper) {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.75f, 1.0f, 0.75f, 1.0f, texture, tintIndex, false, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.75f, 1.0f, 0.0f, 0.25f, texture, tintIndex, true, false, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.75f, 0.75f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.75f, 0.0f, 0.25f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0f, 0.75f, 0.25f, 0.75f, glass, -1));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.75f, 1.0f, 0.25f, 0.75f, texture, tintIndex, false, false, true, true, true, true));
                    }
                } else if (eastSide) {
                    if (half == lower) {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.25f, 1.0f, 0.75f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.25f, 1.0f, 0.0f, 0.25f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.25f, 0.75f, 1.0f, texture, tintIndex, false, true, true, true, false, true));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.25f, 0.0f, 0.25f, texture, tintIndex, true, false, true, true, false, true));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.25f, 1.0f, 0.25f, 0.75f, glass, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.25f, 0.25f, 0.75f, texture, tintIndex, false, false, true, true, true, true));
                    }
                    if (half == upper) {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.75f, 1.0f, 0.75f, 1.0f, texture, tintIndex, false, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.75f, 1.0f, 0.0f, 0.25f, texture, tintIndex, true, false, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.75f, 0.75f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.75f, 0.0f, 0.25f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0f, 0.75f, 0.25f, 0.75f, glass, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.75f, 1.0f, 0.25f, 0.75f, texture, tintIndex, false, false, true, true, true, true));
                    }
                } else {
                    if (half == lower) {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.25f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.25f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.0f, 0.25f, 0.0f, 0.1875f, texture, tintIndex, true, true, false, true, false, true));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.0f, 0.25f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, false, false, true));
                        quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.25f, 1.0f, 0.0625f, 0.125f, glass, -1));
                        quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 0.25f, 0.0f, 0.1875f, texture, tintIndex, true, true, false, false, true, true));
                    }
                    if (half == upper) {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.75f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, false, true, true, false));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.75f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, false, true, false));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.0f, 0.75f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.0f, 0.75f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, true, false, false));
                        quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 0.75f, 0.0625f, 0.125f, glass, -1));
                        quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.75f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, false, false, true, true));
                    }
                }
            }
            if (design == 3) {
                if (northSide) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.0f, 0.25f, 0.8125f, 1.0f, texture, tintIndex, true, true, false, true, false, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.25f, 0.75f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.75f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, false, true, half == upper, false));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.0f, 0.25f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, false, false, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.25f, 0.75f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.75f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, false, half == upper, false));
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.25f, 0.75f, 0.875f, 0.9375f, glass, -1));
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 0.25f, 0.8125f, 1.0f, texture, tintIndex, true, true, false, false, true, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.75f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, false, false, half == upper, true));
                } else if (westSide) {
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.25f, 0.75f, 1.0f, texture, tintIndex, false, true, true, true, false, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.25f, 0.75f, 0.75f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.75f, 1.0f, 0.75f, 1.0f, texture, tintIndex, false, true, true, true, half == upper, false));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.25f, 0.0f, 0.25f, texture, tintIndex, true, false, true, true, false, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.25f, 0.75f, 0.0f, 0.25f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.75f, 1.0f, 0.0f, 0.25f, texture, tintIndex, true, false, true, true, half == upper, false));
                    quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.25f, 0.75f, 0.25f, 0.75f, glass, -1));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.25f, 0.25f, 0.75f, texture, tintIndex, false, false, true, true, true, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.75f, 1.0f, 0.25f, 0.75f, texture, tintIndex, false, false, true, true, half == upper, true));
                } else if (eastSide) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.25f, 0.75f, 1.0f, texture, tintIndex, false, true, true, true, false, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.25f, 0.75f, 0.75f, 1.0f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.75f, 1.0f, 0.75f, 1.0f, texture, tintIndex, false, true, true, true, half == upper, false));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.25f, 0.0f, 0.25f, texture, tintIndex, true, false, true, true, false, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.25f, 0.75f, 0.0f, 0.25f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.75f, 1.0f, 0.0f, 0.25f, texture, tintIndex, true, false, true, true, half == upper, false));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.25f, 0.75f, 0.25f, 0.75f, glass, -1));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.25f, 0.25f, 0.75f, texture, tintIndex, false, false, true, true, true, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.75f, 1.0f, 0.25f, 0.75f, texture, tintIndex, false, false, true, true, half == upper, true));
                } else {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.0f, 0.25f, 0.0f, 0.1875f, texture, tintIndex, true, true, false, true, false, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.25f, 0.75f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.75f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, false, true, half == upper, false));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.0f, 0.25f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, false, false, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.25f, 0.75f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, true, false, false));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.75f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, false, half == upper, false));
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.25f, 0.75f, 0.0625f, 0.125f, glass, -1));
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 0.25f, 0.0f, 0.1875f, texture, tintIndex, true, true, false, false, true, half == lower));
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.75f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, false, false, half == upper, true));
                }
            }
            if (design == 1 || design == 2) {
                int flag = 0;
                if (northSide) {
                    flag = 1;
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, true, half == upper, half == lower));
                } else if (westSide) {
                    flag = 2;
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex, true, true, true, true, half == upper, half == lower));
                } else if (eastSide) {
                    flag = 3;
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex, true, true, true, true, half == upper, half == lower));
                } else {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, true, half == upper, half == lower));
                }
                if (design == 1) {
                    if (half == lower) {
                        if (dir == south && hinge == left && !open || dir == west && hinge == right && open) {
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.125f, 0.25f, 0.9375f, 1.0625f, -0.0625f, 0.0625f, flag, desTex));
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.125f, 0.25f, 0.9375f, 1.0625f, 0.125f, 0.25f, flag, desTex));
                        } else if (dir == south && hinge == right && !open || dir == east && hinge == left && open) {
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.75f, 0.875f, 0.9375f, 1.0625f, -0.0625f, 0.0625f, flag, desTex));
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.75f, 0.875f, 0.9375f, 1.0625f, 0.125f, 0.25f, flag, desTex));
                        }
                    }
                    if (half == lower) {
                        if (dir == north && hinge == right && !open || dir == west && hinge == left && open) {
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.125f, 0.25f, 0.9375f, 1.0625f, 0.9375f, 1.0625f, flag, desTex));
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.125f, 0.25f, 0.9375f, 1.0625f, 0.75f, 0.875f, flag, desTex));
                        } else if (dir == north && hinge == left && !open || dir == east && hinge == right && open) {
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.75f, 0.875f, 0.9375f, 1.0625f, 0.9375f, 1.0625f, flag, desTex));
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.75f, 0.875f, 0.9375f, 1.0625f, 0.75f, 0.875f, flag, desTex));
                        }
                    }
                    if (half == lower) {
                        if (dir == west && hinge == left && !open || dir == north && hinge == right && open) {
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.9375f, 1.0625f, 0.9375f, 1.0625f, 0.125f, 0.25f, flag, desTex));
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.75f, 0.875f, 0.9375f, 1.0625f, 0.125f, 0.25f, flag, desTex));
                        } else if (dir == west && hinge == right && !open || dir == south && hinge == left && open) {
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.9375f, 1.0625f, 0.9375f, 1.0625f, 0.75f, 0.875f, flag, desTex));
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.75f, 0.875f, 0.9375f, 1.0625f, 0.75f, 0.875f, flag, desTex));
                        }
                    }
                    if (half == lower) {
                        if (dir == east && hinge == right && !open || dir == north && hinge == left && open) {
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(-0.0625f, 0.0625f, 0.9375f, 1.0625f, 0.125f, 0.25f, flag, desTex));
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.125f, 0.25f, 0.9375f, 1.0625f, 0.125f, 0.25f, flag, desTex));
                        } else if (dir == east && hinge == left && !open || dir == south && hinge == right && open) {
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(-0.0625f, 0.0625f, 0.9375f, 1.0625f, 0.75f, 0.875f, flag, desTex));
                            quads.addAll(DoorKnobBakedModel.createDoorKnob(0.125f, 0.25f, 0.9375f, 1.0625f, 0.75f, 0.875f, flag, desTex));
                        }
                    }
                }
            }
            if (design == 4) {
                if (northSide) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.1875f, 0.8125f, 0.875f, 0.9375f, glass, -1));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.8125f, 1.0f, 0.8125f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.1875f, 0.8125f, 0.8125f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.4375f, 0.5625f, 0.8125f, 1.0f, texture, tintIndex));
                } else if (westSide) {
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.1875f, 0.8125f, 0.1875f, 0.8125f, glass, -1));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.1875f, 0.8125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.8125f, 1.0f, 0.1875f, 0.8125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.1875f, 0.8125f, 0.4375f, 0.5625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.4375f, 0.5625f, 0.1875f, 0.8125f, texture, tintIndex));
                } else if (eastSide) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.1875f, 0.8125f, 0.1875f, 0.8125f, glass, -1));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.1875f, 0.8125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.8125f, 1.0f, 0.1875f, 0.8125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.1875f, 0.8125f, 0.4375f, 0.5625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.4375f, 0.5625f, 0.1875f, 0.8125f, texture, tintIndex));
                } else {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.1875f, 0.8125f, 0.0625f, 0.125f, glass, -1));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.8125f, 1.0f, 0.0f, 0.1875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.1875f, 0.8125f, 0.0f, 0.1875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.4375f, 0.5625f, 0.0f, 0.1875f, texture, tintIndex));
                }
            }
            if ((overlayIndex = ((Integer)extraData.getData(FrameBlockTile.OVERLAY)).intValue()) != 0) {
                if (northSide) {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, overlayIndex));
                } else if (westSide) {
                    quads.addAll(ModelHelper.createOverlay(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                } else if (eastSide) {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                } else {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, overlayIndex));
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

