/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.infuser.blocks;

import java.util.Optional;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.TagTools;
import mcjty.rftoolsbase.modules.infuser.MachineInfuserConfiguration;
import mcjty.rftoolsbase.modules.infuser.MachineInfuserModule;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class MachineInfuserTileEntity
extends TickingTileEntity {
    public static final int SLOT_SHARDINPUT = 0;
    public static final int SLOT_MACHINEOUTPUT = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(MachineInfuserTileEntity::isShard).in(), 0, 64, 24).slot(SlotDefinition.specific(MachineInfuserTileEntity::isInfusable).in().out(), 1, 118, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).insertable((slot, stack) -> {
        if (slot == 1) {
            return MachineInfuserTileEntity.isInfusable(stack);
        }
        return MachineInfuserTileEntity.isShard(stack);
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)MachineInfuserConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)MachineInfuserConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Machine Infuser").containerSupplier(DefaultContainerProvider.container(MachineInfuserModule.CONTAINER_MACHINE_INFUSER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((BlockEntity)this));
    private int infusing = 0;

    public MachineInfuserTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachineInfuserModule.TYPE_MACHINE_INFUSER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MachineInfuserTileEntity::new).infusable().manualEntry(ManualHelper.create("rftoolsbase:machines/infusing")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public void tickServer() {
        if (this.infusing > 0) {
            --this.infusing;
            if (this.infusing == 0) {
                ItemStack outputStack = this.items.getStackInSlot(1);
                this.finishInfusing(outputStack);
            }
            this.markDirtyQuick();
        } else {
            ItemStack inputStack = this.items.getStackInSlot(0);
            ItemStack outputStack = this.items.getStackInSlot(1);
            if (MachineInfuserTileEntity.isShard(inputStack) && MachineInfuserTileEntity.isInfusable(outputStack)) {
                this.startInfusing();
            }
        }
    }

    private static boolean isShard(ItemStack stack) {
        return TagTools.hasTag((Item)stack.m_41720_(), VariousModule.SHARDS_TAG);
    }

    private static boolean isInfusable(ItemStack stack) {
        return MachineInfuserTileEntity.getStackIfInfusable(stack).map(s -> BaseBlock.getInfused((ItemStack)s) < (Integer)MachineInfuserConfiguration.MAX_INFUSE.get()).orElse(false);
    }

    @Nonnull
    private static Optional<ItemStack> getStackIfInfusable(ItemStack stack) {
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        Block block = ((BlockItem)item).m_40614_();
        if (block instanceof BaseBlock && ((BaseBlock)block).isInfusable()) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    private void finishInfusing(ItemStack stack) {
        MachineInfuserTileEntity.getStackIfInfusable(stack).ifPresent(s -> BaseBlock.setInfused((ItemStack)s, (int)(BaseBlock.getInfused((ItemStack)s) + 1)));
    }

    private void startInfusing() {
        int defaultCost = (Integer)MachineInfuserConfiguration.RFPERTICK.get();
        int rf = this.infusableHandler.map(h -> (int)((float)defaultCost * (2.0f - h.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
        if (this.energyStorage.getEnergy() < (long)rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rf);
        this.items.getStackInSlot(0).m_41620_(1);
        if (this.items.getStackInSlot(0).m_41619_()) {
            this.items.setStackInSlot(0, ItemStack.f_41583_);
        }
        this.infusing = 5;
        this.markDirtyQuick();
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.infusing = tagCompound.m_128469_("Info").m_128451_("infusing");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        this.getOrCreateInfo(tagCompound).m_128405_("infusing", this.infusing);
    }
}

