/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.fluid;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.FacingHandlerScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.SidedComponentManager;
import com.hrznstudio.titanium.util.FacingUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SidedFluidTankComponent<T extends IComponentHarness>
extends FluidTankComponent<T>
implements IFacingComponent,
IScreenAddonProvider {
    private int color = DyeColor.WHITE.m_41070_();
    private int facingHandlerX = 8;
    private int facingHandlerY = 84;
    private HashMap<FacingUtil.Sideness, IFacingComponent.FaceMode> facingModes = new HashMap();
    private int pos;
    private boolean hasFacingAddon;
    private IFacingComponent.FaceMode[] validFaceModes;

    public SidedFluidTankComponent(String name, int amount, int posX, int posY, int pos) {
        super(name, amount, posX, posY);
        this.pos = pos;
        for (FacingUtil.Sideness facing : FacingUtil.Sideness.values()) {
            this.facingModes.put(facing, IFacingComponent.FaceMode.ENABLED);
        }
        this.hasFacingAddon = true;
        this.validFaceModes = IFacingComponent.FaceMode.values();
    }

    public SidedFluidTankComponent<T> disableFacingAddon() {
        this.hasFacingAddon = false;
        return this;
    }

    public HashMap<FacingUtil.Sideness, IFacingComponent.FaceMode> getFacingModes() {
        return this.facingModes;
    }

    @Override
    public int getColor() {
        return new Color(this.color).getRGB();
    }

    public SidedFluidTankComponent<T> setColor(int color) {
        this.color = color;
        return this;
    }

    public SidedFluidTankComponent<T> setColor(DyeColor color) {
        this.color = color.m_41070_();
        return this;
    }

    @Override
    public Rectangle getRectangle(IAsset asset) {
        return new Rectangle(this.getPosX() - 2, this.getPosY() - 2, (int)asset.getArea().getWidth() + 3, (int)asset.getArea().getHeight() + 3);
    }

    @Override
    public int getFacingHandlerX() {
        return this.facingHandlerX;
    }

    @Override
    public int getFacingHandlerY() {
        return this.facingHandlerY;
    }

    @Override
    public boolean work(Level world, BlockPos pos, Direction blockFacing, int workAmount) {
        boolean hasWorked;
        Direction real;
        BlockEntity entity;
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            if (!this.facingModes.get((Object)sideness).equals((Object)IFacingComponent.FaceMode.PUSH) || (entity = world.m_7702_(pos.m_142300_(real = FacingUtil.getFacingFromSide(blockFacing, sideness)))) == null || !(hasWorked = entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, real.m_122424_()).map(iFluidHandler -> this.transfer((IFluidHandler)this, (IFluidHandler)iFluidHandler, workAmount)).orElse(false).booleanValue())) continue;
            return true;
        }
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            if (!this.facingModes.get((Object)sideness).equals((Object)IFacingComponent.FaceMode.PULL) || (entity = world.m_7702_(pos.m_142300_(real = FacingUtil.getFacingFromSide(blockFacing, sideness)))) == null || !(hasWorked = entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, real.m_122424_()).map(iFluidHandler -> this.transfer((IFluidHandler)iFluidHandler, (IFluidHandler)this, workAmount)).orElse(false).booleanValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public SidedFluidTankComponent<T> setFacingHandlerPos(int x, int y) {
        this.facingHandlerX = x;
        this.facingHandlerY = y;
        return this;
    }

    @Override
    public IFacingComponent.FaceMode[] getValidFacingModes() {
        return this.validFaceModes;
    }

    public SidedFluidTankComponent<T> setValidFaceModes(IFacingComponent.FaceMode ... validFaceModes) {
        this.validFaceModes = validFaceModes;
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.facingModes.put(value, validFaceModes[0]);
        }
        return this;
    }

    private boolean transfer(IFluidHandler from, IFluidHandler to, int workAmount) {
        FluidStack stack = from.drain(workAmount * 100, IFluidHandler.FluidAction.SIMULATE);
        if (!stack.isEmpty()) {
            return !(stack = from.drain(to.fill(stack, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)).isEmpty();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        List<IFactory<? extends IScreenAddon>> addons = super.getScreenAddons();
        if (this.hasFacingAddon) {
            addons.add(() -> new FacingHandlerScreenAddon(SidedComponentManager.ofRight(this.getFacingHandlerX(), this.getFacingHandlerY(), this.pos, AssetTypes.BUTTON_SIDENESS_MANAGER, 4), this, this.getTankType().getAssetType(), this.getComponentHarness() instanceof ActiveTile ? ((ActiveTile)this.getComponentHarness()).getFacingDirection() : Direction.NORTH));
        }
        return addons;
    }

    public FluidTank readFromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("FacingModes")) {
            CompoundTag compound = nbt.m_128469_("FacingModes");
            for (String face : compound.m_128431_()) {
                this.facingModes.put(FacingUtil.Sideness.valueOf(face), IFacingComponent.FaceMode.valueOf(compound.m_128461_(face)));
            }
        }
        return super.readFromNBT(nbt);
    }

    public CompoundTag writeToNBT(CompoundTag comp) {
        CompoundTag nbt = super.writeToNBT(comp);
        CompoundTag compound = new CompoundTag();
        for (FacingUtil.Sideness facing : this.facingModes.keySet()) {
            compound.m_128359_(facing.name(), this.facingModes.get((Object)facing).name());
        }
        nbt.m_128365_("FacingModes", (Tag)compound);
        return nbt;
    }
}

