/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easy_villagers.corelib.entity.EntityUtils;
import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easy_villagers.corelib.net.NetUtils;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.MultiItemStackHandler;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.FoodSlot;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.net.MessageVillagerParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class BreederTileentity
extends FakeWorldTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> foodInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected NonNullList<ItemStack> outputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected ItemStack villager1 = ItemStack.f_41583_;
    protected EasyVillagerEntity villagerEntity1;
    protected ItemStack villager2 = ItemStack.f_41583_;
    protected EasyVillagerEntity villagerEntity2;
    protected LazyOptional<MultiItemStackHandler> itemHandler = LazyOptional.of(() -> new MultiItemStackHandler(this.foodInventory, this.outputInventory, FoodSlot::isValid));

    public BreederTileentity(BlockPos pos, BlockState state) {
        super(ModTileEntities.BREEDER, ModBlocks.BREEDER.m_49966_(), pos, state);
    }

    public ItemStack getVillager1() {
        return this.villager1;
    }

    public ItemStack getVillager2() {
        return this.villager2;
    }

    public boolean hasVillager1() {
        return !this.villager1.m_41619_();
    }

    public boolean hasVillager2() {
        return !this.villager2.m_41619_();
    }

    public EasyVillagerEntity getVillagerEntity1() {
        if (this.villagerEntity1 == null && !this.villager1.m_41619_()) {
            this.villagerEntity1 = ModItems.VILLAGER.getVillager(this.f_58857_, this.villager1);
        }
        return this.villagerEntity1;
    }

    public EasyVillagerEntity getVillagerEntity2() {
        if (this.villagerEntity2 == null && !this.villager2.m_41619_()) {
            this.villagerEntity2 = ModItems.VILLAGER.getVillager(this.f_58857_, this.villager2);
        }
        return this.villagerEntity2;
    }

    public void setVillager1(ItemStack villager) {
        this.villager1 = villager;
        this.villagerEntity1 = villager.m_41619_() ? null : ModItems.VILLAGER.getVillager(this.f_58857_, villager);
        this.m_6596_();
        this.sync();
    }

    public void setVillager2(ItemStack villager) {
        this.villager2 = villager;
        this.villagerEntity2 = villager.m_41619_() ? null : ModItems.VILLAGER.getVillager(this.f_58857_, villager);
        this.m_6596_();
        this.sync();
    }

    public ItemStack removeVillager1() {
        ItemStack v = this.villager1;
        this.setVillager1(ItemStack.f_41583_);
        return v;
    }

    public ItemStack removeVillager2() {
        ItemStack v = this.villager2;
        this.setVillager2(ItemStack.f_41583_);
        return v;
    }

    @Override
    public void tickServer() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean age1 = VillagerTileentity.advanceAge(this.getVillagerEntity1());
        boolean age2 = VillagerTileentity.advanceAge(this.getVillagerEntity2());
        if (age1 || age2) {
            this.sync();
        }
        if (this.hasVillager1() || this.hasVillager2()) {
            this.m_6596_();
            VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12503_);
        }
        if (this.f_58857_.m_46467_() % (long)((Integer)Main.SERVER_CONFIG.breedingTime.get()).intValue() == 0L) {
            this.tryBreed();
        }
    }

    public void tryBreed() {
        if (this.canBreed() && this.addVillager()) {
            this.removeBreedingItems();
            VillagerBlockBase.playVillagerSound(this.f_58857_, this.f_58858_, SoundEvents.f_12504_);
            this.spawnParticles();
        }
    }

    public void spawnParticles() {
        if (this.f_58857_.f_46443_) {
            for (int i = 0; i < 5; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, (double)this.f_58858_.m_123341_() + (this.f_58857_.f_46441_.nextDouble() - 0.5) + 0.5, (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.nextDouble() + 1.0, (double)this.f_58858_.m_123343_() + (this.f_58857_.f_46441_.nextDouble() - 0.5) + 0.5, 0.0, 0.0, 0.0);
            }
        } else {
            MessageVillagerParticles msg = new MessageVillagerParticles(this.f_58858_);
            EntityUtils.forEachPlayerAround((ServerLevel)this.f_58857_, this.f_58858_, 128.0, playerEntity -> NetUtils.sendTo(Main.SIMPLE_CHANNEL, playerEntity, msg));
        }
    }

    private boolean addVillager() {
        for (int i = 0; i < this.outputInventory.size(); ++i) {
            if (!((ItemStack)this.outputInventory.get(i)).m_41619_()) continue;
            EasyVillagerEntity villagerEntity = new EasyVillagerEntity((EntityType<? extends Villager>)EntityType.f_20492_, this.f_58857_);
            villagerEntity.m_141967_(villagerEntity.m_7141_().m_35567_(VillagerType.m_204073_((Holder)this.f_58857_.m_204166_(this.m_58899_()))));
            villagerEntity.m_146762_(-24000);
            ItemStack villager = new ItemStack((ItemLike)ModItems.VILLAGER);
            ModItems.VILLAGER.setVillager(villager, villagerEntity);
            this.outputInventory.set(i, (Object)villager);
            return true;
        }
        return false;
    }

    public boolean canBreed() {
        if (!this.hasVillager1() || !this.hasVillager2()) {
            return false;
        }
        if (this.getVillagerEntity1().m_6162_() || this.getVillagerEntity2().m_6162_()) {
            return false;
        }
        int value = 0;
        for (ItemStack stack : this.foodInventory) {
            value += Villager.f_35369_.getOrDefault(stack.m_41720_(), 0) * stack.m_41613_();
        }
        return value >= 24;
    }

    private void removeBreedingItems() {
        int value = 0;
        for (ItemStack stack : this.foodInventory) {
            for (int i = 0; i < stack.m_41613_(); ++i) {
                stack.m_41774_(1);
                if ((value += Villager.f_35369_.getOrDefault(stack.m_41720_(), 0).intValue()) < 24) continue;
                return;
            }
        }
    }

    protected void m_183515_(CompoundTag compound) {
        CompoundTag comp;
        super.m_183515_(compound);
        if (this.hasVillager1()) {
            comp = new CompoundTag();
            if (this.villagerEntity1 != null) {
                ModItems.VILLAGER.setVillager(this.villager1, this.villagerEntity1);
            }
            this.villager1.m_41739_(comp);
            compound.m_128365_("Villager1", (Tag)comp);
        }
        if (this.hasVillager2()) {
            comp = new CompoundTag();
            if (this.villagerEntity2 != null) {
                ModItems.VILLAGER.setVillager(this.villager2, this.villagerEntity2);
            }
            this.villager2.m_41739_(comp);
            compound.m_128365_("Villager2", (Tag)comp);
        }
        compound.m_128365_("FoodInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.foodInventory, (boolean)true));
        compound.m_128365_("OutputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true));
    }

    public void m_142466_(CompoundTag compound) {
        CompoundTag comp;
        if (compound.m_128441_("Villager1")) {
            comp = compound.m_128469_("Villager1");
            this.villager1 = ItemStack.m_41712_((CompoundTag)comp);
            this.villagerEntity1 = null;
        } else {
            this.removeVillager1();
        }
        if (compound.m_128441_("Villager2")) {
            comp = compound.m_128469_("Villager2");
            this.villager2 = ItemStack.m_41712_((CompoundTag)comp);
            this.villagerEntity2 = null;
        } else {
            this.removeVillager2();
        }
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("FoodInventory"), this.foodInventory);
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("OutputInventory"), this.outputInventory);
        super.m_142466_(compound);
    }

    public Container getFoodInventory() {
        return new ItemListInventory(this.foodInventory, () -> ((BreederTileentity)this).m_6596_());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((BreederTileentity)this).m_6596_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        this.itemHandler.invalidate();
        super.m_7651_();
    }
}

