/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.init;

import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import iskallia.auxiliaryblocks.AuxiliaryBlocks;
import iskallia.auxiliaryblocks.block.BlockRegistryData;
import iskallia.auxiliaryblocks.block.ColoredBlock;
import iskallia.auxiliaryblocks.block.CrystalBlock;
import iskallia.auxiliaryblocks.block.GelatinBlock;
import iskallia.auxiliaryblocks.block.OrientableBlock;
import iskallia.auxiliaryblocks.block.item.CategorizedBlockItem;
import iskallia.auxiliaryblocks.category.BlockCategory;
import iskallia.auxiliaryblocks.category.block.AsphaltBlockCategory;
import iskallia.auxiliaryblocks.category.block.CrystalBlockCategory;
import iskallia.auxiliaryblocks.category.block.GelatinBlockCategory;
import iskallia.auxiliaryblocks.category.block.IndustrialBlockCategory;
import iskallia.auxiliaryblocks.category.block.LabBlockCategory;
import iskallia.auxiliaryblocks.category.block.NaturalBlockCategory;
import iskallia.auxiliaryblocks.category.block.PastelBlockCategory;
import iskallia.auxiliaryblocks.category.block.PlasticBlockCategory;
import iskallia.auxiliaryblocks.category.block.SheetMetalBlockCategory;
import iskallia.auxiliaryblocks.init.ModRegistries;
import iskallia.auxiliaryblocks.util.Log;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static final List<RegistrySupplier<Block>> BLOCKS = new ArrayList<RegistrySupplier<Block>>();
    public static RegistrySupplier<Block> ASPHALT;
    public static RegistrySupplier<Block> ASPHALT_LINE_CENTER;
    public static RegistrySupplier<Block> ASPHALT_LINE_EDGE;
    public static RegistrySupplier<Block> ASPHALT_CAUTION;
    public static RegistrySupplier<Block> DARK_ASPHALT;
    public static RegistrySupplier<Block> DARK_ASPHALT_LINE_CENTER;
    public static RegistrySupplier<Block> DARK_ASPHALT_LINE_EDGE;
    public static RegistrySupplier<Block> DARK_ASPHALT_CAUTION;
    public static RegistrySupplier<Block> LAB_BLUE;
    public static RegistrySupplier<Block> LAB_CHROME;
    public static RegistrySupplier<Block> LAB_CYAN;
    public static RegistrySupplier<Block> LAB_DARK_GRAY;
    public static RegistrySupplier<Block> LAB_DARK_METALLIC;
    public static RegistrySupplier<Block> LAB_GRAY;
    public static RegistrySupplier<Block> LAB_GREEN;
    public static RegistrySupplier<Block> LAB_LIGHT_GRAY;
    public static RegistrySupplier<Block> LAB_LIGHT_METALLIC;
    public static RegistrySupplier<Block> LAB_METALLIC;
    public static RegistrySupplier<Block> LAB_RED;
    public static RegistrySupplier<Block> LAB_YELLOW;
    public static RegistrySupplier<Block> CONCRETE;
    public static RegistrySupplier<Block> REINFORCED_CONCRETE;
    public static RegistrySupplier<Block> NAILED_REINFORCED_CONCRETE;
    public static RegistrySupplier<Block> PLATED_CONCRETE;
    public static RegistrySupplier<Block> RUSTY_SHEET_METAL;
    public static RegistrySupplier<Block> RUSTY_SHEET_METAL_SECTION;
    public static RegistrySupplier<Block> RUSTY_TRAPDOOR;
    public static RegistrySupplier<Block> CONCRETE_VENT;
    public static RegistrySupplier<Block> SHEET_METAL;
    public static RegistrySupplier<Block> SHEET_METAL_SECTION;
    public static RegistrySupplier<Block> BLUE_PASTEL;
    public static RegistrySupplier<Block> GRAY_PASTEL;
    public static RegistrySupplier<Block> GREEN_PASTEL;
    public static RegistrySupplier<Block> ORANGE_PASTEL;
    public static RegistrySupplier<Block> PINK_PASTEL;
    public static RegistrySupplier<Block> PURPLE_PASTEL;
    public static RegistrySupplier<Block> YELLOW_PASTEL;
    public static RegistrySupplier<Block> SMOOTH_BLUE_PASTEL;
    public static RegistrySupplier<Block> SMOOTH_GRAY_PASTEL;
    public static RegistrySupplier<Block> SMOOTH_GREEN_PASTEL;
    public static RegistrySupplier<Block> SMOOTH_ORANGE_PASTEL;
    public static RegistrySupplier<Block> SMOOTH_PINK_PASTEL;
    public static RegistrySupplier<Block> SMOOTH_PURPLE_PASTEL;
    public static RegistrySupplier<Block> SMOOTH_YELLOW_PASTEL;
    public static RegistrySupplier<Block> PLASTIC;
    public static RegistrySupplier<Block> BLUE_PLASTIC;
    public static RegistrySupplier<Block> CYAN_PLASTIC;
    public static RegistrySupplier<Block> DARK_GRAY_PLASTIC;
    public static RegistrySupplier<Block> GREEN_PLASTIC;
    public static RegistrySupplier<Block> LIGHT_GRAY_PLASTIC;
    public static RegistrySupplier<Block> ORANGE_PLASTIC;
    public static RegistrySupplier<Block> PURPLE_PLASTIC;
    public static RegistrySupplier<Block> RED_PLASTIC;
    public static RegistrySupplier<Block> COBBLED_SANDSTONE;
    public static RegistrySupplier<Block> DIRTY_SAND;
    public static RegistrySupplier<Block> MOSSY_DIRT;
    public static RegistrySupplier<Block> MOSSY_STONE;
    public static RegistrySupplier<Block> ROCKY_DIRT;
    public static RegistrySupplier<Block> ROCKY_SAND;
    public static RegistrySupplier<Block> ROCKY_STONE;
    public static RegistrySupplier<Block> BLACK_CRYSTAL;
    public static RegistrySupplier<Block> BLUE_CRYSTAL;
    public static RegistrySupplier<Block> GREEN_CRYSTAL;
    public static RegistrySupplier<Block> INDIGO_CRYSTAL;
    public static RegistrySupplier<Block> ORANGE_CRYSTAL;
    public static RegistrySupplier<Block> RED_CRYSTAL;
    public static RegistrySupplier<Block> VIOLET_CRYSTAL;
    public static RegistrySupplier<Block> WHITE_CRYSTAL;
    public static RegistrySupplier<Block> YELLOW_CRYSTAL;
    public static RegistrySupplier<Block> BLACK_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> BLUE_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> BROWN_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> CYAN_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> GRAY_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> GREEN_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> LIGHT_BLUE_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> LIGHT_GRAY_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> LIME_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> MAGENTA_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> ORANGE_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> PINK_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> PURPLE_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> RED_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> WHITE_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> YELLOW_FRAMELESS_GLASS;
    public static RegistrySupplier<Block> BLUE_GELATIN;
    public static RegistrySupplier<Block> CYAN_GELATIN;
    public static RegistrySupplier<Block> LIME_GELATIN;
    public static RegistrySupplier<Block> MAGENTA_GELATIN;
    public static RegistrySupplier<Block> ORANGE_GELATIN;
    public static RegistrySupplier<Block> PURPLE_GELATIN;
    public static RegistrySupplier<Block> RED_GELATIN;
    public static RegistrySupplier<Block> YELLOW_GELATIN;

    public static void register() {
        Log.info("Registering blocks.");
        ASPHALT = ModBlocks.registerBlock(BlockRegistryData.Builder.create("asphalt").build());
        ASPHALT_LINE_CENTER = ModBlocks.registerBlock(BlockRegistryData.Builder.create("asphalt_line_center").withBlock(OrientableBlock::new).build());
        ASPHALT_LINE_EDGE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("asphalt_line_edge").withBlock(OrientableBlock::new).build());
        ASPHALT_CAUTION = ModBlocks.registerBlock(BlockRegistryData.Builder.create("asphalt_caution").build());
        DARK_ASPHALT = ModBlocks.registerBlock(BlockRegistryData.Builder.create("dark_asphalt").build());
        DARK_ASPHALT_LINE_CENTER = ModBlocks.registerBlock(BlockRegistryData.Builder.create("dark_asphalt_line_center").withBlock(OrientableBlock::new).build());
        DARK_ASPHALT_LINE_EDGE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("dark_asphalt_line_edge").withBlock(OrientableBlock::new).build());
        DARK_ASPHALT_CAUTION = ModBlocks.registerBlock(BlockRegistryData.Builder.create("dark_asphalt_caution").build());
        LAB_BLUE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_blue").withBlock(() -> new ColoredBlock(Color.BLUE, "Blue")).build());
        LAB_CHROME = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_chrome").withBlock(() -> new ColoredBlock(Color.decode("#a0a0a0"), "Chrome")).build());
        LAB_CYAN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_cyan").withBlock(() -> new ColoredBlock(Color.CYAN, "Cyan")).build());
        LAB_DARK_GRAY = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_dark_gray").withBlock(() -> new ColoredBlock(Color.DARK_GRAY, "Dark Gray")).build());
        LAB_DARK_METALLIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_dark_metallic").withBlock(() -> new ColoredBlock(Color.decode("#494949"), "Dark Metallic")).build());
        LAB_GRAY = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_gray").withBlock(() -> new ColoredBlock(Color.GRAY, "Gray")).build());
        LAB_GREEN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_green").withBlock(() -> new ColoredBlock(Color.decode("#718d25"), "Green")).build());
        LAB_LIGHT_GRAY = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_light_gray").withBlock(() -> new ColoredBlock(Color.LIGHT_GRAY, "Light Gray")).build());
        LAB_LIGHT_METALLIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_light_metallic").withBlock(() -> new ColoredBlock(Color.LIGHT_GRAY, "Light Metallic")).build());
        LAB_METALLIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_metallic").withBlock(() -> new ColoredBlock(Color.GRAY, "Metallic")).build());
        LAB_RED = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_red").withBlock(() -> new ColoredBlock(Color.RED, "Red")).build());
        LAB_YELLOW = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lab_yellow").withBlock(() -> new ColoredBlock(Color.YELLOW, "Yellow")).build());
        CONCRETE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("concrete").build());
        REINFORCED_CONCRETE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("reinforced_concrete").build());
        NAILED_REINFORCED_CONCRETE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("nailed_reinforced_concrete").build());
        PLATED_CONCRETE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("plated_concrete").build());
        CONCRETE_VENT = ModBlocks.registerBlock(BlockRegistryData.Builder.create("concrete_vent").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_))).build());
        RUSTY_SHEET_METAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("rusty_sheet_metal").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_))).build());
        RUSTY_SHEET_METAL_SECTION = ModBlocks.registerBlock(BlockRegistryData.Builder.create("rusty_sheet_metal_section").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_))).build());
        SHEET_METAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("sheet_metal").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_))).build());
        SHEET_METAL_SECTION = ModBlocks.registerBlock(BlockRegistryData.Builder.create("sheet_metal_section").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_))).build());
        RUSTY_TRAPDOOR = ModBlocks.registerBlock(BlockRegistryData.Builder.create("rusty_trapdoor").withBlock(() -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50376_).m_60955_())).build());
        BLUE_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("blue_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50509_))).build());
        SMOOTH_BLUE_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("smooth_blue_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50545_))).build());
        GRAY_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("gray_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50514_))).build());
        SMOOTH_GRAY_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("smooth_gray_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50498_))).build());
        GREEN_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("green_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50511_))).build());
        SMOOTH_GREEN_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("smooth_green_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50495_))).build());
        ORANGE_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("orange_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50507_))).build());
        SMOOTH_ORANGE_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("smooth_orange_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50543_))).build());
        PINK_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("pink_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50512_))).build());
        SMOOTH_PINK_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("smooth_pink_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50496_))).build());
        PURPLE_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("purple_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50516_))).build());
        SMOOTH_PURPLE_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("smooth_purple_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50500_))).build());
        YELLOW_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("yellow_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50510_))).build());
        SMOOTH_YELLOW_PASTEL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("smooth_yellow_pastel").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50494_))).build());
        PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50497_))).build());
        BLUE_PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("blue_plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50501_))).build());
        CYAN_PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("cyan_plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50499_))).build());
        DARK_GRAY_PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("dark_gray_plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50505_))).build());
        GREEN_PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("green_plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50503_))).build());
        LIGHT_GRAY_PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("light_gray_plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50498_))).build());
        ORANGE_PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("orange_plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50543_))).build());
        PURPLE_PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("purple_plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50500_))).build());
        RED_PLASTIC = ModBlocks.registerBlock(BlockRegistryData.Builder.create("red_plastic").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50504_))).build());
        COBBLED_SANDSTONE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("cobbled_sandstone").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_))).build());
        DIRTY_SAND = ModBlocks.registerBlock(BlockRegistryData.Builder.create("dirty_sand").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_))).build());
        MOSSY_DIRT = ModBlocks.registerBlock(BlockRegistryData.Builder.create("mossy_dirt").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_))).build());
        MOSSY_STONE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("mossy_stone").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_))).build());
        ROCKY_DIRT = ModBlocks.registerBlock(BlockRegistryData.Builder.create("rocky_dirt").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_))).build());
        ROCKY_SAND = ModBlocks.registerBlock(BlockRegistryData.Builder.create("rocky_sand").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_))).build());
        ROCKY_STONE = ModBlocks.registerBlock(BlockRegistryData.Builder.create("rocky_stone").withBlock(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_))).build());
        BLACK_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("black_crystal").withBlock(() -> new CrystalBlock(DyeColor.BLACK, "Black")).build());
        BLUE_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("blue_crystal").withBlock(() -> new CrystalBlock(DyeColor.CYAN, "Blue")).build());
        GREEN_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("green_crystal").withBlock(() -> new CrystalBlock(DyeColor.GREEN, "Green")).build());
        INDIGO_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("indigo_crystal").withBlock(() -> new CrystalBlock(DyeColor.BLUE, "Indigo")).build());
        ORANGE_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("orange_crystal").withBlock(() -> new CrystalBlock(DyeColor.ORANGE, "Orange")).build());
        RED_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("red_crystal").withBlock(() -> new CrystalBlock(DyeColor.RED, "Red")).build());
        VIOLET_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("violet_crystal").withBlock(() -> new CrystalBlock(DyeColor.MAGENTA, "Violet")).build());
        WHITE_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("white_crystal").withBlock(() -> new CrystalBlock(DyeColor.WHITE, "White")).build());
        YELLOW_CRYSTAL = ModBlocks.registerBlock(BlockRegistryData.Builder.create("yellow_crystal").withBlock(() -> new CrystalBlock(DyeColor.YELLOW, "Yellow")).build());
        BLACK_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("black_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.BLACK, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50215_))).build());
        BLUE_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("blue_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.BLUE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50215_))).build());
        BROWN_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("brown_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.BROWN, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50212_))).build());
        CYAN_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("cyan_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.CYAN, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50209_))).build());
        GRAY_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("gray_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.GRAY, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50207_))).build());
        GREEN_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("green_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.GREEN, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50213_))).build());
        LIGHT_BLUE_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("light_blue_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.LIGHT_BLUE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50203_))).build());
        LIGHT_GRAY_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("light_gray_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.LIGHT_GRAY, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50208_))).build());
        LIME_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lime_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.LIME, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50205_))).build());
        MAGENTA_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("magenta_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.MAGENTA, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50202_))).build());
        ORANGE_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("orange_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.ORANGE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50148_))).build());
        PINK_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("pink_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.PINK, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50206_))).build());
        PURPLE_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("purple_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.PURPLE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50210_))).build());
        RED_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("red_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.RED, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50214_))).build());
        WHITE_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("white_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.WHITE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50147_))).build());
        YELLOW_FRAMELESS_GLASS = ModBlocks.registerBlock(BlockRegistryData.Builder.create("yellow_frameless_glass").withBlock(() -> new StainedGlassBlock(DyeColor.YELLOW, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50204_))).build());
        BLUE_GELATIN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("blue_gelatin").withBlock(() -> new GelatinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50719_).m_60953_(state -> 8))).build());
        CYAN_GELATIN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("cyan_gelatin").withBlock(() -> new GelatinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50719_).m_60953_(state -> 8))).build());
        LIME_GELATIN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("lime_gelatin").withBlock(() -> new GelatinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50719_).m_60953_(state -> 8))).build());
        MAGENTA_GELATIN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("magenta_gelatin").withBlock(() -> new GelatinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50719_).m_60953_(state -> 8))).build());
        ORANGE_GELATIN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("orange_gelatin").withBlock(() -> new GelatinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50719_).m_60953_(state -> 8))).build());
        PURPLE_GELATIN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("purple_gelatin").withBlock(() -> new GelatinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50719_).m_60953_(state -> 8))).build());
        RED_GELATIN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("red_gelatin").withBlock(() -> new GelatinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50719_).m_60953_(state -> 8))).build());
        YELLOW_GELATIN = ModBlocks.registerBlock(BlockRegistryData.Builder.create("yellow_gelatin").withBlock(() -> new GelatinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50719_).m_60953_(state -> 8))).build());
    }

    public static RegistrySupplier<Block> registerBlock(BlockRegistryData data) {
        ResourceLocation id = data.getId();
        Supplier<Block> block = data.getBlock();
        RegistrySupplier blockSupplier = ModRegistries.BLOCKS.register(id, block);
        BLOCKS.add((RegistrySupplier<Block>)blockSupplier);
        if (data.hasBlockItem()) {
            ModBlocks.registerBlockItem(blockSupplier);
        }
        return blockSupplier;
    }

    public static <B extends Block> void registerBlockItem(RegistrySupplier<B> blockSupplier) {
        Supplier<BlockItem> blockItemSupplier = () -> new CategorizedBlockItem((Block)blockSupplier.get());
        ModRegistries.ITEMS.register(blockSupplier.getId(), blockItemSupplier);
    }

    public static <B extends Block> RegistrySupplier<BlockItem> registerBlockItem(RegistrySupplier<B> blockSupplier, Item.Properties properties) {
        Supplier<BlockItem> blockItemSupplier = () -> new BlockItem((Block)blockSupplier.get(), properties);
        return ModRegistries.ITEMS.register(blockSupplier.getId(), blockItemSupplier);
    }

    public static void registerRenderTypes(Minecraft unused) {
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)RUSTY_TRAPDOOR.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)BLACK_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)BLUE_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)GREEN_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)INDIGO_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)ORANGE_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)RED_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)VIOLET_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)WHITE_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)YELLOW_CRYSTAL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)BLACK_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)BLUE_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)BROWN_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)CYAN_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)GRAY_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)GREEN_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)LIGHT_BLUE_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)LIGHT_GRAY_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)LIME_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)MAGENTA_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)ORANGE_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)PINK_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)PURPLE_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)RED_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)WHITE_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)YELLOW_FRAMELESS_GLASS.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)BLUE_GELATIN.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)CYAN_GELATIN.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)LIME_GELATIN.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)MAGENTA_GELATIN.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)ORANGE_GELATIN.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)PURPLE_GELATIN.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)RED_GELATIN.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)YELLOW_GELATIN.get()});
    }

    public static class Categories {
        public static AsphaltBlockCategory ASPHALT;
        public static LabBlockCategory LABORATORY;
        public static IndustrialBlockCategory INDUSTRIAL;
        public static SheetMetalBlockCategory SHEET_METAL;
        public static PastelBlockCategory PASTEL;
        public static PlasticBlockCategory PLASTIC;
        public static NaturalBlockCategory NATURAL;
        public static CrystalBlockCategory CRYSTAL;
        public static GelatinBlockCategory GELATIN;

        public static void register() {
            Log.info("Registering block categories.");
            ASPHALT = Categories.registerBlockCategory(AuxiliaryBlocks.id("asphalt"), new AsphaltBlockCategory());
            LABORATORY = Categories.registerBlockCategory(AuxiliaryBlocks.id("laboratory"), new LabBlockCategory());
            INDUSTRIAL = Categories.registerBlockCategory(AuxiliaryBlocks.id("industrial"), new IndustrialBlockCategory());
            SHEET_METAL = Categories.registerBlockCategory(AuxiliaryBlocks.id("sheet_metal"), new SheetMetalBlockCategory());
            PASTEL = Categories.registerBlockCategory(AuxiliaryBlocks.id("pastel"), new PastelBlockCategory());
            PLASTIC = Categories.registerBlockCategory(AuxiliaryBlocks.id("plastic"), new PlasticBlockCategory());
            NATURAL = Categories.registerBlockCategory(AuxiliaryBlocks.id("natural"), new NaturalBlockCategory());
            CRYSTAL = Categories.registerBlockCategory(AuxiliaryBlocks.id("crystal"), new CrystalBlockCategory());
            GELATIN = Categories.registerBlockCategory(AuxiliaryBlocks.id("gelatin"), new GelatinBlockCategory());
        }

        public static <C extends BlockCategory> C registerBlockCategory(ResourceLocation id, C category) {
            category.setId(id);
            return ModRegistries.BLOCK_CATEGORIES.register(id, category);
        }
    }

    public static class Entities {
        public static void register() {
        }
    }
}

