/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.data.provider;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.registries.RegistrySupplier;
import iskallia.auxiliaryblocks.init.ModBlocks;
import iskallia.auxiliaryblocks.init.ModRegistries;
import iskallia.auxiliaryblocks.tags.ModTags;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator dataGenerator;

    public ModRecipeProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
        this.dataGenerator = dataGenerator;
    }

    private void addRecipes(Consumer<FinishedRecipe> consumer) {
        ModRecipeProvider.registerStonecutterRecipes(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.ASPHALT.get()), (int)4).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_126209_((ItemLike)Blocks.f_50069_).m_142284_(ModRecipeProvider.getHasName(ModTags.CONCRETE_POWDER), (CriterionTriggerInstance)ModRecipeProvider.has(ModTags.CONCRETE_POWDER)).m_176500_(consumer, ModBlocks.ASPHALT.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.LAB_LIGHT_GRAY.get()), (int)4).m_126211_((ItemLike)Blocks.f_50069_, 2).m_126211_((ItemLike)Blocks.f_50470_, 2).m_142284_(ModRecipeProvider.getHasName((ItemLike)Blocks.f_50470_), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Blocks.f_50470_)).m_176500_(consumer, ModBlocks.LAB_LIGHT_GRAY.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.CONCRETE.get()), (int)4).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_206419_(ModTags.CONCRETE_POWDER).m_142284_(ModRecipeProvider.getHasName(ModTags.CONCRETE_POWDER), (CriterionTriggerInstance)ModRecipeProvider.has(ModTags.CONCRETE_POWDER)).m_176500_(consumer, ModBlocks.CONCRETE.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.SHEET_METAL.get()), (int)4).m_126209_((ItemLike)Blocks.f_50069_).m_126211_((ItemLike)Blocks.f_50183_, 3).m_142284_(ModRecipeProvider.getHasName((ItemLike)Blocks.f_50183_), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Blocks.f_50183_)).m_176500_(consumer, ModBlocks.SHEET_METAL.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.GRAY_PASTEL.get()), (int)4).m_126211_((ItemLike)Blocks.f_49992_, 3).m_126209_((ItemLike)Items.f_42490_).m_142284_(ModRecipeProvider.getHasName((ItemLike)Blocks.f_49992_), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Blocks.f_49992_)).m_176500_(consumer, ModBlocks.GRAY_PASTEL.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.PLASTIC.get()), (int)4).m_126211_((ItemLike)Blocks.f_49992_, 3).m_126209_((ItemLike)Items.f_41904_).m_142284_(ModRecipeProvider.getHasName((ItemLike)Blocks.f_49992_), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Blocks.f_49992_)).m_176500_(consumer, ModBlocks.PLASTIC.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.COBBLED_SANDSTONE.get()), (int)4).m_126211_((ItemLike)Blocks.f_49992_, 2).m_126211_((ItemLike)Blocks.f_50062_, 2).m_142284_(ModRecipeProvider.getHasName((ItemLike)Blocks.f_50062_), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Blocks.f_50062_)).m_176500_(consumer, ModBlocks.COBBLED_SANDSTONE.getId().m_135815_());
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.WHITE_CRYSTAL.get()), (int)4).m_126211_((ItemLike)Items.f_151049_, 3).m_126209_((ItemLike)Items.f_41904_).m_142284_(ModRecipeProvider.getHasName((ItemLike)Items.f_151049_), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Items.f_151049_)).m_176500_(consumer, ModBlocks.WHITE_CRYSTAL.getId().m_135815_());
        this.buildGlassRecipe(consumer, ModBlocks.BLACK_FRAMELESS_GLASS, (ItemLike)Blocks.f_50215_);
        this.buildGlassRecipe(consumer, ModBlocks.BLUE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50211_);
        this.buildGlassRecipe(consumer, ModBlocks.BROWN_FRAMELESS_GLASS, (ItemLike)Blocks.f_50212_);
        this.buildGlassRecipe(consumer, ModBlocks.CYAN_FRAMELESS_GLASS, (ItemLike)Blocks.f_50209_);
        this.buildGlassRecipe(consumer, ModBlocks.GRAY_FRAMELESS_GLASS, (ItemLike)Blocks.f_50207_);
        this.buildGlassRecipe(consumer, ModBlocks.GREEN_FRAMELESS_GLASS, (ItemLike)Blocks.f_50213_);
        this.buildGlassRecipe(consumer, ModBlocks.LIGHT_BLUE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50203_);
        this.buildGlassRecipe(consumer, ModBlocks.LIGHT_GRAY_FRAMELESS_GLASS, (ItemLike)Blocks.f_50208_);
        this.buildGlassRecipe(consumer, ModBlocks.LIME_FRAMELESS_GLASS, (ItemLike)Blocks.f_50205_);
        this.buildGlassRecipe(consumer, ModBlocks.MAGENTA_FRAMELESS_GLASS, (ItemLike)Blocks.f_50202_);
        this.buildGlassRecipe(consumer, ModBlocks.ORANGE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50148_);
        this.buildGlassRecipe(consumer, ModBlocks.PINK_FRAMELESS_GLASS, (ItemLike)Blocks.f_50206_);
        this.buildGlassRecipe(consumer, ModBlocks.PURPLE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50210_);
        this.buildGlassRecipe(consumer, ModBlocks.RED_FRAMELESS_GLASS, (ItemLike)Blocks.f_50214_);
        this.buildGlassRecipe(consumer, ModBlocks.WHITE_FRAMELESS_GLASS, (ItemLike)Blocks.f_50147_);
        this.buildGlassRecipe(consumer, ModBlocks.YELLOW_FRAMELESS_GLASS, (ItemLike)Blocks.f_50204_);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModBlocks.RED_GELATIN.get()), (int)4).m_126211_((ItemLike)Items.f_42204_, 2).m_126209_((ItemLike)Items.f_42023_).m_126209_((ItemLike)Items.f_42054_).m_142284_(ModRecipeProvider.getHasName((ItemLike)Items.f_42204_), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Items.f_42204_)).m_176500_(consumer, ModBlocks.RED_GELATIN.getId().m_135815_());
    }

    private void buildGlassRecipe(Consumer<FinishedRecipe> consumer, RegistrySupplier<Block> result, ItemLike ingredient) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)8).m_126127_(Character.valueOf('g'), ingredient).m_126130_("ggg").m_126130_("g g").m_126130_("ggg").m_142284_(ModRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)ModRecipeProvider.has(ingredient)).m_176500_(consumer, result.getId().m_135815_());
    }

    public static void registerStonecutterRecipes(Consumer<FinishedRecipe> consumer) {
        ModRegistries.BLOCK_CATEGORIES.forEach((resourceLocation, category) -> category.getVariations().forEach(variation -> ModRecipeProvider.getStonecutterRecipe(consumer, (ItemLike)variation.get(), (ItemLike)((RegistrySupplier)category.getBase()).get())));
    }

    private static void getStonecutterRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike ingredient) {
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (ItemLike)result).m_142284_(ModRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)ModRecipeProvider.has(ingredient)).m_176500_(consumer, ModRecipeProvider.getConversionRecipeName(result, ingredient));
    }

    public void m_6865_(@NotNull HashCache hashCache) {
        Path path = this.dataGenerator.m_123916_();
        HashSet set = Sets.newHashSet();
        this.addRecipes(finishedRecipe -> {
            if (!set.add(finishedRecipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + finishedRecipe.m_6445_());
            }
            JsonObject recipe = finishedRecipe.m_125966_();
            ModRecipeProvider.saveRecipe(hashCache, recipe, path.resolve("data/auxiliaryblocks/recipes/" + finishedRecipe.m_6445_().m_135815_() + ".json"));
            JsonObject jsonObject = finishedRecipe.m_5860_();
            if (jsonObject != null) {
                ModRecipeProvider.saveAdvancement(hashCache, jsonObject, path.resolve("data/auxiliaryblocks/advancements/" + Objects.requireNonNull(finishedRecipe.m_6448_()).m_135815_() + ".json"));
            }
        });
    }

    private static void saveRecipe(HashCache hashCache, JsonObject jsonObject, Path path) {
        ModRecipeProvider.save(hashCache, jsonObject, path);
    }

    private static void saveAdvancement(HashCache hashCache, JsonObject jsonObject, Path path) {
        ModRecipeProvider.save(hashCache, jsonObject, path);
    }

    private static void save(HashCache hashCache, JsonObject jsonObject, Path path) {
        try {
            String jsonString = GSON.toJson((JsonElement)jsonObject);
            String hashed = f_123918_.hashUnencodedChars((CharSequence)jsonString).toString();
            if (!Objects.equals(hashCache.m_123938_(path), hashed) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);
                try {
                    bufferedWriter.write(jsonString);
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            hashCache.m_123940_(path, hashed);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        String resultName = ModRecipeProvider.getItemName(result);
        return resultName + "_from_" + ModRecipeProvider.getItemName(ingredient);
    }

    private static String getHasName(ItemLike item) {
        return "has_" + ModRecipeProvider.getItemName(item);
    }

    private static String getHasName(TagKey<Item> tag) {
        return "has_" + tag.f_203868_().m_135815_();
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> arg) {
        return ModRecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(arg).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance has(ItemLike itemLike) {
        return ModRecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemLike}).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... itemPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, itemPredicates);
    }

    private static String getItemName(ItemLike itemLike) {
        return Registry.f_122827_.m_7981_((Object)itemLike.m_5456_()).m_135815_();
    }
}

