/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.data;

import com.google.common.collect.Maps;
import dev.architectury.registry.registries.RegistrySupplier;
import iskallia.auxiliaryblocks.init.ModBlocks;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class ModBlockLoot
implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
    private final Map<ResourceLocation, LootTable.Builder> map = Maps.newHashMap();

    @Override
    public void accept(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
        ModBlocks.BLOCKS.forEach(this::add);
        this.apply(biConsumer);
    }

    private void apply(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
        this.map.forEach((id, builder) -> {
            if (builder != null) {
                biConsumer.accept((ResourceLocation)id, (LootTable.Builder)builder);
            }
        });
    }

    private void add(RegistrySupplier<Block> block) {
        this.map.put(new ResourceLocation(block.getId().m_135827_(), "blocks/" + block.getId().m_135815_()), ModBlockLoot.createSingleItemTable((ItemLike)block.get()));
    }

    private static LootTable.Builder createSingleItemTable(ItemLike itemLike) {
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemLike)));
    }
}

