/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class GelatinBlock
extends HalfTransparentBlock {
    private static final double SLIDE_STARTS_WHEN_VERTICAL_SPEED_IS_AT_LEAST = 0.13;
    private static final double MIN_FALL_SPEED_TO_BE_CONSIDERED_SLIDING = 0.08;
    private static final double THROTTLE_SLIDE_SPEED_TO = 0.05;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public GelatinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5939_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    public void m_142072_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockPos blockPos, Entity entity, float f) {
        entity.m_5496_(SoundEvents.f_11968_, 1.0f, 1.0f);
        if (entity.m_142535_(f, 0.2f, DamageSource.f_19315_)) {
            entity.m_5496_(this.f_60446_.m_56779_(), this.f_60446_.m_56773_() * 0.5f, this.f_60446_.m_56774_() * 0.75f);
        }
    }

    public void m_7892_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Entity entity) {
        if (this.isSlidingDown(blockPos, entity)) {
            this.doSlideMovement(entity);
            this.maybeDoSlideEffects(level, entity);
        }
        super.m_7892_(blockState, level, blockPos, entity);
    }

    private boolean isSlidingDown(BlockPos pos, Entity entity) {
        if (entity.m_20096_()) {
            return false;
        }
        if (entity.m_20186_() > (double)pos.m_123342_() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.m_20184_().f_82480_ >= -0.08) {
            return false;
        }
        double d = Math.abs((double)pos.m_123341_() + 0.5 - entity.m_20185_());
        double e = Math.abs((double)pos.m_123343_() + 0.5 - entity.m_20189_());
        double f = 0.4375 + (double)(entity.m_20205_() / 2.0f);
        return d + 1.0E-7 > f || e + 1.0E-7 > f;
    }

    private void doSlideMovement(Entity entity) {
        Vec3 deltaMovement = entity.m_20184_();
        if (deltaMovement.f_82480_ < -0.13) {
            double d = -0.05 / deltaMovement.f_82480_;
            entity.m_20256_(new Vec3(deltaMovement.f_82479_ * d, -0.05, deltaMovement.f_82481_ * d));
        } else {
            entity.m_20256_(new Vec3(deltaMovement.f_82479_, -0.05, deltaMovement.f_82481_));
        }
        entity.m_183634_();
    }

    private void maybeDoSlideEffects(Level level, Entity entity) {
        if (!GelatinBlock.doesEntityDoSlideEffects(entity)) {
            return;
        }
        if (level.f_46441_.nextInt(5) == 0) {
            entity.m_5496_(SoundEvents.f_11968_, 1.0f, 1.0f);
        }
    }

    private static boolean doesEntityDoSlideEffects(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof AbstractMinecart || entity instanceof PrimedTnt || entity instanceof Boat;
    }
}

