/*
 * Decompiled with CFR 0.152.
 */
package iskallia.auxiliaryblocks.block;

import iskallia.auxiliaryblocks.AuxiliaryBlocks;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockRegistryData {
    private Supplier<Block> block;
    private final ResourceLocation id;
    private boolean hasBlockItem;

    private BlockRegistryData(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean hasBlockItem() {
        return this.hasBlockItem;
    }

    public Supplier<Block> getBlock() {
        return this.block;
    }

    public static class Builder {
        private final ResourceLocation id;
        private Supplier<Block> block = () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_));
        private boolean hasBlockItem = true;

        public Builder(ResourceLocation id) {
            this.id = id;
        }

        public static Builder create(String id) {
            return new Builder(AuxiliaryBlocks.id(id));
        }

        public Builder withBlock(Supplier<Block> block) {
            this.block = block;
            return this;
        }

        public Builder noBlockItem() {
            this.hasBlockItem = false;
            return this;
        }

        public BlockRegistryData build() {
            BlockRegistryData data = new BlockRegistryData(this.id);
            data.block = this.block;
            data.hasBlockItem = this.hasBlockItem;
            return data;
        }
    }
}

