/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.factory.ItemStorageDiskFactory;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStorageDisk
implements IStorageDisk<ItemStack> {
    public static final String NBT_VERSION = "Version";
    public static final String NBT_CAPACITY = "Capacity";
    public static final String NBT_ITEMS = "Items";
    public static final String NBT_OWNER = "Owner";
    public static final int VERSION = 1;
    @Nullable
    private final ServerLevel level;
    private final int capacity;
    private final Multimap<Item, ItemStack> stacks = ArrayListMultimap.create();
    private final UUID owner;
    private int itemCount;
    @Nullable
    private IStorageDiskListener listener;
    private IStorageDiskContainerContext context;

    public ItemStorageDisk(@Nullable ServerLevel level, int capacity, @Nullable UUID owner) {
        this.level = level;
        this.capacity = capacity;
        this.owner = owner;
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (ItemStack stack : this.stacks.values()) {
            list.add((Object)StackUtils.serializeStackToNbt(stack));
        }
        tag.m_128405_(NBT_VERSION, 1);
        tag.m_128365_(NBT_ITEMS, (Tag)list);
        tag.m_128405_(NBT_CAPACITY, this.capacity);
        if (this.owner != null) {
            tag.m_128362_(NBT_OWNER, this.owner);
        }
        return tag;
    }

    @Override
    public ResourceLocation getFactoryId() {
        return ItemStorageDiskFactory.ID;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
        if (stack.m_41619_() || this.itemCount == this.capacity) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        }
        for (ItemStack otherStack : this.stacks.get((Object)stack.m_41720_())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                }
                if (action == Action.PERFORM) {
                    otherStack.m_41769_(remainingSpace);
                    this.itemCount += remainingSpace;
                    this.onChanged();
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)(size - remainingSpace));
            }
            if (action == Action.PERFORM) {
                otherStack.m_41769_(size);
                this.itemCount += size;
                this.onChanged();
            }
            return ItemStack.f_41583_;
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            if (action == Action.PERFORM) {
                this.stacks.put((Object)stack.m_41720_(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remainingSpace));
                this.itemCount += remainingSpace;
                this.onChanged();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
        }
        if (action == Action.PERFORM) {
            this.stacks.put((Object)stack.m_41720_(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
            this.itemCount += size;
            this.onChanged();
        }
        return ItemStack.f_41583_;
    }

    @Override
    @Nonnull
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
        if (stack.m_41619_()) {
            return stack;
        }
        for (ItemStack otherStack : this.stacks.get((Object)stack.m_41720_())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            if (size > otherStack.m_41613_()) {
                size = otherStack.m_41613_();
            }
            if (action == Action.PERFORM) {
                if (otherStack.m_41613_() - size == 0) {
                    this.stacks.remove((Object)otherStack.m_41720_(), (Object)otherStack);
                } else {
                    otherStack.m_41774_(size);
                }
                this.itemCount -= size;
                this.onChanged();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)size);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public int getStored() {
        return this.itemCount;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.listener = listener;
        this.context = context;
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.m_41613_();
    }

    public Multimap<Item, ItemStack> getRawStacks() {
        return this.stacks;
    }

    private void onChanged() {
        if (this.listener != null) {
            this.listener.onChanged();
        }
        if (this.level != null) {
            API.instance().getStorageDiskManager(this.level).markForSaving();
        }
    }

    public void updateItemCount() {
        this.itemCount = this.stacks.values().stream().mapToInt(ItemStack::m_41613_).sum();
    }
}

