/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.quark;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.modules.quark.CompatChestBlock;
import net.mehvahdjukaar.every_compat.modules.quark.CompatChestBlockTile;
import net.mehvahdjukaar.every_compat.modules.quark.CompatChestItem;
import net.mehvahdjukaar.every_compat.modules.quark.CompatTrappedChestBlock;
import net.mehvahdjukaar.every_compat.modules.quark.CompatTrappedChestBlockTile;
import net.mehvahdjukaar.every_compat.modules.quark.QuarkSimpleEntrySet;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Palette;
import net.mehvahdjukaar.selene.client.asset_generators.textures.PaletteColor;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Respriter;
import net.mehvahdjukaar.selene.client.asset_generators.textures.TextureImage;
import net.mehvahdjukaar.selene.math.colors.HCLColor;
import net.mehvahdjukaar.selene.resourcepack.DynamicTexturePack;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.ToolInteractionHandler;
import vazkii.quark.content.building.block.HedgeBlock;
import vazkii.quark.content.building.block.VariantBookshelfBlock;
import vazkii.quark.content.building.block.VariantLadderBlock;
import vazkii.quark.content.building.block.WoodPostBlock;
import vazkii.quark.content.building.client.render.be.VariantChestRenderer;
import vazkii.quark.content.building.module.HedgesModule;
import vazkii.quark.content.building.module.VariantBookshelvesModule;
import vazkii.quark.content.building.module.VariantChestsModule;
import vazkii.quark.content.building.module.VariantLaddersModule;
import vazkii.quark.content.building.module.VerticalPlanksModule;

public class QuarkModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> BOOKSHELVES;
    public final SimpleEntrySet<WoodType, Block> POSTS;
    public final SimpleEntrySet<WoodType, Block> STRIPPED_POSTS;
    public final SimpleEntrySet<WoodType, Block> VERTICAL_PLANKS;
    public final SimpleEntrySet<WoodType, Block> LADDERS;
    public final SimpleEntrySet<WoodType, Block> CHESTS;
    public final SimpleEntrySet<WoodType, Block> TRAPPED_CHESTS;
    public final SimpleEntrySet<LeavesType, Block> HEDGES;
    public static BlockEntityType<? extends ChestBlockEntity> CHEST_TILE;
    public static BlockEntityType<? extends ChestBlockEntity> TRAPPED_CHEST_TILE;
    public final Field regNameHax;
    public final Field ARLModData;

    public QuarkModule(String modId) {
        super(modId, "q");
        Field f = null;
        Field f2 = null;
        try {
            f = ObfuscationReflectionHelper.findField(ForgeRegistryEntry.class, (String)"registryName");
            f.setAccessible(true);
            f2 = ObfuscationReflectionHelper.findField(RegistryHelper.class, (String)"modData");
            f2.setAccessible(true);
        }
        catch (Exception e) {
            WoodGood.LOGGER.error("Failed to initialize {}: {}", (Object)this, (Object)e);
        }
        this.ARLModData = f2;
        this.regNameHax = f;
        this.BOOKSHELVES = QuarkSimpleEntrySet.builder(WoodType.class, "bookshelf", VariantBookshelvesModule.class, () -> this.getModBlock("acacia_bookshelf"), () -> (WoodType)WoodTypeRegistry.WOOD_TYPES.get(new ResourceLocation("acacia")), (w, m) -> new VariantBookshelfBlock(this.shortenedId() + "/" + w.getAppendableId(), m, w.canBurn())).setTab(() -> CreativeModeTab.f_40750_).useLootFromBase().addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(Tags.Items.BOOKSHELVES, Registry.f_122901_).addTag(Tags.Items.BOOKSHELVES, Registry.f_122904_).addRecipe(this.modRes("building/crafting/acacia_bookshelf")).addTextureM(WoodGood.res("block/acacia_bookshelf"), WoodGood.res("block/acacia_bookshelf_m")).setPalette(this::bookshelfPalette).build();
        this.addEntry(this.BOOKSHELVES);
        this.POSTS = QuarkSimpleEntrySet.builder(WoodType.class, "post", VariantBookshelvesModule.class, () -> this.getModBlock("oak_post"), () -> WoodType.OAK_WOOD_TYPE, (w, m) -> {
            if (w.getNamespace().equals("malum")) {
                return null;
            }
            Block fence = w.getBlockOfThis("fence");
            return fence == null ? null : new WoodPostBlock(m, fence, this.shortenedId() + "/" + w.getNamespace() + "/", w.canBurn());
        }).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(this.modRes("posts"), Registry.f_122901_).setTab(() -> CreativeModeTab.f_40750_).addRecipe(this.modRes("building/crafting/oak_post")).setRenderType(() -> RenderType::m_110463_).build();
        this.addEntry(this.POSTS);
        this.STRIPPED_POSTS = QuarkSimpleEntrySet.builder(WoodType.class, "post", "stripped", VariantBookshelvesModule.class, () -> this.getModBlock("stripped_oak_post"), () -> WoodType.OAK_WOOD_TYPE, (w, m) -> {
            if (w.getNamespace().equals("malum") || w.getNamespace().equals("twigs")) {
                return null;
            }
            Block fence = w.getBlockOfThis("fence");
            Block stripped = w.getBlockOfThis("stripped_log");
            return fence == null || stripped == null ? null : new WoodPostBlock(m, fence, this.shortenedId() + "/" + w.getNamespace() + "/stripped_", w.canBurn());
        }).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(this.modRes("posts"), Registry.f_122901_).setTab(() -> CreativeModeTab.f_40750_).addRecipe(this.modRes("building/crafting/stripped_oak_post")).setRenderType(() -> RenderType::m_110463_).build();
        this.addEntry(this.STRIPPED_POSTS);
        this.VERTICAL_PLANKS = QuarkSimpleEntrySet.builder(WoodType.class, "planks", "vertical", VerticalPlanksModule.class, () -> this.getModBlock("vertical_oak_planks"), () -> WoodType.OAK_WOOD_TYPE, (w, m) -> {
            String name = this.shortenedId() + "/" + w.getVariantId("planks", "vertical");
            return new QuarkBlock(name, m, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)w.planks));
        }).setTab(() -> CreativeModeTab.f_40749_).addRecipe(this.modRes("building/crafting/vertplanks/vertical_oak_planks")).build();
        this.addEntry(this.VERTICAL_PLANKS);
        this.LADDERS = QuarkSimpleEntrySet.builder(WoodType.class, "ladder", VariantLaddersModule.class, () -> this.getModBlock("spruce_ladder"), () -> (WoodType)WoodTypeRegistry.WOOD_TYPES.get(new ResourceLocation("spruce")), (w, m) -> {
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new VariantLadderBlock(name, m, w.canBurn());
        }).setTab(() -> CreativeModeTab.f_40749_).addTag(BlockTags.f_13082_, Registry.f_122901_).addTag(this.modRes("ladders"), Registry.f_122901_).addTag(this.modRes("ladders"), Registry.f_122904_).addRecipe(this.modRes("building/crafting/spruce_ladder")).addTexture(WoodGood.res("block/spruce_ladder")).build();
        this.addEntry(this.LADDERS);
        this.CHESTS = QuarkSimpleEntrySet.builder(WoodType.class, "chest", VariantChestsModule.class, () -> this.getModBlock("oak_chest"), () -> WoodType.OAK_WOOD_TYPE, (w, m) -> {
            if (w.getId().toString().equals("twilightforest:dark")) {
                return null;
            }
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new CompatChestBlock((WoodType)w, name, (vazkii.quark.base.module.QuarkModule)m, BlockBehaviour.Properties.m_60926_((BlockBehaviour)w.planks));
        }).setTab(() -> CreativeModeTab.f_40749_).addTag(Tags.Blocks.CHESTS_WOODEN, Registry.f_122901_).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(Tags.Blocks.CHESTS_WOODEN, Registry.f_122904_).addTile(CompatChestBlockTile::new).addCustomItem((w, b, p) -> new CompatChestItem((Block)b, (Item.Properties)p, false)).addRecipe(this.modRes("building/crafting/chests/oak_chest")).build();
        this.addEntry(this.CHESTS);
        this.TRAPPED_CHESTS = QuarkSimpleEntrySet.builder(WoodType.class, "chest", "trapped", VariantChestsModule.class, () -> this.getModBlock("oak_trapped_chest"), () -> WoodType.OAK_WOOD_TYPE, (w, m) -> {
            if (w.getId().toString().equals("twilightforest:dark")) {
                return null;
            }
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new CompatTrappedChestBlock((WoodType)w, name, (vazkii.quark.base.module.QuarkModule)m, BlockBehaviour.Properties.m_60926_((BlockBehaviour)w.planks));
        }).setTab(() -> CreativeModeTab.f_40749_).addTag(Tags.Blocks.CHESTS_TRAPPED, Registry.f_122901_).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(Tags.Blocks.CHESTS_TRAPPED, Registry.f_122904_).addTile(CompatTrappedChestBlockTile::new).addCustomItem((w, b, p) -> new CompatChestItem((Block)b, (Item.Properties)p, true)).addRecipe(this.modRes("building/crafting/chests/oak_trapped_chest")).build();
        this.addEntry(this.TRAPPED_CHESTS);
        this.HEDGES = QuarkSimpleEntrySet.builder(LeavesType.class, "hedge", HedgesModule.class, () -> this.getModBlock("oak_hedge"), () -> LeavesType.OAK_LEAVES_TYPE, (w, m) -> {
            HedgeBlock h = new HedgeBlock(m, Blocks.f_50132_, w.leaves);
            try {
                this.regNameHax.set(h, WoodGood.res(this.makeBlockId((BlockType)w, "hedge")));
            }
            catch (Exception e) {
                WoodGood.LOGGER.error("Failed to set registry name for hedge of type {}", w);
                return null;
            }
            return h;
        }).addTag(BlockTags.f_144280_, Registry.f_122901_).addTag(this.modRes("hedges"), Registry.f_122901_).addTag(this.modRes("hedges"), Registry.f_122904_).setTab(() -> CreativeModeTab.f_40749_).addRecipe(this.modRes("building/crafting/oak_hedge")).setRenderType(() -> RenderType::m_110463_).build();
        this.addEntry(this.HEDGES);
    }

    @Override
    public void onModSetup() {
        this.POSTS.blocks.forEach((w, post) -> {
            Block stripped = (Block)this.STRIPPED_POSTS.blocks.get(w);
            if (stripped != null) {
                ToolInteractionHandler.registerInteraction((ToolAction)ToolActions.AXE_STRIP, (Block)post, (Block)stripped);
            }
        });
    }

    @Override
    public void registerWoodBlocks(IForgeRegistry<Block> registry, Collection<WoodType> woodTypes) {
        try {
            Map data = (Map)this.ARLModData.get(null);
            super.registerWoodBlocks(registry, woodTypes);
            data.remove("everycomp");
        }
        catch (IllegalAccessException e) {
            WoodGood.LOGGER.error("Failed to setup Wood Good Quark Module");
        }
    }

    @Override
    public void registerLeavesBlocks(IForgeRegistry<Block> registry, Collection<LeavesType> woodTypes) {
        try {
            Map data = (Map)this.ARLModData.get(null);
            super.registerLeavesBlocks(registry, woodTypes);
            data.remove("everycomp");
        }
        catch (IllegalAccessException e) {
            WoodGood.LOGGER.error("Failed to setup Wood Good Quark Module");
        }
    }

    @Override
    public void registerTiles(IForgeRegistry<BlockEntityType<?>> registry) {
        super.registerTiles(registry);
        CHEST_TILE = this.CHESTS.getTileHolder().tile;
        TRAPPED_CHEST_TILE = this.TRAPPED_CHESTS.getTileHolder().tile;
    }

    public void onFirstClientTick1() {
        ItemColors ic = Minecraft.m_91087_().getItemColors();
        BlockColors bc = Minecraft.m_91087_().m_91298_();
        this.HEDGES.blocks.forEach((t, b) -> {
            ItemLike leaf = t.getChild("leaves");
            if (leaf instanceof Block) {
                Block block = (Block)leaf;
                bc.m_92589_((s, l, p, i) -> bc.m_92577_(block.m_49966_(), l, p, i), new Block[]{b});
                ic.m_92689_((stack, tintIndex) -> ic.m_92676_(new ItemStack((ItemLike)leaf.m_5456_()), tintIndex), new ItemLike[]{b.m_5456_()});
            }
        });
    }

    @Override
    public void registerColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        this.HEDGES.blocks.forEach((t, b) -> colors.m_92689_((stack, tintIndex) -> colors.m_92676_(new ItemStack((ItemLike)t.leaves), tintIndex), new ItemLike[]{b.m_5456_()}));
    }

    @Override
    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        super.registerEntityRenderers(event);
        event.registerBlockEntityRenderer(CHEST_TILE, VariantChestRenderer::new);
        event.registerBlockEntityRenderer(TRAPPED_CHEST_TILE, VariantChestRenderer::new);
    }

    @Override
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        ResourceLocation loc = event.getAtlas().m_118330_();
        if (loc.equals((Object)Sheets.f_110740_)) {
            this.CHESTS.blocks.values().forEach(c -> VariantChestRenderer.accept((TextureStitchEvent.Pre)event, (Block)c));
            this.TRAPPED_CHESTS.blocks.values().forEach(c -> VariantChestRenderer.accept((TextureStitchEvent.Pre)event, (Block)c));
        }
    }

    private Pair<List<Palette>, AnimationMetadataSection> bookshelfPalette(BlockType w, ResourceManager m) {
        Pair pair;
        block8: {
            TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)((WoodType)w).planks));
            try {
                List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                targetPalette.forEach(p -> {
                    PaletteColor l0 = p.getDarkest();
                    p.increaseDown();
                    p.increaseDown();
                    p.increaseDown();
                    p.increaseDown();
                    p.remove(l0);
                });
                pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                if (plankTexture == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (plankTexture != null) {
                        try {
                            plankTexture.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                }
            }
            plankTexture.close();
        }
        return pair;
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        try (TextureImage normal = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("model/chest/oak/normal"));
             TextureImage normal_m = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/oak_chest_normal_m"));
             TextureImage normal_o = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/oak_chest_normal_o"));
             TextureImage left = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("model/chest/oak/left"));
             TextureImage left_m = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/oak_chest_left_m"));
             TextureImage left_o = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/oak_chest_left_o"));
             TextureImage right = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("model/chest/oak/right"));
             TextureImage right_m = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/oak_chest_right_m"));
             TextureImage right_o = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/oak_chest_right_o"));
             TextureImage left_t = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/trapped_chest_left"));
             TextureImage right_t = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/trapped_chest_right"));
             TextureImage normal_t = TextureImage.open((ResourceManager)manager, (ResourceLocation)WoodGood.res("model/trapped_chest_normal"));){
            Respriter respriterNormal = Respriter.masked((TextureImage)normal, (TextureImage)normal_m);
            Respriter respriterLeft = Respriter.masked((TextureImage)left, (TextureImage)left_m);
            Respriter respriterRight = Respriter.masked((TextureImage)right, (TextureImage)right_m);
            Respriter respriterNormalO = Respriter.of((TextureImage)normal_o);
            Respriter respriterLeftO = Respriter.of((TextureImage)left_o);
            Respriter respriterRightO = Respriter.of((TextureImage)right_o);
            this.CHESTS.blocks.forEach((wood, block) -> {
                CompatChestBlock b = (CompatChestBlock)((Object)block);
                try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                    TextureImage trapped;
                    TextureImage img;
                    ResourceLocation trappedRes;
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    ArrayList<Palette> overlayPalette = new ArrayList<Palette>();
                    for (Palette p : targetPalette) {
                        PaletteColor d1 = p.getDarkest();
                        p.remove(d1);
                        PaletteColor d2 = p.getDarkest();
                        p.remove(d2);
                        HCLColor n1 = new HCLColor(d1.hcl().hue(), d1.hcl().chroma() * 0.75f, d1.hcl().luminance() * 0.4f, d1.hcl().alpha());
                        HCLColor n2 = new HCLColor(d2.hcl().hue(), d2.hcl().chroma() * 0.75f, d2.hcl().luminance() * 0.6f, d2.hcl().alpha());
                        Palette pal = Palette.ofColors(List.of(n1, n2));
                        overlayPalette.add(pal);
                    }
                    ResourceLocation res = this.modRes(b.getChestTexturePath() + "normal");
                    if (!handler.alreadyHasTextureAtLocation(manager, res)) {
                        trappedRes = this.modRes(b.getChestTexturePath() + "trap");
                        img = respriterNormal.recolorWithAnimation(targetPalette, plankTexture.getMetadata());
                        img.applyOverlayOnExisting(new TextureImage[]{respriterNormalO.recolorWithAnimation(overlayPalette, plankTexture.getMetadata())});
                        trapped = img.makeCopy();
                        trapped.applyOverlayOnExisting(new TextureImage[]{normal_t.makeCopy()});
                        ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(res, img);
                        ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(trappedRes, trapped);
                    }
                    if (!handler.alreadyHasTextureAtLocation(manager, res = this.modRes(b.getChestTexturePath() + "left"))) {
                        trappedRes = this.modRes(b.getChestTexturePath() + "trap_left");
                        img = respriterLeft.recolorWithAnimation(targetPalette, plankTexture.getMetadata());
                        img.applyOverlayOnExisting(new TextureImage[]{respriterLeftO.recolorWithAnimation(overlayPalette, plankTexture.getMetadata())});
                        trapped = img.makeCopy();
                        trapped.applyOverlayOnExisting(new TextureImage[]{left_t.makeCopy()});
                        ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(res, img);
                        ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(trappedRes, trapped);
                    }
                    if (!handler.alreadyHasTextureAtLocation(manager, res = this.modRes(b.getChestTexturePath() + "right"))) {
                        trappedRes = this.modRes(b.getChestTexturePath() + "trap_right");
                        img = respriterRight.recolorWithAnimation(targetPalette, plankTexture.getMetadata());
                        img.applyOverlayOnExisting(new TextureImage[]{respriterRightO.recolorWithAnimation(overlayPalette, plankTexture.getMetadata())});
                        trapped = img.makeCopy();
                        trapped.applyOverlayOnExisting(new TextureImage[]{right_t.makeCopy()});
                        ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(res, img);
                        ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(trappedRes, trapped);
                    }
                }
                catch (Exception ex) {
                    handler.getLogger().error("Failed to generate Chest block texture for for {} : {}", (Object)b, (Object)ex);
                }
            });
        }
        catch (Exception ex) {
            handler.getLogger().error("Could not generate any Chest block texture : ", (Throwable)ex);
        }
    }
}

