/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.configs.BlockTypeEnabledCondition;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.resourcepack.BlockTypeResTransformer;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.DynamicResourcePack;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.mehvahdjukaar.selene.resourcepack.StaticResource;
import net.mehvahdjukaar.selene.resourcepack.recipe.IRecipeTemplate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final JsonObject DUMMY_BLOCKSTATE = new JsonObject();

    public static <B extends Block, T extends BlockType> void addStandardResources(String modId, ResourceManager manager, DynamicResourcePack pack, Map<T, B> blocks, T baseType) {
        Utils.addStandardResources(modId, manager, pack, blocks, baseType, null);
    }

    public static <B extends Block, T extends BlockType> void addStandardResources(String modId, ResourceManager manager, DynamicResourcePack pack, Map<T, B> blocks, T baseType, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        Block bl;
        if (blocks.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)blocks.entrySet().stream().findFirst().get();
        ItemLike oi = BlockType.changeItemBlockType((ItemLike)((ItemLike)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        String baseBlockName = baseType.getTypeName();
        if (!(oi instanceof Block)) {
            WoodGood.LOGGER.error("Failed to generate some assets");
            return;
        }
        Block oakBlock = bl = (Block)oi;
        ResourceLocation oakId = oakBlock.getRegistryName();
        BlockTypeResTransformer modifier = BlockTypeResTransformer.create((String)modId, (ResourceManager)manager);
        modifier.IDReplaceType(baseBlockName).replaceBlockType(baseBlockName);
        BlockTypeResTransformer modelModifier = Utils.standardModelTransformer(modId, manager, baseType, baseBlockName, extraTransform);
        HashSet modelsLoc = new HashSet();
        Item oakItem = oakBlock.m_5456_();
        if (oakItem != Items.f_41852_) {
            try {
                String parent;
                BlockTypeResTransformer itemModifier = Utils.standardModelTransformer(modId, manager, baseType, baseBlockName, extraTransform);
                StaticResource oakItemModel = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(oakItem.getRegistryName()));
                JsonObject json = RPUtils.deserializeJson((InputStream)oakItemModel.getInputStream());
                modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model") || s.equals("parent")));
                if (json.has("parent") && (parent = json.get("parent").getAsString()).contains("item/generated")) {
                    itemModifier.replaceItemType(baseBlockName);
                }
                blocks.forEach((w, b) -> {
                    ResourceLocation id = b.getRegistryName();
                    try {
                        StaticResource newRes = itemModifier.transform(oakItemModel, id, w);
                        assert (newRes.location != oakItemModel.location) : "ids cant be the same";
                        pack.addResource(newRes);
                    }
                    catch (Exception e) {
                        WoodGood.LOGGER.error("Failed to add {} item model json file:", b, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                WoodGood.LOGGER.error("Could not find item model for {}", (Object)oakBlock);
            }
        } else {
            WoodGood.LOGGER.warn("Found block with no item {}, this could be a bug", (Object)oakBlock);
        }
        try {
            StaticResource oakBlockstate = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(oakId));
            JsonObject json = RPUtils.deserializeJson((InputStream)oakBlockstate.getInputStream());
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model")));
            ArrayList<StaticResource> oakModels = new ArrayList<StaticResource>();
            for (String m : modelsLoc) {
                StaticResource model;
                ResourceLocation modelRes = new ResourceLocation(m);
                if (modelRes.m_135827_().equals("minecraft") || (model = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.MODELS.getPath(m))) == null) continue;
                oakModels.add(model);
            }
            blocks.forEach((w, b) -> {
                ResourceLocation id = b.getRegistryName();
                try {
                    if (EarlyConfigs.isTypeEnabled(w)) {
                        StaticResource newBlockState = modifier.transform(oakBlockstate, id, w);
                        assert (newBlockState.location != oakBlockstate.location) : "ids cant be the same";
                        pack.addResource(newBlockState);
                        for (StaticResource model : oakModels) {
                            try {
                                StaticResource newModel = modelModifier.transform(model, id, w);
                                assert (newModel.location != model.location) : "ids cant be the same";
                                pack.addResource(newModel);
                            }
                            catch (Exception exception) {
                                WoodGood.LOGGER.error("Failed to add {} model json file:", b, (Object)exception);
                            }
                        }
                    } else {
                        pack.addJson(b.getRegistryName(), (JsonElement)DUMMY_BLOCKSTATE, ResType.BLOCKSTATES);
                    }
                }
                catch (Exception e) {
                    WoodGood.LOGGER.error("Failed to add {} blockstate json file:", b, (Object)e);
                }
            });
        }
        catch (Exception e) {
            WoodGood.LOGGER.error("Could not find blockstate definition for {}", (Object)oakBlock);
        }
    }

    @NotNull
    private static <T extends BlockType> BlockTypeResTransformer<T> standardModelTransformer(String modId, ResourceManager manager, T baseType, String oldTypeName, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        BlockTypeResTransformer modelModifier = BlockTypeResTransformer.create((String)modId, (ResourceManager)manager);
        if (extraTransform != null) {
            extraTransform.accept(modelModifier);
        }
        modelModifier.IDReplaceType(oldTypeName);
        if (baseType instanceof LeavesType) {
            LeavesType leavesType = (LeavesType)baseType;
            modelModifier.replaceLeavesTextures(leavesType);
            WoodType woodT = leavesType.woodType;
            if (woodT != null) {
                modelModifier.replaceWoodTextures(woodT);
            }
        } else if (baseType instanceof WoodType) {
            WoodType woodType = (WoodType)baseType;
            modelModifier.replaceWoodTextures(woodType);
        }
        modelModifier.replaceGenericType(oldTypeName, "block");
        return modelModifier;
    }

    public static <B extends Block, T extends BlockType> void addBlockResources(String modId, ResourceManager manager, DynamicResourcePack pack, Map<T, B> blocks, String typeName, ResourceLocation ... jsonsLocations) {
        Utils.addBlockResources(modId, manager, pack, blocks, BlockTypeResTransformer.create((String)modId, (ResourceManager)manager).replaceSimpleType(typeName).IDReplaceType(typeName), jsonsLocations);
    }

    public static <B extends Block, T extends BlockType> void addBlockResources(String modId, ResourceManager manager, DynamicResourcePack pack, Map<T, B> blocks, BlockTypeResTransformer<T> modifier, ResourceLocation ... jsonsLocations) {
        List original = Arrays.stream(jsonsLocations).map(s -> StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)s)).collect(Collectors.toList());
        blocks.forEach((wood, value) -> {
            if (EarlyConfigs.isTypeEnabled(wood)) {
                for (StaticResource res : original) {
                    try {
                        StaticResource newRes = modifier.transform(res, value.getRegistryName(), wood);
                        assert (newRes.location != res.location) : "ids cant be the same";
                        pack.addResource(newRes);
                    }
                    catch (Exception e) {
                        WoodGood.LOGGER.error("Failed to generate json resource from {}", (Object)res.location);
                    }
                }
            }
        });
    }

    public static void addLeavesRecipes(String modId, ResourceManager manager, DynamicDataPack pack, Map<LeavesType, Item> blocks, String oakRecipe) {
        Utils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, LeavesType.OAK_LEAVES_TYPE);
    }

    public static <B extends Item> void addWoodRecipes(String modId, ResourceManager manager, DynamicDataPack pack, Map<WoodType, B> blocks, String oakRecipe) {
        Utils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, WoodType.OAK_WOOD_TYPE);
    }

    public static <B extends Item, T extends BlockType> void addBlocksRecipes(String modId, ResourceManager manager, DynamicDataPack pack, Map<T, B> blocks, String oakRecipe, T fromType) {
        Utils.addBlocksRecipes(manager, pack, blocks, new ResourceLocation(modId, oakRecipe), fromType);
    }

    public static <B extends Item, T extends BlockType> void addBlocksRecipes(ResourceManager manager, DynamicDataPack pack, Map<T, B> items, ResourceLocation oakRecipe, T fromType) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(oakRecipe));
        items.forEach((w, i) -> {
            if (EarlyConfigs.isTypeEnabled(w)) {
                try {
                    if (i.m_41471_() != null) {
                        FinishedRecipe newR = template.createSimilar(fromType, w, w.mainChild().m_5456_());
                        if (newR == null) {
                            return;
                        }
                        ConditionalRecipe.Builder builder = ConditionalRecipe.builder().addCondition((ICondition)new BlockTypeEnabledCondition((BlockType)w));
                        template.getConditions().forEach(arg_0 -> ((ConditionalRecipe.Builder)builder).addCondition(arg_0));
                        builder.addRecipe(newR).build(arg_0 -> ((DynamicDataPack)pack).addRecipe(arg_0), newR.m_6445_());
                    }
                }
                catch (Exception e) {
                    WoodGood.LOGGER.error("Failed to generate recipe for {}:", i, (Object)e);
                }
            }
        });
    }

    static {
        DUMMY_BLOCKSTATE.addProperty("parent", "block/cube_all");
        JsonObject t = new JsonObject();
        t.addProperty("all", "everycomp:block/disabled");
        DUMMY_BLOCKSTATE.add("textures", (JsonElement)t);
    }
}

