/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.every_compat.modules.CompatModule;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntriesRemapper {
    @SubscribeEvent
    public static void remapBlocks(RegistryEvent.MissingMappings<Block> event) {
        EntriesRemapper.remapEntries(event, ForgeRegistries.BLOCKS);
        if (((Boolean)EarlyConfigs.REMAP_OWN.get()).booleanValue()) {
            for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("everycomp")) {
                mapping.ignore();
            }
        }
    }

    @SubscribeEvent
    public static void remapItems(RegistryEvent.MissingMappings<Item> event) {
        EntriesRemapper.remapEntries(event, ForgeRegistries.ITEMS);
        if (((Boolean)EarlyConfigs.REMAP_OWN.get()).booleanValue()) {
            for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("everycomp")) {
                mapping.ignore();
            }
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void remapEntries(RegistryEvent.MissingMappings<T> event, IForgeRegistry<T> blockReg) {
        if (!((Boolean)EarlyConfigs.REMAP_COMPAT.get()).booleanValue()) {
            return;
        }
        for (WoodGood.CompatMod compatMod : WoodGood.COMPAT_MODS) {
            String woodFrom = compatMod.woodFrom();
            block1: for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings(compatMod.modId())) {
                for (String blockFrom : compatMod.blocksFrom()) {
                    CompatModule module = WoodGood.ACTIVE_MODULES.get(blockFrom);
                    if (!(module instanceof SimpleModule)) continue;
                    SimpleModule simpleModule = (SimpleModule)module;
                    for (EntrySet<?, ?> entry : simpleModule.getEntries()) {
                        SimpleEntrySet se;
                        String s;
                        if (!(entry instanceof SimpleEntrySet) || (s = (se = (SimpleEntrySet)entry).getEquivalentBlock(module, mapping.key.m_135815_(), woodFrom)) == null || !blockReg.containsKey(WoodGood.res(s))) continue;
                        IForgeRegistryEntry b = blockReg.getValue(WoodGood.res(s));
                        mapping.remap(b);
                        WoodGood.LOGGER.info("Remapping block '{}' to '{}'", (Object)mapping.key, (Object)b);
                        continue block1;
                    }
                }
            }
        }
    }
}

