/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.every_compat.misc.Utils;
import net.mehvahdjukaar.every_compat.modules.CompatModule;
import net.mehvahdjukaar.selene.block_set.BlockSetManager;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.client.asset_generators.LangBuilder;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Palette;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Respriter;
import net.mehvahdjukaar.selene.client.asset_generators.textures.TextureImage;
import net.mehvahdjukaar.selene.items.BlockTypeBasedBlockItem;
import net.mehvahdjukaar.selene.resourcepack.AfterLanguageLoadEvent;
import net.mehvahdjukaar.selene.resourcepack.BlockTypeResTransformer;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.DynamicLanguageManager;
import net.mehvahdjukaar.selene.resourcepack.DynamicResourcePack;
import net.mehvahdjukaar.selene.resourcepack.DynamicTexturePack;
import net.mehvahdjukaar.selene.resourcepack.RPAwareDynamicTextureProvider;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.mehvahdjukaar.selene.resourcepack.resources.TagBuilder;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEntrySet<T extends BlockType, B extends Block>
extends EntrySet<T, B> {
    private final Class<T> type;
    private final Pattern nameScheme;
    protected final Supplier<T> baseType;
    protected final Supplier<B> baseBlock;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final Function<T, @Nullable B> blockFactory;
    @Nullable
    protected final @Nullable TriFunction<T, B, // Could not load outer class - annotation placement on inner may be incorrect
    Item.Properties, @Nullable Item> itemFactory;
    @Nullable
    protected final TileHolder<?> tileHolder;
    protected final Supplier<CreativeModeTab> tab;
    protected final boolean copyLoot;
    protected final Map<ResourceLocation, Set<ResourceKey<?>>> tags = new HashMap();
    protected final Set<Supplier<ResourceLocation>> recipeLocations = new HashSet<Supplier<ResourceLocation>>();
    protected final Set<Pair<ResourceLocation, @Nullable ResourceLocation>> textures = new HashSet<Pair<ResourceLocation, ResourceLocation>>();
    @Nullable
    protected final @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteSupplier;
    @Nullable
    protected final Supplier<Supplier<RenderType>> renderType;
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraTransform;

    public SimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<B> baseBlock, Supplier<T> baseType, Supplier<CreativeModeTab> tab, boolean copyLoot, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable TileHolder<?> tileFactory, @Nullable Supplier<Supplier<RenderType>> renderType, @Nullable @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteSupplier, Consumer<BlockTypeResTransformer<T>> extraTransform) {
        super((String)(prefix == null ? "" : prefix + "_") + name);
        this.postfix = name;
        this.blockFactory = blockSupplier;
        this.prefix = prefix;
        this.tileHolder = tileFactory;
        this.tab = tab;
        this.copyLoot = copyLoot;
        this.baseBlock = baseBlock;
        this.baseType = baseType;
        this.itemFactory = itemFactory;
        this.type = type;
        this.extraTransform = extraTransform;
        this.renderType = renderType;
        this.paletteSupplier = paletteSupplier;
        this.nameScheme = this.prefix != null ? Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$") : Pattern.compile("^(.+?)_" + this.postfix + "$");
    }

    public TileHolder<?> getTileHolder() {
        return this.tileHolder;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public B getBaseBlock() {
        return (B)((Block)this.baseBlock.get());
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetManager.getBlockSet(this.getTypeClass()).get(new ResourceLocation(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void addTranslations(CompatModule module, AfterLanguageLoadEvent lang) {
        this.blocks.forEach((w, v) -> LangBuilder.addDynamicEntry((DynamicLanguageManager.LanguageAccessor)lang, (String)("block_type." + module.getModId() + "." + this.typeName), (BlockType)w, (Block)v));
    }

    @Override
    public void registerWoodBlocks(CompatModule module, IForgeRegistry<Block> registry, Collection<WoodType> woodTypes) {
        if (WoodType.class == this.getTypeClass()) {
            this.registerBlocks(module, registry, woodTypes);
        }
    }

    @Override
    public void registerLeavesBlocks(CompatModule module, IForgeRegistry<Block> registry, Collection<LeavesType> leavesTypes) {
        if (LeavesType.class == this.getTypeClass()) {
            this.registerBlocks(module, registry, leavesTypes);
        }
    }

    @Override
    public void registerBlocks(CompatModule module, IForgeRegistry<Block> registry, Collection<T> woodTypes) {
        Block base = (Block)this.baseBlock.get();
        if (base == null || base == Blocks.f_50016_) {
            throw new UnsupportedOperationException("Base block cant be null");
        }
        ((BlockType)this.baseType.get()).addChild(module.shortenedId() + "/" + this.typeName, (ItemLike)base);
        for (BlockType w : woodTypes) {
            Block block;
            String name = this.getBlockName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            if (w.isVanilla() || module.isEntryAlreadyRegistered(name, w, registry) || (block = (Block)this.blockFactory.apply(w)) == null) continue;
            this.blocks.put(w, block);
            if (block.getRegistryName() == null) {
                registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(WoodGood.res(fullName))));
            }
            w.addChild(module.shortenedId() + "/" + this.typeName, (ItemLike)block);
        }
    }

    @NotNull
    public String getBlockName(T w) {
        String name = this.prefix != null ? this.prefix + "_" + w.getTypeName() + "_" + this.postfix : w.getTypeName() + "_" + this.postfix;
        return name;
    }

    protected CreativeModeTab getTab(T w, B b) {
        return EarlyConfigs.isTypeEnabled(w) ? (WoodGood.MOD_TAB != null ? WoodGood.MOD_TAB : this.tab.get()) : null;
    }

    @Override
    public void registerItems(CompatModule module, IForgeRegistry<Item> registry) {
        this.blocks.forEach((w, value) -> {
            CreativeModeTab tab = this.getTab(w, value);
            Object i = this.itemFactory != null ? (Item)this.itemFactory.apply(w, value, (Object)new Item.Properties().m_41491_(tab)) : new BlockTypeBasedBlockItem(value, new Item.Properties().m_41491_(tab), w);
            if (i != null) {
                this.items.put(w, i);
                registry.register((IForgeRegistryEntry)((Item)i.setRegistryName(value.getRegistryName())));
            }
        });
    }

    @Override
    public void registerTiles(CompatModule module, IForgeRegistry<BlockEntityType<?>> registry) {
        if (this.tileHolder != null) {
            BlockEntityType<?> tile = this.tileHolder.createInstance((Block[])this.blocks.values().toArray(Block[]::new));
            registry.register((IForgeRegistryEntry)((BlockEntityType)tile.setRegistryName(WoodGood.res(module.shortenedId() + "_" + this.getName()))));
        }
    }

    @Override
    public void registerEntityRenderers(CompatModule simpleModule, EntityRenderersEvent.RegisterRenderers event) {
        if (this.tileHolder != null) {
            this.tileHolder.registerRenderer(event);
        }
    }

    @Override
    public void setRenderLayer() {
        if (this.renderType != null) {
            this.blocks.values().forEach(t -> ItemBlockRenderTypes.setRenderLayer((Block)t, (RenderType)this.renderType.get().get()));
        }
    }

    @Override
    public void generateTags(CompatModule module, DynamicDataPack pack, ResourceManager manager) {
        if (!this.tags.isEmpty()) {
            for (Map.Entry<ResourceLocation, Set<ResourceKey<?>>> tb : this.tags.entrySet()) {
                TagBuilder builder = TagBuilder.of((ResourceLocation)tb.getKey()).addEntries(this.blocks.values());
                for (ResourceKey<?> t : tb.getValue()) {
                    pack.addTag(builder, t);
                }
            }
        }
    }

    @Override
    public void generateLootTables(CompatModule module, DynamicDataPack pack, ResourceManager manager) {
        if (this.copyLoot) {
            ResourceLocation reg = ((Block)this.baseBlock.get()).getRegistryName();
            Utils.addBlockResources(module.getModId(), manager, (DynamicResourcePack)pack, this.blocks, ((BlockType)this.baseType.get()).getTypeName(), ResType.BLOCK_LOOT_TABLES.getPath(reg));
        } else {
            this.blocks.forEach((wood, value) -> pack.addSimpleBlockLootTable(value));
        }
    }

    @Override
    public void generateRecipes(CompatModule module, DynamicDataPack pack, ResourceManager manager) {
        this.recipeLocations.forEach(r -> {
            ResourceLocation res = (ResourceLocation)r.get();
            try {
                Utils.addBlocksRecipes(manager, pack, this.items, res, (BlockType)this.baseType.get());
            }
            catch (Exception e) {
                WoodGood.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res);
            }
        });
    }

    @Override
    public void generateModels(CompatModule module, DynamicTexturePack pack, ResourceManager manager) {
        Utils.addStandardResources(module.getModId(), manager, (DynamicResourcePack)pack, this.blocks, (BlockType)this.baseType.get(), this.extraTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextures(CompatModule module, RPAwareDynamicTextureProvider handler, ResourceManager manager) {
        boolean isWood;
        if (this.textures.isEmpty()) {
            return;
        }
        boolean bl = isWood = this.getTypeClass() == WoodType.class;
        if (this.paletteSupplier == null && !isWood) {
            throw new UnsupportedOperationException("You need to provide a palette supplier for non wood type based blocks");
        }
        ArrayList<TextureImage> images = new ArrayList<TextureImage>();
        try {
            HashMap respriters = new HashMap();
            for (Pair<ResourceLocation, ResourceLocation> pair : this.textures) {
                ResourceLocation textureId = (ResourceLocation)pair.getFirst();
                try {
                    Respriter r;
                    TextureImage main = TextureImage.open((ResourceManager)manager, (ResourceLocation)textureId);
                    images.add(main);
                    ResourceLocation m = (ResourceLocation)pair.getSecond();
                    if (m != null) {
                        TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)m);
                        images.add(main);
                        r = Respriter.masked((TextureImage)main, (TextureImage)mask);
                    } else {
                        r = Respriter.of((TextureImage)main);
                    }
                    respriters.put(textureId, r);
                }
                catch (Exception e) {
                    WoodGood.LOGGER.error("Failed to read block texture at: {}", pair, (Object)e);
                }
            }
            for (Map.Entry entry : this.blocks.entrySet()) {
                Block b = (Block)entry.getValue();
                BlockType w = (BlockType)entry.getKey();
                if (!EarlyConfigs.isTypeEnabled(w)) continue;
                ResourceLocation blockId = b.getRegistryName();
                List targetPalette = null;
                AnimationMetadataSection animation = null;
                if (this.paletteSupplier != null) {
                    Pair<List<Palette>, AnimationMetadataSection> pal = this.paletteSupplier.apply(w, manager);
                    animation = (AnimationMetadataSection)pal.getSecond();
                    targetPalette = (List)pal.getFirst();
                } else {
                    try (TextureImage plankTexture22 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)((WoodType)w).planks));){
                        targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture22);
                        animation = plankTexture22.getMetadata();
                    }
                    catch (Exception plankTexture22) {
                        // empty catch block
                    }
                }
                if (targetPalette == null) {
                    WoodGood.LOGGER.error("Could not get texture palette for block {} : ", (Object)b);
                    continue;
                }
                AnimationMetadataSection finalAnimation = animation;
                List finalTargetPalette = targetPalette;
                int oldSize = ((Palette)finalTargetPalette.get(0)).size();
                for (Map.Entry re : respriters.entrySet()) {
                    if (oldSize != ((Palette)finalTargetPalette.get(0)).size()) {
                        throw new RuntimeException("This should not happen");
                    }
                    String oldPath = ((ResourceLocation)re.getKey()).m_135815_();
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)w, (ResourceLocation)blockId, (String)((BlockType)this.baseType.get()).getTypeName());
                    Respriter respriter = (Respriter)re.getValue();
                    if (isWood) {
                        module.addWoodTexture((WoodType)w, handler, manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation));
                        continue;
                    }
                    handler.addTextureIfNotPresent(manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation));
                }
            }
        }
        catch (Exception e) {
            WoodGood.LOGGER.error("Could not generate any block texture for entry set {} : ", (Object)module.modRes(this.getName()), (Object)e);
        }
        finally {
            for (TextureImage t : images) {
                t.close();
            }
        }
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> builder(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> builder(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static class TileHolder<H extends BlockEntity> {
        protected final BlockEntityType.BlockEntitySupplier<H> tileFactory;
        protected Supplier<BlockEntityRendererProvider<H>> renderer = null;
        public BlockEntityType<? extends H> tile = null;

        @OnlyIn(value=Dist.CLIENT)
        public TileHolder(BlockEntityType.BlockEntitySupplier<H> tileFactory, Supplier<BlockEntityRendererProvider<H>> renderer) {
            this.tileFactory = tileFactory;
            this.renderer = renderer;
        }

        public TileHolder(BlockEntityType.BlockEntitySupplier<H> tileFactory) {
            this.tileFactory = tileFactory;
        }

        public BlockEntityType<? extends H> get() {
            return this.tile;
        }

        public BlockEntityType<? extends H> createInstance(Block ... blocks) {
            if (this.tile != null) {
                throw new UnsupportedOperationException("tile has already been created");
            }
            this.tile = BlockEntityType.Builder.m_155273_(this.tileFactory, (Block[])blocks).m_58966_(null);
            return this.tile;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerRenderer(EntityRenderersEvent.RegisterRenderers event) {
            if (this.renderer != null) {
                event.registerBlockEntityRenderer(this.tile, this.renderer.get());
            }
        }
    }

    public static class Builder<T extends BlockType, B extends Block> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final Supplier<B> baseBlock;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<CreativeModeTab> tab = () -> CreativeModeTab.f_40750_;
        protected boolean copyLoot = false;
        protected final Function<T, B> blockFactory;
        @Nullable
        protected TriFunction<T, B, Item.Properties, Item> itemFactory;
        @Nullable
        protected TileHolder<?> tileFactory;
        @Nullable
        protected Supplier<Supplier<RenderType>> renderType = null;
        @Nullable
        protected @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> palette = null;
        protected final Map<ResourceLocation, Set<ResourceKey<?>>> tags = new HashMap();
        protected final Set<Supplier<ResourceLocation>> recipes = new HashSet<Supplier<ResourceLocation>>();
        protected final Set<Pair<ResourceLocation, @Nullable ResourceLocation>> textures = new HashSet<Pair<ResourceLocation, ResourceLocation>>();
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            this.baseType = baseType;
            this.baseBlock = baseBlock;
            this.name = name;
            this.prefix = prefix;
            this.blockFactory = blockFactory;
            this.type = type;
        }

        public SimpleEntrySet<T, B> build() {
            SimpleEntrySet<T, B> e = new SimpleEntrySet<T, B>(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.copyLoot, this.itemFactory, this.tileFactory, this.renderType, this.palette, this.extraModelTransform);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }

        public <H extends BlockEntity> Builder<T, B> addTile(BlockEntityType.BlockEntitySupplier<H> tileFactory) {
            this.tileFactory = new TileHolder<H>(tileFactory);
            return this;
        }

        public <H extends BlockEntity> Builder<T, B> addTile(BlockEntityType.BlockEntitySupplier<H> tileFactory, Supplier<BlockEntityRendererProvider<H>> renderer) {
            this.tileFactory = FMLEnvironment.dist == Dist.CLIENT ? new TileHolder<H>(tileFactory, renderer) : new TileHolder<H>(tileFactory);
            return this;
        }

        public Builder<T, B> addCustomItem(TriFunction<T, B, Item.Properties, Item> itemFactory) {
            this.itemFactory = itemFactory;
            return this;
        }

        public Builder<T, B> addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return this;
        }

        public Builder<T, B> noItem() {
            this.itemFactory = (a, b, c) -> null;
            return this;
        }

        public Builder<T, B> setTab(Supplier<CreativeModeTab> tab) {
            this.tab = tab;
            return this;
        }

        public Builder<T, B> useLootFromBase() {
            this.copyLoot = true;
            return this;
        }

        public Builder<T, B> setRenderType(Supplier<Supplier<RenderType>> renderType) {
            this.renderType = renderType;
            return this;
        }

        public Builder<T, B> addTag(ResourceLocation location, ResourceKey<?> registry) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.add(registry);
            return this;
        }

        public Builder<T, B> addTag(TagKey<?> tag, ResourceKey<?> registry) {
            this.addTag(tag.f_203868_(), registry);
            return this;
        }

        public Builder<T, B> defaultRecipe() {
            this.recipes.add(() -> ((Block)this.baseBlock.get()).getRegistryName());
            return this;
        }

        public Builder<T, B> addRecipe(ResourceLocation resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return this;
        }

        public Builder<T, B> addTexture(ResourceLocation resourceLocation) {
            this.textures.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)resourceLocation, null));
            return this;
        }

        public Builder<T, B> addTextureM(ResourceLocation textureLocation, ResourceLocation maskLocation) {
            this.textures.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)textureLocation, (Object)maskLocation));
            return this;
        }

        public Builder<T, B> setPalette(BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteProvider) {
            this.palette = paletteProvider;
            return this;
        }

        public Builder<T, B> createPaletteFromOak(Consumer<Palette> paletteTransform) {
            return this.setPalette((w, m) -> {
                Pair pair;
                block8: {
                    TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)((WoodType)w).planks));
                    try {
                        List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                        targetPalette.forEach(paletteTransform);
                        pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                        if (plankTexture == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (plankTexture != null) {
                                try {
                                    plankTexture.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                        }
                    }
                    plankTexture.close();
                }
                return pair;
            });
        }
    }
}

