/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.configs.BlockTypeEnabledCondition;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.AllWoodItem;
import net.mehvahdjukaar.every_compat.misc.CustomRecipeLoader;
import net.mehvahdjukaar.every_compat.misc.EntriesRemapper;
import net.mehvahdjukaar.every_compat.modules.CompatModule;
import net.mehvahdjukaar.every_compat.modules.another_furniture.AnotherFurnitureModule;
import net.mehvahdjukaar.every_compat.modules.architect_palette.ArchitectsPaletteModule;
import net.mehvahdjukaar.every_compat.modules.backpacked.BackpackedModule;
import net.mehvahdjukaar.every_compat.modules.camp_chair.CampChairModule;
import net.mehvahdjukaar.every_compat.modules.create.CreateModule;
import net.mehvahdjukaar.every_compat.modules.deco_block.DecorativeBlocksModule;
import net.mehvahdjukaar.every_compat.modules.farmersdelight.FarmersDelightModule;
import net.mehvahdjukaar.every_compat.modules.mcaw.MacawBridgesModule;
import net.mehvahdjukaar.every_compat.modules.mcaw.MacawDoorsModule;
import net.mehvahdjukaar.every_compat.modules.mcaw.MacawFencesModule;
import net.mehvahdjukaar.every_compat.modules.mcaw.MacawLightsModule;
import net.mehvahdjukaar.every_compat.modules.mcaw.MacawPathsModule;
import net.mehvahdjukaar.every_compat.modules.mcaw.MacawTrapdoorsModule;
import net.mehvahdjukaar.every_compat.modules.mcaw.MacawWindowsModule;
import net.mehvahdjukaar.every_compat.modules.missing_wilds.MissingWildModule;
import net.mehvahdjukaar.every_compat.modules.mrcrayfish_furniture.MrCrayfishFurnitureModule;
import net.mehvahdjukaar.every_compat.modules.quark.QuarkModule;
import net.mehvahdjukaar.every_compat.modules.twigs.TwigsModule;
import net.mehvahdjukaar.every_compat.modules.twilightforest.TwilightForestModule;
import net.mehvahdjukaar.every_compat.modules.valhelsia_structures.ValhelsiaStructuresModule;
import net.mehvahdjukaar.selene.block_set.BlockSetManager;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="everycomp")
public class WoodGood {
    public static final String MOD_ID = "everycomp";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Map<String, CompatModule> ACTIVE_MODULES = new LinkedHashMap<String, CompatModule>();
    public static final List<CompatMod> COMPAT_MODS = new ArrayList<CompatMod>();
    public static ServerDynamicResourcesHandler SERVER_RESOURCES = null;
    public static ClientDynamicResourcesHandler CLIENT_RESOURCES = null;
    public static CreativeModeTab MOD_TAB = null;
    private int prevRegSize;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void forAllModules(Consumer<CompatModule> action) {
        ACTIVE_MODULES.values().forEach(action);
    }

    public WoodGood() {
        this.addOtherCompatMod("compatoplenty", "biomesoplenty", List.of("twigs", "farmersdelight", "quark"));
        this.addOtherCompatMod("compat_makeover", "biomemakeover", List.of("habitat", "farmersdelight", "quark", "decorative_blocks"));
        this.addOtherCompatMod("decorative_compat", "biomesoplenty", List.of("decorative_blocks"));
        this.addOtherCompatMod("macawsbridgesbop", "biomesoplenty", List.of("mcwbridges"));
        this.addOtherCompatMod("macawbridgesbyg", "byg", List.of("mcwbridges"));
        this.addOtherCompatMod("mcwfencesbop", "biomesoplenty", List.of("mcwfences"));
        this.addOtherCompatMod("mcwfencesbyg", "byg", List.of("mcwfences"));
        this.addOtherCompatMod("macawsroofsbop", "biomesoplenty", List.of("mcwroofs"));
        this.addOtherCompatMod("macawsroofsbyg", "byg", List.of("mcwroofs"));
        this.addOtherCompatMod("storagedrawersunlimited", "biomesoplenty", List.of("storagedrawers"));
        this.addModule("mcwdoors", () -> MacawDoorsModule::new);
        this.addModule("mcwlights", () -> MacawLightsModule::new);
        this.addModule("mcwpaths", () -> MacawPathsModule::new);
        this.addModule("mcwtrpdoors", () -> MacawTrapdoorsModule::new);
        this.addModule("mcwwindows", () -> MacawWindowsModule::new);
        this.addModule("mcwfences", () -> MacawFencesModule::new);
        this.addModule("mcwbridges", () -> MacawBridgesModule::new);
        this.addModule("decorative_blocks", () -> DecorativeBlocksModule::new);
        this.addModule("twigs", () -> TwigsModule::new);
        this.addModule("another_furniture", () -> AnotherFurnitureModule::new);
        this.addModule("backpacked", () -> BackpackedModule::new);
        this.addModule("farmersdelight", () -> FarmersDelightModule::new);
        this.addModule("architects_palette", () -> ArchitectsPaletteModule::new);
        this.addModule("cfm", () -> MrCrayfishFurnitureModule::new);
        this.addModule("create", () -> CreateModule::new);
        this.addModule("twilightforest", () -> TwilightForestModule::new);
        this.addModule("valhelsia_structures", () -> ValhelsiaStructuresModule::new);
        this.addModule("quark", () -> QuarkModule::new);
        this.addModule("cfm", () -> MrCrayfishFurnitureModule::new);
        this.addModule("campchair", () -> CampChairModule::new);
        this.addModule("missingwilds", () -> MissingWildModule::new);
        WoodGood.forAllModules(m -> LOGGER.info("Loaded {}", (Object)m.toString()));
        BlockSetManager.addBlockSetRegistrationCallback(this::registerWoodStuff, Block.class, WoodType.class);
        BlockSetManager.addBlockSetRegistrationCallback(this::registerLeavesStuff, Block.class, LeavesType.class);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(CustomRecipeLoader::onEarlyPackLoad);
        MinecraftForge.EVENT_BUS.register(EntriesRemapper.class);
        SERVER_RESOURCES = new ServerDynamicResourcesHandler();
        SERVER_RESOURCES.register(bus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CLIENT_RESOURCES = new ClientDynamicResourcesHandler();
            CLIENT_RESOURCES.register(bus);
        } else {
            CLIENT_RESOURCES = null;
        }
        CraftingHelper.register((IConditionSerializer)new BlockTypeEnabledCondition.Serializer());
    }

    public static void createModTab() {
        MOD_TAB = new CreativeModeTab(MOD_ID){

            public ItemStack m_6976_() {
                return ((Item)ForgeRegistries.ITEMS.getValue(WoodGood.res("all_woods"))).m_7968_();
            }

            public boolean hasSearchBar() {
                return true;
            }
        }.m_40779_("item_search.png");
    }

    private void addOtherCompatMod(String modId, String woodFrom, List<String> blocksFrom) {
        COMPAT_MODS.add(new CompatMod(modId, woodFrom, blocksFrom));
    }

    private void addModule(String modId, Supplier<Function<String, CompatModule>> moduleFactory) {
        if (ModList.get().isLoaded(modId)) {
            ACTIVE_MODULES.put(modId, moduleFactory.get().apply(modId));
        }
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> WoodGood.forAllModules(CompatModule::onModSetup));
    }

    public void registerWoodStuff(RegistryEvent.Register<Block> event, Collection<WoodType> woods) {
        EarlyConfigs.init();
        this.prevRegSize = ForgeRegistries.BLOCKS.getValues().size();
        LOGGER.info("Registering Compat Wood Blocks");
        IForgeRegistry reg = event.getRegistry();
        WoodGood.forAllModules(m -> m.registerWoodBlocks((IForgeRegistry<Block>)reg, woods));
    }

    public void registerLeavesStuff(RegistryEvent.Register<Block> event, Collection<LeavesType> leaves) {
        LOGGER.info("Registering Compat Leaves Blocks");
        IForgeRegistry reg = event.getRegistry();
        WoodGood.forAllModules(m -> m.registerLeavesBlocks((IForgeRegistry<Block>)reg, leaves));
        int newSize = ForgeRegistries.BLOCKS.getValues().size();
        int am = newSize - this.prevRegSize;
        float p = (float)am / (float)newSize * 100.0f;
        LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)am, (Object)Float.valueOf(p));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        WoodGood.forAllModules(m -> m.registerItems((IForgeRegistry<Item>)event.getRegistry()));
        event.getRegistry().register((IForgeRegistryEntry)((Item)new AllWoodItem().setRegistryName(WoodGood.res("all_woods"))));
    }

    @SubscribeEvent
    public void registerTiles(RegistryEvent.Register<BlockEntityType<?>> event) {
        WoodGood.forAllModules(m -> m.registerTiles(event.getRegistry()));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        WoodGood.forAllModules(m -> m.registerEntities(event.getRegistry()));
    }

    public record CompatMod(String modId, String woodFrom, List<String> blocksFrom) {
    }
}

