/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import owmii.powah.lib.client.screen.Texture;

public class IconButton
extends Button {
    protected final Minecraft mc = Minecraft.m_91087_();
    private Consumer<List<Component>> tooltipConsumer = stringList -> {};
    private Screen screen;
    private Texture texture;
    private Texture hovering;
    private ItemStack stack;
    private float xOffset;
    private float yOffset;
    @Nullable
    private SoundEvent sound;
    public static final IconButton EMPTY = new IconButton(0, 0, Texture.EMPTY, b -> {}, (Screen)new ChatScreen(""));

    public IconButton(int x, int y, Component text, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.f_41583_, texture, Texture.EMPTY, text, onPress, screen);
    }

    public IconButton(int x, int y, Component text, Texture texture, Button.OnPress onPress, Texture hovering, Screen screen) {
        this(x, y, ItemStack.f_41583_, texture, hovering, text, onPress, screen);
    }

    public IconButton(int x, int y, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.f_41583_, texture, Texture.EMPTY, (Component)new TextComponent(""), onPress, screen);
    }

    public IconButton(int x, int y, Texture texture, Texture hovering, Button.OnPress onPress, Screen screen) {
        this(x, y, ItemStack.f_41583_, texture, hovering, (Component)new TextComponent(""), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Button.OnPress onPress, Screen screen) {
        this(x, y, stack, texture, Texture.EMPTY, (Component)new TextComponent(""), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Texture hovering, Button.OnPress onPress, Screen screen) {
        this(x, y, stack, texture, hovering, (Component)new TextComponent(""), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Texture hovering, Component text, Button.OnPress onPress, Screen screen) {
        super(x, y, texture.getWidth(), texture.getHeight(), text, onPress);
        this.texture = texture;
        this.screen = screen;
        this.hovering = hovering;
        this.stack = stack;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float pt) {
        if (this.f_93624_) {
            boolean bl = this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            if (this.f_93622_ && !this.hovering.isEmpty()) {
                this.hovering.draw(matrix, this.f_93620_, this.f_93621_);
            } else {
                this.texture.draw(matrix, this.f_93620_, this.f_93621_);
            }
            Font f = this.mc.f_91062_;
            String s = this.m_6035_().getString();
            if (!s.isEmpty()) {
                int width = f.m_92895_(s);
                TextColor c = this.m_6035_().m_7383_().m_131135_();
                int color = c == null ? 0x555555 : c.m_131265_();
                f.m_92883_(matrix, s, this.xOffset + (float)this.f_93620_ + 0.5f + (float)this.f_93618_ / 2.0f - (float)width / 2.0f, this.yOffset + (float)this.f_93621_ + (float)this.f_93619_ / 2.0f - 4.0f, color);
            }
            if (!this.stack.m_41619_()) {
                PoseStack globalStack = RenderSystem.m_157191_();
                globalStack.m_85836_();
                Minecraft mc = Minecraft.m_91087_();
                globalStack.m_85837_((double)(this.xOffset + (float)this.f_93620_) - 8.0 + (double)((float)this.f_93618_ / 2.0f), (double)(this.yOffset + (float)this.f_93621_) - 8.0 + (double)((float)this.f_93619_ / 2.0f), 0.0);
                mc.m_91291_().m_115203_(this.stack, 0, 0);
                globalStack.m_85849_();
                RenderSystem.m_157182_();
            }
        }
    }

    public void m_7428_(PoseStack matrix, int mouseX, int mouseY) {
        ArrayList tooltip = new ArrayList();
        this.tooltipConsumer.accept(tooltip);
        if (!tooltip.isEmpty()) {
            this.screen.m_96597_(matrix, tooltip, mouseX, mouseY);
        }
    }

    public void blit(PoseStack matrix, Texture texture, int x, int y) {
        this.bindTexture(texture.getLocation());
        this.m_93228_(matrix, x, y, texture.getU(), texture.getV(), texture.getWidth(), texture.getHeight());
    }

    public void bindTexture(ResourceLocation guiTexture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)guiTexture);
    }

    public Screen getScreen() {
        return this.screen;
    }

    public IconButton setScreen(Screen screen) {
        this.screen = screen;
        return this;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public IconButton setTexture(Texture texture) {
        this.texture = texture;
        return this;
    }

    public Texture getHovering() {
        return this.hovering;
    }

    public IconButton setHovering(Texture hovering) {
        this.hovering = hovering;
        return this;
    }

    public Consumer<List<Component>> getTooltip() {
        return this.tooltipConsumer;
    }

    public IconButton setTooltip(Consumer<List<Component>> tooltipConsumer) {
        this.tooltipConsumer = tooltipConsumer;
        return this;
    }

    public IconButton setStackInSlot(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public IconButton xOffset(float xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    public IconButton yOffset(float yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public void m_7435_(SoundManager handler) {
        if (this.sound != null) {
            handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.sound, (float)1.0f));
        }
    }

    public IconButton setClickSound() {
        this.sound = SoundEvents.f_12490_;
        return this;
    }

    public IconButton setSound(@Nullable SoundEvent sound) {
        this.sound = sound;
        return this;
    }
}

