/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.IBlockEntity;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.IRedstoneInteract;
import owmii.powah.lib.logistics.Redstone;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.util.Stack;

public class AbstractTileEntity<V extends IVariant, B extends AbstractBlock<V, B>>
extends BlockEntity
implements IBlockEntity,
IRedstoneInteract {
    protected final Inventory inv = Inventory.createBlank();
    protected final Tank tank = new Tank(0);
    protected V variant;
    protected boolean isContainerOpen;
    private Redstone redstone = Redstone.IGNORE;

    public AbstractTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, IVariant.getEmpty());
        this.tank.validate(stack -> true);
    }

    public AbstractTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, V variant) {
        super(type, pos, state);
        this.variant = variant;
        if (this instanceof IInventoryHolder) {
            this.inv.setTile((IInventoryHolder)((Object)this));
        }
    }

    public B getBlock() {
        return (B)((AbstractBlock)this.m_58900_().m_60734_());
    }

    public V getVariant() {
        return this.variant;
    }

    public final void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readSync(tag);
        if (!tag.m_128441_("#c")) {
            this.loadServerOnly(tag);
        }
    }

    protected final void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeSync(tag);
        this.saveServerOnly(tag);
    }

    public final CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        tag.m_128379_("#c", true);
        return tag;
    }

    @Nullable
    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void loadServerOnly(CompoundTag compound) {
    }

    protected CompoundTag saveServerOnly(CompoundTag compound) {
        return compound;
    }

    protected void readSync(CompoundTag nbt) {
        if (!this.variant.isEmpty() && nbt.m_128425_("variant", 3)) {
            this.variant = (IVariant)this.variant.read(nbt, "variant");
        }
        if (this instanceof IInventoryHolder && !this.keepInventory()) {
            this.inv.deserializeNBT(nbt);
        }
        if (this instanceof ITankHolder && !((ITankHolder)((Object)this)).keepFluid()) {
            this.tank.readFromNBT(nbt);
        }
        this.redstone = Redstone.values()[nbt.m_128451_("redstone_mode")];
        this.readStorable(nbt);
    }

    protected CompoundTag writeSync(CompoundTag nbt) {
        if (!this.variant.isEmpty()) {
            this.variant.write(nbt, (Enum)((Enum)this.variant), "variant");
        }
        if (this instanceof IInventoryHolder && !this.keepInventory()) {
            nbt.m_128391_(this.inv.serializeNBT());
        }
        if (this instanceof ITankHolder && !((ITankHolder)((Object)this)).keepFluid()) {
            this.tank.writeToNBT(nbt);
        }
        nbt.m_128405_("redstone_mode", this.redstone.ordinal());
        return this.writeStorable(nbt);
    }

    public void readStorable(CompoundTag nbt) {
        if (this instanceof IInventoryHolder && this.keepInventory()) {
            this.inv.deserializeNBT(nbt);
        }
        if (this instanceof ITankHolder && ((ITankHolder)((Object)this)).keepFluid()) {
            this.tank.readFromNBT(nbt);
        }
    }

    public CompoundTag writeStorable(CompoundTag nbt) {
        if (this instanceof IInventoryHolder && this.keepInventory()) {
            nbt.m_128391_(this.inv.serializeNBT());
        }
        if (this instanceof ITankHolder && ((ITankHolder)((Object)this)).keepFluid()) {
            this.tank.writeToNBT(nbt);
        }
        return nbt;
    }

    @Override
    public void onPlaced(Level world, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CompoundTag tag = Stack.getTagOrEmpty(stack);
        if (!tag.m_128456_()) {
            this.readStorable(tag.m_128469_("powah_tile_data"));
        }
    }

    @Override
    public void onRemoved(Level world, BlockState state, BlockState newState, boolean isMoving) {
        if (!(state.m_60734_() == newState.m_60734_() || !(this instanceof IInventoryHolder) || this.keepInventory() && this.keepStorable())) {
            this.getInventory().drop(world, this.f_58858_);
        }
    }

    public ItemStack storeToStack(ItemStack stack) {
        CompoundTag nbt = this.writeStorable(new CompoundTag());
        CompoundTag nbt1 = Stack.getTagOrEmpty(stack);
        if (!nbt.m_128456_() && this.keepStorable()) {
            nbt1.m_128365_("powah_tile_data", (Tag)nbt);
            stack.m_41751_(nbt1);
        }
        return stack;
    }

    public static <T extends AbstractTileEntity> T fromStack(ItemStack stack, T tile) {
        CompoundTag nbt = stack.m_41737_("powah_tile_data");
        if (nbt != null) {
            tile.readStorable(nbt);
        }
        return tile;
    }

    public boolean keepStorable() {
        return true;
    }

    protected boolean keepInventory() {
        return false;
    }

    public Tank getTank() {
        return this.tank;
    }

    @Override
    public Redstone getRedstoneMode() {
        return this.redstone;
    }

    @Override
    public void setRedstoneMode(Redstone mode) {
        this.redstone = mode;
    }

    public boolean checkRedstone() {
        boolean power = this.f_58857_ != null && this.f_58857_.m_46755_(this.f_58858_) > 0;
        return Redstone.IGNORE.equals((Object)this.getRedstoneMode()) || power && Redstone.ON.equals((Object)this.getRedstoneMode()) || !power && Redstone.OFF.equals((Object)this.getRedstoneMode());
    }

    public void sync() {
        if (this.f_58857_ instanceof ServerLevel) {
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }

    public boolean isRemote() {
        return this.f_58857_ != null && this.f_58857_.f_46443_;
    }

    public void setContainerOpen(boolean value) {
        boolean b = this.isContainerOpen;
        this.isContainerOpen = value;
        if (b != value) {
            this.sync();
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

