/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import owmii.powah.Powah;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.Tier;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.lib.item.EnergyItem;
import owmii.powah.lib.logistics.energy.Energy;

public class BatteryItem
extends EnergyItem<Tier, EnergyConfig, BatteryItem>
implements IEnderExtender {
    public BatteryItem(Item.Properties properties, Tier variant) {
        super(properties, variant);
    }

    @Override
    public IEnergyConfig<Tier> getConfig() {
        return Powah.config().devices.batteries;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player && this.isCharging(stack)) {
            Energy.ifPresent(stack, storage -> storage.chargeInventory((Player)entity, stack1 -> !(stack1.m_41720_() instanceof BatteryItem)));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.switchCharging(stack);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean m_142522_(ItemStack stack) {
        Energy energy = Energy.getEnergy(stack).orElse(Energy.Item.create(0L));
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    public int m_142158_(ItemStack stack) {
        Energy energy = Energy.getEnergy(stack).orElse(Energy.Item.create(0L));
        return Math.min(1 + 12 * energy.getEnergyStored() / energy.getMaxEnergyStored(), 13);
    }

    public boolean m_5812_(ItemStack stack) {
        return this.isCharging(stack);
    }

    private void switchCharging(ItemStack stack) {
        this.setCharging(stack, !this.isCharging(stack));
    }

    private boolean isCharging(ItemStack stack) {
        return stack.m_41784_().m_128471_("charging");
    }

    private void setCharging(ItemStack stack, boolean charging) {
        stack.m_41784_().m_128379_("charging", charging);
    }

    @Override
    public long getExtendedCapacity(ItemStack stack) {
        return this.getConfig().getCapacity((Tier)this.getVariant());
    }

    @Override
    public long getExtendedEnergy(ItemStack stack) {
        return Energy.getStored(stack);
    }
}

