/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import owmii.powah.Powah;
import owmii.powah.block.Blcks;
import owmii.powah.forge.compat.jei.CoolantCategory;
import owmii.powah.forge.compat.jei.HeatSourceCategory;
import owmii.powah.forge.compat.jei.SolidCoolantCategory;
import owmii.powah.forge.compat.jei.energizing.EnergizingCategory;
import owmii.powah.forge.compat.jei.magmator.MagmatorCategory;
import owmii.powah.item.Itms;
import owmii.powah.lib.util.Recipe;
import owmii.powah.recipe.Recipes;

@JeiPlugin
public class PowahJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MagmatorCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CoolantCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidCoolantCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HeatSourceCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnergizingCategory(helper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blcks.ENERGIZING_ORB.get()), new ResourceLocation[]{EnergizingCategory.ID});
        Blcks.ENERGIZING_ROD.getAll().forEach(block -> registration.addRecipeCatalyst(new ItemStack((ItemLike)block), new ResourceLocation[]{EnergizingCategory.ID}));
        Blcks.MAGMATOR.getAll().forEach(block -> registration.addRecipeCatalyst(new ItemStack((ItemLike)block), new ResourceLocation[]{MagmatorCategory.ID}));
        Blcks.THERMO_GENERATOR.getAll().forEach(block -> {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)block), new ResourceLocation[]{HeatSourceCategory.ID});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)block), new ResourceLocation[]{CoolantCategory.ID});
        });
        Blcks.REACTOR.getAll().forEach(block -> {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)block), new ResourceLocation[]{SolidCoolantCategory.ID});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)block), new ResourceLocation[]{CoolantCategory.ID});
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(Recipe.getAll((Level)Minecraft.m_91087_().f_91073_, Recipes.ENERGIZING.get()), EnergizingCategory.ID);
        registration.addRecipes(MagmatorCategory.Maker.getBucketRecipes(registration.getIngredientManager()), MagmatorCategory.ID);
        registration.addRecipes(CoolantCategory.Maker.getBucketRecipes(registration.getIngredientManager()), CoolantCategory.ID);
        registration.addRecipes(SolidCoolantCategory.Maker.getBucketRecipes(registration.getIngredientManager()), SolidCoolantCategory.ID);
        registration.addRecipes(HeatSourceCategory.Maker.getBucketRecipes(registration.getIngredientManager()), HeatSourceCategory.ID);
        if (Powah.config().general.player_aerial_pearl) {
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)Itms.PLAYER_AERIAL_PEARL.get()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.powah.player_aerial_pearl")});
        }
        if (Powah.config().general.dimensional_binding_card) {
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)Itms.BINDING_CARD_DIM.get()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.powah.binding_card_dim")});
        }
        if (Powah.config().general.lens_of_ender) {
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)Itms.LENS_OF_ENDER.get()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.powah.lens_of_ender")});
        }
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("powah", "main");
    }
}

