/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import owmii.powah.Powah;
import owmii.powah.api.PowahAPI;

public class HeatSourceCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", "heat.sources");
    private final IDrawable background;
    private final IDrawable icon;

    public HeatSourceCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Blocks.f_50450_));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.powah.jei.category.heat.sources");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        if (recipe.fluid == null) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)recipe.getBlock()));
        } else {
            ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(recipe.fluid, 1000));
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        if (recipe.fluid == null) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 3, 4);
            itemStacks.set(ingredients);
        } else {
            IGuiFluidStackGroup fluidStack = iRecipeLayout.getFluidStacks();
            fluidStack.init(0, true, 4, 5);
            fluidStack.set(ingredients);
        }
    }

    public void draw(Recipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, ChatFormatting.DARK_GRAY + I18n.m_118938_((String)"info.lollipop.temperature", (Object[])new Object[0]) + ": " + ChatFormatting.RESET + I18n.m_118938_((String)"info.lollipop.temperature.c", (Object[])new Object[]{recipe.heat}), 30.0f, 9.0f, 12858368);
    }

    public static class Recipe {
        private final Block block;
        private final int heat;
        @Nullable
        private final Fluid fluid;

        public Recipe(Block block, int heat) {
            this.fluid = block instanceof LiquidBlock ? ((LiquidBlock)block).getFluid() : null;
            this.block = block;
            this.heat = heat;
            Powah.LOGGER.debug("HEAT SOURCE RECIPE INIT: " + this);
        }

        @Nullable
        public Fluid getFluid() {
            return this.fluid;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getHeat() {
            return this.heat;
        }

        public String toString() {
            return "HeatSourceRecipe{" + this.block.getRegistryName() + (String)(this.fluid != null ? " (fluid " + this.fluid.getRegistryName() + ")" : "") + " -> " + this.heat + "}";
        }
    }

    public static class Maker {
        public static List<Recipe> getBucketRecipes(IIngredientManager ingredientManager) {
            Collection allItemStacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
            ArrayList<Recipe> recipes = new ArrayList<Recipe>();
            Powah.LOGGER.debug("HEAT SOURCE RECIPE ALL: [" + PowahAPI.HEAT_SOURCES.entrySet().stream().map(e -> e.getKey() + " -> " + e.getValue()).collect(Collectors.joining(", ")) + "]");
            allItemStacks.forEach(stack -> {
                BlockItem item;
                Block block;
                if (stack.m_41720_() instanceof BlockItem && PowahAPI.HEAT_SOURCES.containsKey(block = (item = (BlockItem)stack.m_41720_()).m_40614_())) {
                    recipes.add(new Recipe(block, PowahAPI.getHeatSource(block)));
                }
            });
            Collection allIngredients = ingredientManager.getAllIngredients(VanillaTypes.FLUID);
            allIngredients.forEach(fluidStack -> {
                Block block;
                if (!fluidStack.isEmpty() && PowahAPI.HEAT_SOURCES.containsKey(block = fluidStack.getFluid().m_76145_().m_76188_().m_60734_())) {
                    recipes.add(new Recipe(block, PowahAPI.getHeatSource(block)));
                }
            });
            return recipes;
        }
    }
}

