/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import owmii.powah.api.PowahAPI;

public class CoolantCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", ".coolant");
    private final IDrawable background;
    private final IDrawable icon;

    public CoolantCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Items.f_42447_));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.powah.jei.category.coolant");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(recipe.getFluid(), 1000));
        if (!Items.f_42446_.equals(recipe.bucket)) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)recipe.bucket));
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStack = iRecipeLayout.getFluidStacks();
        fluidStack.init(0, true, 4, 5);
        fluidStack.set(ingredients);
    }

    public void draw(Recipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, I18n.m_118938_((String)"info.lollipop.temperature", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"info.lollipop.temperature.c", (Object[])new Object[]{"" + ChatFormatting.DARK_AQUA + recipe.coldness}), 30.0f, 9.0f, 0x444444);
    }

    public static class Recipe {
        private final Fluid fluid;
        private final BucketItem bucket;
        private final int coldness;

        public Recipe(BucketItem bucket, int coldness) {
            this.bucket = bucket;
            this.fluid = bucket.getFluid();
            this.coldness = coldness;
        }

        public Recipe(Fluid fluid, int coldness) {
            this.bucket = (BucketItem)Items.f_42446_;
            this.fluid = fluid;
            this.coldness = coldness;
        }

        public BucketItem getBucket() {
            return this.bucket;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public int getColdness() {
            return this.coldness;
        }
    }

    public static class Maker {
        public static List<Recipe> getBucketRecipes(IIngredientManager ingredientManager) {
            Collection allItemStacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
            ArrayList<Recipe> recipes = new ArrayList<Recipe>();
            allItemStacks.forEach(stack -> {
                Item patt3648$temp = stack.m_41720_();
                if (patt3648$temp instanceof BucketItem) {
                    Fluid fluid;
                    BucketItem bucket = (BucketItem)patt3648$temp;
                    if (!(stack.m_41720_() instanceof MobBucketItem) && PowahAPI.getCoolant(fluid = bucket.getFluid()) != 0) {
                        recipes.add(new Recipe(bucket, PowahAPI.getCoolant(fluid)));
                    }
                }
            });
            List fluids = PowahAPI.COOLANT_FLUIDS.keySet().stream().flatMap(f -> Registry.f_122822_.m_6612_(f).stream()).collect(Collectors.toCollection(ArrayList::new));
            recipes.forEach(recipe -> fluids.remove(recipe.fluid));
            return recipes;
        }
    }
}

