/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config.v2;

import java.lang.reflect.Field;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.DeserializationException;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import owmii.powah.api.PowahAPI;
import owmii.powah.config.v2.DefaultEnergies;
import owmii.powah.config.v2.annotations.DoubleRange;
import owmii.powah.config.v2.annotations.LongRange;
import owmii.powah.config.v2.types.CableConfig;
import owmii.powah.config.v2.types.ChargingConfig;
import owmii.powah.config.v2.types.EnderConfig;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.config.v2.types.GeneratorConfig;
import owmii.powah.config.v2.values.TieredChannelValues;

@Config(name="powah")
public class PowahConfig
implements ConfigData {
    @Comment(value="World generation config options.")
    public final WorldGen worldgen = new WorldGen();
    @Comment(value="Other general config options.")
    public final General general = new General();
    @Comment(value="Configuration of energy values for generators.")
    public final Generators generators = new Generators();
    @Comment(value="Configuration of energy values for other devices.")
    public final EnergyDevices devices = new EnergyDevices();

    public void validatePostLoad() throws ConfigData.ValidationException {
        try {
            PowahConfig.validateObject(this);
        }
        catch (ReflectiveOperationException roe) {
            throw new ConfigData.ValidationException("Failed to validate Powah config", (Throwable)roe);
        }
        PowahAPI.MAGMATIC_FLUIDS.clear();
        PowahAPI.MAGMATIC_FLUIDS.putAll(this.general.magmatic_fluids);
        PowahAPI.COOLANT_FLUIDS.clear();
        PowahAPI.COOLANT_FLUIDS.putAll(this.general.coolant_fluids);
        PowahAPI.HEAT_SOURCES.clear();
        PowahAPI.HEAT_SOURCES.putAll(this.general.heat_blocks);
    }

    private static void validateObject(Object object) throws ConfigData.ValidationException, ReflectiveOperationException {
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object value = field.get(object);
            if (value instanceof Number) {
                Number number = (Number)value;
                DoubleRange doubleRange = field.getAnnotation(DoubleRange.class);
                if (doubleRange != null && (number.doubleValue() > doubleRange.max() || number.doubleValue() < doubleRange.min())) {
                    throw new ConfigData.ValidationException("Expected double entry %s = %f to be in range [%f, %f]".formatted(field.getName(), number.doubleValue(), doubleRange.min(), doubleRange.max()));
                }
                LongRange longRange = field.getAnnotation(LongRange.class);
                if (longRange == null || number.longValue() <= longRange.max() && number.longValue() >= longRange.min()) continue;
                throw new ConfigData.ValidationException("Expected long entry %s = %d to be in range [%d, %d]".formatted(field.getName(), number.longValue(), longRange.min(), longRange.max()));
            }
            if (value == null || !value.getClass().getPackageName().startsWith("owmii.powah.config")) continue;
            PowahConfig.validateObject(value);
        }
    }

    public static ConfigHolder<PowahConfig> register() {
        return AutoConfig.register(PowahConfig.class, (cfg, cfgClass) -> {
            Jankson.Builder janksonBuilder = Jankson.builder();
            janksonBuilder.registerDeserializer(String.class, ResourceLocation.class, (string, marshaller) -> {
                try {
                    return new ResourceLocation(string);
                }
                catch (ResourceLocationException exception) {
                    throw new DeserializationException("Not a valid resource location: " + string, (Throwable)exception);
                }
            });
            janksonBuilder.registerSerializer(ResourceLocation.class, (resLoc, marshaller) -> new JsonPrimitive((Object)resLoc.toString()));
            return new JanksonConfigSerializer(cfg, cfgClass, janksonBuilder.build());
        });
    }

    public static class WorldGen {
        @Comment(value="Enable this to disable worldgen entirely. If true, the other options have no effect.")
        public boolean disable_all = false;
        public int poor_uraninite_veins_per_chunk = 8;
        public int uraninite_veins_per_chunk = 6;
        public int dense_uraninite_veins_per_chunk = 3;
        public int dry_ice_veins_per_chunk = 9;
    }

    public static class General {
        @Comment(value="Enable this to get Player Aerial Pearl by right clicking a Zombie or Husk with a Aerial Pearl.")
        public boolean player_aerial_pearl = true;
        @Comment(value="Enable this to get Dimensional Binding card by right clicking an Enderman or Endermite with a Binding card.")
        public boolean dimensional_binding_card = true;
        @Comment(value="Enable this to get Lens Of Ender by right clicking an Enderman or Endermite with a Photoelectric Pane.")
        public boolean lens_of_ender = true;
        @Comment(value="List of fluids used in the Magmator.")
        public final Map<ResourceLocation, Integer> magmatic_fluids = Map.of(new ResourceLocation("minecraft:lava"), 10000);
        @Comment(value="List of coolant fluids used in the Reactor and the Thermo Generator.")
        public final Map<ResourceLocation, Integer> coolant_fluids = Map.of(new ResourceLocation("minecraft:water"), 1);
        @Comment(value="List of heat source blocks used under Thermo Generator.")
        public final Map<ResourceLocation, Integer> heat_blocks = Map.of(new ResourceLocation("minecraft:lava"), 1000, new ResourceLocation("minecraft:magma_block"), 800, new ResourceLocation("powah:blazing_crystal_block"), 2800);
        @Comment(value="Energy produced per fuel tick in the Furnator.")
        @LongRange(min=1L, max=0x7FFFFFFFL)
        public long energy_per_fuel_tick = DefaultEnergies.energyPerFuelTick();
        @LongRange(min=1L, max=32L)
        public int energizing_range = 4;
        @Comment(value="Multiplier to the required energy applied after an energizing recipe is read.\nUse this to adjust the cost of ALL energizing recipes.")
        @DoubleRange(min=0.001, max=1000.0)
        public double energizing_energy_ratio = DefaultEnergies.energizingRatio();
    }

    public static class Generators {
        public final GeneratorConfig furnators = new GeneratorConfig(DefaultEnergies.generatorCapacity(), DefaultEnergies.generatorTransfer(), DefaultEnergies.activeProduction());
        public final GeneratorConfig magmators = new GeneratorConfig(DefaultEnergies.generatorCapacity(), DefaultEnergies.generatorTransfer(), DefaultEnergies.activeProduction());
        public final GeneratorConfig reactors = new GeneratorConfig(DefaultEnergies.reactorCapacity(), DefaultEnergies.reactorTransfer(), DefaultEnergies.reactorProduction());
        public final GeneratorConfig solar_panels = new GeneratorConfig(DefaultEnergies.generatorCapacity(), DefaultEnergies.generatorTransfer(), DefaultEnergies.passiveProduction());
        public final GeneratorConfig thermo_generators = new GeneratorConfig(DefaultEnergies.generatorCapacity(), DefaultEnergies.generatorTransfer(), DefaultEnergies.passiveProduction());
    }

    public static class EnergyDevices {
        public final EnergyConfig batteries = new EnergyConfig(DefaultEnergies.batteryCapacity(), DefaultEnergies.batteryTransfer());
        public final CableConfig cables = new CableConfig(DefaultEnergies.cableTransfer());
        public final EnergyConfig dischargers = new EnergyConfig(DefaultEnergies.batteryCapacity(), DefaultEnergies.batteryTransfer());
        public final EnderConfig ender_cells = new EnderConfig(DefaultEnergies.batteryTransfer(), TieredChannelValues.getDefault());
        public final EnderConfig ender_gates = new EnderConfig(DefaultEnergies.cableTransfer(), TieredChannelValues.getDefault());
        public final EnergyConfig energy_cells = new EnergyConfig(DefaultEnergies.batteryCapacity(), DefaultEnergies.batteryTransfer());
        public final EnergyConfig energizing_rods = new EnergyConfig(DefaultEnergies.energizingCapacity(), DefaultEnergies.energizingTransfer());
        public final ChargingConfig hoppers = new ChargingConfig(DefaultEnergies.batteryCapacity(), DefaultEnergies.batteryTransfer(), DefaultEnergies.chargingTransfer());
        public final ChargingConfig player_transmitters = new ChargingConfig(DefaultEnergies.batteryCapacity(), DefaultEnergies.batteryTransfer(), DefaultEnergies.chargingTransfer());
    }
}

