/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableTile;

public class EnergyProxy {
    public final Map<Direction, EnergyProxy> proxies = new HashMap<Direction, EnergyProxy>();
    public final List<BlockPos> searchCache = new ArrayList<BlockPos>();
    public final List<BlockPos> cables = new ArrayList<BlockPos>();

    public void init() {
        for (Direction side : Direction.values()) {
            this.proxies.put(side, new EnergyProxy());
        }
    }

    public EnergyProxy read(CompoundTag compound) {
        ListTag listNBT = compound.m_128437_("cables_pos", 10);
        for (int j = 0; j < listNBT.size(); ++j) {
            CompoundTag nbt = listNBT.m_128728_(j);
            this.add(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("cable_pos")));
        }
        return this;
    }

    public CompoundTag write(CompoundTag compound) {
        ListTag listNBT = new ListTag();
        this.cables.forEach(pos -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("cable_pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            listNBT.add((Object)nbt);
        });
        compound.m_128365_("cables_pos", (Tag)listNBT);
        return compound;
    }

    public Set<CableTile> all(Level world) {
        HashSet<CableTile> cableTiles = new HashSet<CableTile>();
        Iterator<BlockPos> iterator = this.cables.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof CableTile) {
                cableTiles.add((CableTile)tileEntity);
                continue;
            }
            iterator.remove();
        }
        return cableTiles;
    }

    public List<BlockPos> search(Block block, CableTile tile, Direction side) {
        Level world = tile.m_58904_();
        if (world != null) {
            BlockPos pos = tile.m_58899_();
            this.searchCache.add(pos);
            for (Direction direction : Direction.values()) {
                BlockPos blockPos = pos.m_142300_(direction);
                BlockState state = world.m_8055_(blockPos);
                if (state.m_60734_() != block) continue;
                BlockEntity tile1 = world.m_7702_(blockPos);
                if (tile1 instanceof CableTile) {
                    this.add(blockPos);
                }
                CableBlock cableBlock = (CableBlock)state.m_60734_();
                cableBlock.searchCables((LevelAccessor)world, blockPos, tile, side);
            }
        }
        return this.searchCache;
    }

    public boolean remove(BlockPos pos) {
        return this.cables.remove(pos);
    }

    public boolean add(BlockPos pos) {
        if (!this.cables.contains(pos)) {
            return this.cables.add(pos);
        }
        return false;
    }

    public List<BlockPos> cables() {
        return this.cables;
    }
}

