/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableNet;
import owmii.powah.block.cable.EnergyProxy;
import owmii.powah.config.v2.types.CableConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;

public abstract class CableTile
extends AbstractEnergyStorage<CableConfig, CableBlock>
implements IInventoryHolder {
    public final Map<Direction, EnergyProxy> proxyMap = new HashMap<Direction, EnergyProxy>();
    public final Set<Direction> energySides = new HashSet<Direction>();
    @Nullable
    CableNet net = null;
    protected int startIndex = 0;

    public CableTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.CABLE.get(), pos, state, variant);
        for (Direction side : Direction.values()) {
            this.proxyMap.put(side, new EnergyProxy());
        }
    }

    public void m_6339_() {
        super.m_6339_();
        CableNet.addCable(this);
    }

    public void m_7651_() {
        super.m_7651_();
        CableNet.removeCable(this);
    }

    public boolean isActive() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_7726_().m_143239_(ChunkPos.m_151388_((BlockPos)this.m_58899_()));
        }
        return false;
    }

    protected Iterable<CableTile> getCables() {
        if (this.net == null) {
            CableNet.calculateNetwork(this);
        }
        this.startIndex %= this.net.cableList.size();
        return Iterables.concat(this.net.cableList.subList(this.startIndex, this.net.cableList.size()), this.net.cableList.subList(0, this.startIndex));
    }

    @Override
    public CompoundTag saveServerOnly(CompoundTag compound) {
        ListTag list = new ListTag();
        this.proxyMap.forEach((direction, linkedCables) -> {
            CompoundTag nbt = new CompoundTag();
            linkedCables.write(nbt);
            nbt.m_128405_("direction", direction.ordinal());
            list.add((Object)nbt);
        });
        compound.m_128365_("linked_cables", (Tag)list);
        return super.saveServerOnly(compound);
    }

    @Override
    public void loadServerOnly(CompoundTag compound) {
        super.loadServerOnly(compound);
        ListTag list = compound.m_128437_("linked_cables", 10);
        IntStream.range(0, list.size()).mapToObj(arg_0 -> ((ListTag)list).m_128728_(arg_0)).forEach(nbt -> {
            Direction direction = Direction.values()[nbt.m_128451_("direction")];
            this.proxyMap.put(direction, new EnergyProxy().read((CompoundTag)nbt));
        });
    }

    @Override
    public void readSync(CompoundTag compound) {
        super.readSync(compound);
        ListTag list1 = compound.m_128437_("energy_directions", 10);
        IntStream.range(0, list1.size()).mapToObj(arg_0 -> ((ListTag)list1).m_128728_(arg_0)).map(nbt -> Direction.values()[nbt.m_128451_("energy_direction")]).forEach(this.energySides::add);
    }

    @Override
    public CompoundTag writeSync(CompoundTag compound) {
        ListTag list1 = new ListTag();
        this.energySides.forEach(direction -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("energy_direction", direction.ordinal());
            list1.add((Object)nbt);
        });
        compound.m_128365_("energy_directions", (Tag)list1);
        return super.writeSync(compound);
    }

    public void search(Block block, Direction side) {
        this.proxyMap.get(side).search(block, this, side).clear();
    }

    @Override
    protected long getEnergyCapacity() {
        return 0L;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1));
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean keepStorable() {
        return false;
    }
}

