/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.renderer;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftVersion;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BiomeColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BlockColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RegionShader;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.ExposeMethodParam;

public class RenderSettings {
    public int minX = Integer.MIN_VALUE;
    public int maxX = Integer.MAX_VALUE;
    public int minY = Integer.MIN_VALUE;
    public int maxY = Integer.MAX_VALUE;
    public int minZ = Integer.MIN_VALUE;
    public int maxZ = Integer.MAX_VALUE;
    public Map<MinecraftVersion, BlockColorMap> blockColors;
    public BiomeColorMap biomeColors;
    public RegionShader regionShader = new RegionShader.ReliefShader();

    public RenderSettings() {
        this.loadDefaultColors();
    }

    public RenderSettings(int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Map<MinecraftVersion, BlockColorMap> blockColors, BiomeColorMap biomeColors, RegionShader regionShader) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.blockColors = blockColors;
        this.biomeColors = biomeColors;
        this.regionShader = regionShader;
    }

    public void loadDefaultColors() {
        this.blockColors = BlockColorMap.InternalColorMap.DEFAULT.getColorMap();
        this.biomeColors = BiomeColorMap.loadDefault();
    }

    @ExposeMethodParam(value="block colors")
    public void loadBlockColors(String name) {
        this.blockColors = BlockColorMap.InternalColorMap.valueOf(name).getColorMap();
    }

    @ExposeMethodParam(value="shader")
    public void loadShader(RegionShader.DefaultShader shader) {
        this.regionShader = shader.getShader();
    }

    public int hashCode() {
        return Objects.hash(this.biomeColors, this.blockColors.entrySet().stream().collect(Collectors.toMap(e -> ((MinecraftVersion)((Object)((Object)e.getKey()))).ordinal(), Map.Entry::getValue)), this.maxX, this.maxY, this.maxZ, this.minX, this.minY, this.minZ, this.regionShader);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenderSettings other = (RenderSettings)obj;
        return Objects.equals(this.biomeColors, other.biomeColors) && Objects.equals(this.blockColors, other.blockColors) && this.maxX == other.maxX && this.maxY == other.maxY && this.maxZ == other.maxZ && this.minX == other.minX && this.minY == other.minY && this.minZ == other.minZ && Objects.equals(this.regionShader, other.regionShader);
    }
}

