/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.color;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.Color;

public class BiomeColorMap {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Color.class, Color.ADAPTER).setPrettyPrinting().create();
    public static final BiomeColor MISSING = new BiomeColor(Color.MISSING, Color.MISSING, Color.MISSING, Color.MISSING);
    protected Map<String, BiomeColor> biomeColors;

    private BiomeColorMap() {
    }

    public BiomeColor getBiomeColor(String biome) {
        return this.biomeColors.getOrDefault(biome, MISSING);
    }

    public BiomeColorMap(Map<String, BiomeColor> biomeColors) {
        this.biomeColors = Objects.requireNonNull(biomeColors);
    }

    public int hashCode() {
        return Objects.hash(this.biomeColors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BiomeColorMap other = (BiomeColorMap)obj;
        return Objects.equals(this.biomeColors, other.biomeColors);
    }

    public static BiomeColorMap load(Reader reader) {
        return (BiomeColorMap)GSON.fromJson(reader, BiomeColorMap.class);
    }

    public static BiomeColorMap loadDefault() {
        return BiomeColorMap.load(new InputStreamReader(BiomeColorMap.class.getResourceAsStream("/biome-colors.json")));
    }

    public static class BiomeColor {
        public Color waterColor;
        public Color grassColor;
        public Color foliageColor;
        public Color biomeColor;

        public BiomeColor() {
        }

        public BiomeColor(Color waterColor, Color grassColor, Color foliageColor, Color biomeColor) {
            this.waterColor = waterColor;
            this.grassColor = grassColor;
            this.foliageColor = foliageColor;
            this.biomeColor = biomeColor;
        }

        public int hashCode() {
            return Objects.hash(this.biomeColor, this.foliageColor, this.grassColor, this.waterColor);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BiomeColor other = (BiomeColor)obj;
            return Objects.equals(this.biomeColor, other.biomeColor) && Objects.equals(this.foliageColor, other.foliageColor) && Objects.equals(this.grassColor, other.grassColor) && Objects.equals(this.waterColor, other.waterColor);
        }
    }
}

