/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.block.blockentity;

import com.github.atomicblom.weirdinggadget.Settings;
import com.github.atomicblom.weirdinggadget.TicketUtils;
import com.github.atomicblom.weirdinggadget.WeirdingGadgetMod;
import com.github.atomicblom.weirdinggadget.block.WeirdingGadgetBlock;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetChunkManager;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetTicket;
import com.github.atomicblom.weirdinggadget.library.BlockEntityTypeLibrary;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WeirdingGadgetBlockEntity
extends BlockEntity {
    private static final int ACTIVE_STATE_CHANGED = 1;
    private final List<WeirdingGadgetTicket> tickets = Lists.newArrayList();
    private final List<WeakReference<Player>> trackedPlayers = new LinkedList<WeakReference<Player>>();
    private long expireTime = -1L;
    private boolean isActive;

    public WeirdingGadgetBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityTypeLibrary.weirding_gadget, pos, state);
    }

    public void addTicket(WeirdingGadgetTicket ticket) {
        assert (this.f_58857_ != null);
        String playerName = ticket.getPlayerName();
        Iterator<WeirdingGadgetTicket> iterator = this.tickets.iterator();
        while (iterator.hasNext()) {
            WeirdingGadgetTicket next = iterator.next();
            if (!next.getPlayerName().equals(playerName)) continue;
            WeirdingGadgetChunkManager.releaseTicket(this.f_58857_, next);
            iterator.remove();
        }
        this.tickets.add(ticket);
        this.m_58900_().m_60677_(this.f_58857_, this.f_58858_, 1, 1);
        this.setExpireTime(-1L);
        WeirdingGadgetMod.LOGGER.info("Waking up Chunk Loader at {} because {} placed/interacted with it", (Object)this.f_58858_, (Object)playerName);
    }

    public void addTrackedPlayer(@Nullable Player player) {
        for (WeakReference<Player> trackedPlayerReference : this.trackedPlayers) {
            Player trackedPlayer = (Player)trackedPlayerReference.get();
            if (trackedPlayer == null || player == null || player.m_7755_() != trackedPlayer.m_7755_()) continue;
            return;
        }
        this.trackedPlayers.add(new WeakReference<Player>(player));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WeirdingGadgetBlockEntity entity) {
        entity.tick();
    }

    private void tick() {
        if (this.f_58857_ == null) {
            WeirdingGadgetMod.LOGGER.error("Chunk Loader at {} in an unknown dimension didn't have a level attached to it!?", (Object)this.f_58858_);
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.tickets.isEmpty()) {
            return;
        }
        ResourceLocation dimensionName = this.f_58857_.m_46472_().getRegistryName();
        MinecraftServer server = this.f_58857_.m_142572_();
        if (server == null) {
            WeirdingGadgetMod.LOGGER.error("Chunk Loader at {} in {} was attempting to update, however the server returned null!?", (Object)this.f_58858_, (Object)dimensionName);
            return;
        }
        BlockState blockState = this.m_58900_();
        long gameTime = this.f_58857_.m_46467_();
        if ((gameTime & 0x1FL) != 31L) {
            return;
        }
        boolean noTrackedPlayers = true;
        Iterator<WeakReference<Player>> trackedPlayerIterator = this.trackedPlayers.iterator();
        while (trackedPlayerIterator.hasNext()) {
            WeakReference<Player> playerWeakReference = trackedPlayerIterator.next();
            Player player = (Player)playerWeakReference.get();
            if (player == null) continue;
            if ((player = TicketUtils.getOnlinePlayerByName(server, player.m_7755_().getString())) == null) {
                playerWeakReference.clear();
                trackedPlayerIterator.remove();
                continue;
            }
            noTrackedPlayers = false;
        }
        boolean ticketNeedsExpiring = noTrackedPlayers;
        for (WeirdingGadgetTicket ticket : this.tickets) {
            ServerPlayer PlayerByName = TicketUtils.getOnlinePlayerByName(server, ticket.getPlayerName());
            if (PlayerByName == null) continue;
            this.setExpireTime(-1L);
            this.trackedPlayers.add(new WeakReference<ServerPlayer>(PlayerByName));
            if (!this.isActive || noTrackedPlayers) {
                WeirdingGadgetMod.LOGGER.info("Chunk Loader at {} in {} is revived because {} returned", (Object)this.f_58858_, (Object)dimensionName, (Object)PlayerByName.m_7755_().getString());
                blockState.m_60677_(this.f_58857_, this.f_58858_, 1, 1);
            }
            ticketNeedsExpiring = false;
        }
        if (ticketNeedsExpiring && this.expireTime == -1L) {
            int timeout = (Integer)Settings.SERVER.hoursBeforeDeactivation.get() * WeirdingGadgetMod.MULTIPLIER;
            this.setExpireTime(gameTime + (long)timeout);
            WeirdingGadgetMod.LOGGER.info("All players registered to this gadget at {} in {} have gone offline. Ticket is scheduled to expire at level time {}", (Object)this.f_58858_, (Object)dimensionName, (Object)this.expireTime);
        }
        if (this.expireTime != -1L && gameTime >= this.expireTime) {
            WeirdingGadgetMod.LOGGER.info("Ticket for Weirding Gadget at {} in {} has expired.", (Object)this.f_58858_, (Object)dimensionName);
            for (WeirdingGadgetTicket ticket : this.tickets) {
                WeirdingGadgetChunkManager.releaseTicket(this.f_58857_, ticket);
            }
            this.tickets.clear();
            blockState.m_60677_(this.f_58857_, this.f_58858_, 1, 0);
        }
    }

    private void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
        this.getTileData().m_128356_("expireTime", expireTime);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag tileData = this.getTileData();
        if (nbt.m_128441_("expireTime")) {
            tileData.m_128356_("expireTime", nbt.m_128441_("expireTime") ? nbt.m_128454_("expireTime") : -1L);
        }
        this.expireTime = tileData.m_128441_("expireTime") ? tileData.m_128454_("expireTime") : -1L;
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            boolean bl = this.isActive = type == 1;
            assert (this.f_58857_ != null);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)WeirdingGadgetBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            WeirdingGadgetMod.LOGGER.debug("Active state of chunk loader at {} is now {}", (Object)this.f_58858_, (Object)this.isActive);
            return true;
        }
        return false;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        updateTag.m_128379_("isActive", this.isActive);
        return updateTag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.isActive = tag.m_128471_("isActive");
        super.handleUpdateTag(tag);
    }

    public boolean isExpired() {
        return this.tickets.isEmpty();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean hasTicket(Player player) {
        for (WeirdingGadgetTicket ticket : this.tickets) {
            if (!ticket.getPlayerName().equals(player.m_7755_().getString())) continue;
            return true;
        }
        return false;
    }

    public void expireAllTickets() {
        for (WeirdingGadgetTicket ticket : this.tickets) {
            WeirdingGadgetChunkManager.releaseTicket(this.f_58857_, ticket);
        }
        this.tickets.clear();
        this.trackedPlayers.clear();
    }
}

