/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.block;

import com.github.atomicblom.weirdinggadget.Settings;
import com.github.atomicblom.weirdinggadget.TicketUtils;
import com.github.atomicblom.weirdinggadget.WeirdingGadgetMod;
import com.github.atomicblom.weirdinggadget.block.RenderType;
import com.github.atomicblom.weirdinggadget.block.blockentity.WeirdingGadgetBlockEntity;
import com.github.atomicblom.weirdinggadget.chunkloading.Type;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetChunkManager;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetTicket;
import com.github.atomicblom.weirdinggadget.library.BlockEntityTypeLibrary;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WeirdingGadgetBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final EnumProperty<RenderType> RENDER = EnumProperty.m_61587_((String)"render", RenderType.class);
    final VoxelShape AABB = Shapes.m_166049_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);

    public WeirdingGadgetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_(RENDER, (Comparable)((Object)RenderType.STATIC)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return WeirdingGadgetBlock.m_152132_(blockEntityType, BlockEntityTypeLibrary.weirding_gadget, WeirdingGadgetBlockEntity::tick);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE, RENDER});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)new TranslatableComponent("block.weirdinggadget.weirding_gadget.tooltip.title"));
        tooltip.add((Component)new TranslatableComponent("block.weirdinggadget.weirding_gadget.tooltip.description").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TranslatableComponent("block.weirdinggadget.weirding_gadget.tooltip.hat").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TranslatableComponent("block.weirdinggadget.weirding_gadget.tooltip.weird").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!(placer instanceof Player)) {
            return;
        }
        WeirdingGadgetBlock.activateChunkLoader(level, pos, (Player)placer);
    }

    private static void activateChunkLoader(Level level, BlockPos pos, Player placer) {
        if (level.f_46443_) {
            return;
        }
        if (level == null) {
            WeirdingGadgetMod.LOGGER.error("While attempting to active a Weirding Gadget, Somehow, the level was null?");
            return;
        }
        if (placer == null) {
            WeirdingGadgetMod.LOGGER.error("While attempting to active a Weirding Gadget, Somehow, the player was null?");
            return;
        }
        if (placer.m_7755_() == null) {
            WeirdingGadgetMod.LOGGER.error("While attempting to active a Weirding Gadget, Somehow, the player's NAME was null?");
            return;
        }
        WeirdingGadgetTicket ticket = WeirdingGadgetChunkManager.requestPlayerTicket(WeirdingGadgetMod.instance, placer.m_7755_().getString(), level, Type.NORMAL);
        if (ticket == null) {
            return;
        }
        CompoundTag modData = ticket.getModData();
        modData.m_128365_("blockPosition", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        modData.m_128405_("size", ((Integer)Settings.SERVER.chunkLoaderWidth.get()).intValue());
        TicketUtils.activateTicket(level, ticket);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        WeirdingGadgetBlockEntity blockEntity = (WeirdingGadgetBlockEntity)level.m_7702_(pos);
        if (blockEntity == null) {
            return InteractionResult.FAIL;
        }
        if (blockEntity.isExpired() || !blockEntity.hasTicket(player)) {
            WeirdingGadgetBlock.activateChunkLoader(level, pos, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return BlockEntityTypeLibrary.weirding_gadget.m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Deprecated
    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 5;
    }

    @Deprecated
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() == this) {
            return;
        }
        WeirdingGadgetBlockEntity blockEntity = (WeirdingGadgetBlockEntity)level.m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        blockEntity.expireAllTickets();
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.AABB;
    }
}

