/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget;

import com.github.atomicblom.weirdinggadget.ChunkManagerCallback;
import com.github.atomicblom.weirdinggadget.Reference;
import com.github.atomicblom.weirdinggadget.Settings;
import com.github.atomicblom.weirdinggadget.chunkloading.WeirdingGadgetTicket;
import com.github.atomicblom.weirdinggadget.client.WeirdingGadgetItemModel;
import com.github.atomicblom.weirdinggadget.registration.CapabilityWeirdingGadgetTicketList;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="weirdinggadget")
public class WeirdingGadgetMod {
    public static final String MOD_ID = "weirdinggadget";
    public static int MULTIPLIER = 20;
    public static final Logger LOGGER = LogManager.getLogger();
    public static WeirdingGadgetMod instance = null;
    public static boolean IS_CI_BUILD = false;

    public WeirdingGadgetMod() {
        if (Boolean.valueOf("true").booleanValue()) {
            IS_CI_BUILD = true;
            MULTIPLIER = 72000;
        }
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::modelRegistryEvent);
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, this::attachLevelCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::levelLoaded);
        ModLoadingContext modContext = ModLoadingContext.get();
        modContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Settings.ServerSpec, "WeirdingGadget.toml");
        modContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Settings.LimitSpec, "WeirdingGadgetLimits.toml");
    }

    private void modelRegistryEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Reference.ItemLoader, (IModelLoader)new WeirdingGadgetItemModel.Loader());
    }

    public void levelLoaded(WorldEvent.Load levelLoadEvent) {
        LevelAccessor level = levelLoadEvent.getWorld();
        if (level instanceof ServerLevelAccessor) {
            ServerLevel serverLevel = ((ServerLevelAccessor)level).m_6018_();
            serverLevel.getCapability(CapabilityWeirdingGadgetTicketList.TICKET_LIST_DATA).ifPresent(ticketList -> {
                Map<String, List<WeirdingGadgetTicket>> playerTickets = ticketList.getAllTickets().stream().collect(Collectors.groupingBy(WeirdingGadgetTicket::getPlayerName));
                ListMultimap<String, WeirdingGadgetTicket> usedTickets = ChunkManagerCallback.playerTicketsLoaded(playerTickets, (Level)serverLevel);
                Set knownTickets = ticketList.getAllTickets().stream().map(WeirdingGadgetTicket::getId).collect(Collectors.toSet());
                for (WeirdingGadgetTicket weirdingGadgetTicket : new ArrayList(usedTickets.values())) {
                    knownTickets.remove(weirdingGadgetTicket.getId());
                }
                for (UUID removedTicket : knownTickets) {
                    ticketList.removeTicket(removedTicket);
                }
                ChunkManagerCallback.ticketsLoaded(ticketList.getAllTickets(), (Level)serverLevel);
            });
        }
    }

    public void attachLevelCapabilities(AttachCapabilitiesEvent<Level> levelCapabilities) {
        levelCapabilities.addCapability(Reference.Capability.weirding_gadget, (ICapabilityProvider)new CapabilityWeirdingGadgetTicketList.WeirdingGadgetTicketListProvider());
    }
}

