/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Settings {
    static final ForgeConfigSpec ServerSpec;
    public static final Server SERVER;
    static final ForgeConfigSpec LimitSpec;
    public static final ChunkLoaderLimits CHUNK_LOADER_LIMITS;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        ServerSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        Pair limitSpecPair = new ForgeConfigSpec.Builder().configure(ChunkLoaderLimits::new);
        LimitSpec = (ForgeConfigSpec)limitSpecPair.getRight();
        CHUNK_LOADER_LIMITS = (ChunkLoaderLimits)limitSpecPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue hoursBeforeDeactivation;
        public final ForgeConfigSpec.IntValue chunkLoaderWidth;
        public final ForgeConfigSpec.BooleanValue emergencyMode;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.hoursBeforeDeactivation = builder.comment("The number of hours the player will be offline before deactivating (default 2 days)").translation("weirdinggadget.configgui.hoursBeforeDeactivation").worldRestart().defineInRange("hoursBeforeDeactivation", 48, 1, 8760);
            this.chunkLoaderWidth = builder.comment("Width/length of chunks to be loaded, it is recommend this is an odd number (max 25)").translation("weirdinggadget.configgui.chunkLoaderWidth").worldRestart().defineInRange("chunkLoaderWidth", 3, 1, 25);
            this.emergencyMode = builder.comment("Disables Chunk loading, use if there is a crash happening in a chunk loaded area").translation("weirdinggadget.configgui.emergencyMode").worldRestart().define("emergencymode", false);
            builder.pop();
        }
    }

    public static class ChunkLoaderLimits {
        public final ForgeConfigSpec.IntValue maximumModTickets;
        public final ForgeConfigSpec.IntValue maximumPlayerTickets;
        public final ForgeConfigSpec.IntValue maximumChunksPerTicket;

        ChunkLoaderLimits(ForgeConfigSpec.Builder builder) {
            builder.comment("Limits for chunk loading").push("chunkLoadingLimits");
            this.maximumModTickets = builder.comment("Maximum ticket count for the mod. Zero disables chunkloading capabilities.").translation("weirdinggadget.configui.maximumModTickets").worldRestart().defineInRange("maximumModTickets", 200, 0, Integer.MAX_VALUE);
            this.maximumPlayerTickets = builder.comment("The number of tickets a player can be assigned instead of a mod. This is shared across all mods.").translation("weirdinggadget.configui.maximumPlayerTickets").worldRestart().defineInRange("maximumPlayerTickets", 500, 0, Integer.MAX_VALUE);
            this.maximumChunksPerTicket = builder.comment(new String[0]).translation("weirdinggadget.configui.maximumChunksPerTicket").worldRestart().defineInRange("maximumChunksPerTicket", 25, 0, 225);
        }
    }
}

