/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.library.ninepatch;

import com.blamejared.jeitweaker.library.ninepatch.InvalidNinePatchDataException;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchReader;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchRegion;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

final class NinePatchImage {
    private final ResourceLocation atlas;
    private final int u;
    private final int v;
    private final int width;
    private final int height;
    private final NinePatchRegion horizontal;
    private final NinePatchRegion vertical;

    private NinePatchImage(ResourceLocation atlas, int u, int v, int width, int height, NinePatchRegion horizontal, NinePatchRegion vertical) {
        this.atlas = atlas;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.horizontal = NinePatchImage.convertToImageSpace(horizontal);
        this.vertical = NinePatchImage.convertToImageSpace(vertical);
    }

    public static NinePatchImage from(ResourceLocation atlas, int u, int v, int width, int height, int texWidth, int texHeight) throws InvalidNinePatchDataException {
        NinePatchImage ninePatchImage;
        block8: {
            Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(atlas);
            try {
                NativeImage image = NativeImage.m_85058_((InputStream)resource.m_6679_());
                ninePatchImage = NinePatchReader.read((horizontal, vertical) -> new NinePatchImage(atlas, u + 1, v + 1, width - 2, height - 2, horizontal, vertical), image, u, v, width, height, texWidth, texHeight);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidNinePatchDataException(e);
                }
            }
            resource.close();
        }
        return ninePatchImage;
    }

    private static NinePatchRegion convertToImageSpace(NinePatchRegion region) {
        try {
            return region == null ? null : NinePatchRegion.of(region.behavior(), region.beginning() - 1, region.size());
        }
        catch (InvalidNinePatchDataException e) {
            throw new RuntimeException("Impossible", e);
        }
    }

    public ResourceLocation atlas() {
        return this.atlas;
    }

    public int u() {
        return this.u;
    }

    public int v() {
        return this.v;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public NinePatchRegion horizontal() {
        return this.horizontal;
    }

    public NinePatchRegion vertical() {
        return this.vertical;
    }
}

