/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.jei;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.jeitweaker.api.BuiltinIngredientTypes;
import com.blamejared.jeitweaker.api.IngredientType;
import com.blamejared.jeitweaker.implementation.CoordinateFixerManager;
import com.blamejared.jeitweaker.implementation.state.StateManager;
import com.blamejared.jeitweaker.jei.JeiTweakerCategory;
import com.blamejared.jeitweaker.jei.JeiTweakerRecipe;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.JeiRecipe;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public final class JeiTweakerPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("jeitweaker", "main");

    public JeiTweakerPlugin() {
        System.out.println("Initialized plugin " + ID);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        this.registerSubtypesFor((IngredientType)BuiltinIngredientTypes.ITEM.get(), (Predicate)arg_0 -> ((ISubtypeRegistration)registration).hasSubtypeInterpreter(arg_0), (Function)ItemStack::m_41720_, (IntFunction<R[]>)((IntFunction<Item[]>)(Item[]::new)), (Consumer<R[]>)((Consumer<Item[]>)arg_0 -> ((ISubtypeRegistration)registration).useNbtForSubtypes(arg_0)));
    }

    public void registerFluidSubtypes(ISubtypeRegistration registration) {
        this.registerSubtypesFor((IngredientType)BuiltinIngredientTypes.FLUID.get(), (Predicate)arg_0 -> ((ISubtypeRegistration)registration).hasSubtypeInterpreter(arg_0), (Function)FluidStack::getFluid, (IntFunction<R[]>)((IntFunction<Fluid[]>)(Fluid[]::new)), (Consumer<R[]>)((Consumer<Fluid[]>)arg_0 -> ((ISubtypeRegistration)registration).useNbtForSubtypes(arg_0)));
    }

    public void registerIngredients(IModIngredientRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers helpers = registration.getJeiHelpers();
        IRecipeCategory[] categories = (IRecipeCategory[])StateManager.INSTANCE.actionsState().getCustomCategories().map(it -> new JeiTweakerCategory((JeiCategory)it, helpers)).toArray(IRecipeCategory[]::new);
        if (categories.length == 0) {
            return;
        }
        registration.addRecipeCategories(categories);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
        StateManager.INSTANCE.registrationState().ingredientTypes().forEach(type -> this.registerDescriptionsFor(registration, (IngredientType)type));
        StateManager.INSTANCE.actionsState().getCustomCategories().forEach(category -> this.registerRecipeFor(registration, (JeiCategory)category));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        StateManager.INSTANCE.actionsState().getCustomCategories().forEach(category -> this.registerCatalystsFor(registration, (JeiCategory)category));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    public void onRuntimeAvailable(IJeiRuntime iJeiRuntime) {
        IIngredientManager ingredientManager = iJeiRuntime.getIngredientManager();
        IRecipeManager recipeManager = iJeiRuntime.getRecipeManager();
        StateManager.INSTANCE.registrationState().ingredientTypes().forEach(type -> {
            this.hideIngredientsFor(ingredientManager, (IngredientType)type);
            this.addItemsFor(ingredientManager, (IngredientType)type);
        });
        this.hideRecipeCategories(recipeManager);
        this.hideRecipes(recipeManager);
        this.storeCurrentCategories(recipeManager);
    }

    private <T, U, R> void registerSubtypesFor(IngredientType<T, U> type, Predicate<U> hasSubtype, Function<U, R> flatter, IntFunction<R[]> arrayCreator, Consumer<R[]> consumer) {
        A[] ingredientsWithoutSubtypes = StateManager.INSTANCE.actionsState().getCustomIngredientsForType(type).stream().map(type::toJeiType).filter(hasSubtype.negate()).map(flatter).distinct().toArray(arrayCreator);
        if (ingredientsWithoutSubtypes.length == 0) {
            return;
        }
        consumer.accept(ingredientsWithoutSubtypes);
    }

    private <T, U> void registerDescriptionsFor(IRecipeRegistration registration, IngredientType<T, U> type) {
        StateManager.INSTANCE.actionsState().onDescriptionsFor(type, (ingredient, description) -> registration.addIngredientInfo(type.toJeiType(ingredient), type.toJeiIngredientType(registration.getIngredientManager()), description));
    }

    private void registerRecipeFor(IRecipeRegistration registration, JeiCategory category) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        CoordinateFixerManager fixerManager = CoordinateFixerManager.of(ingredientManager);
        registration.addRecipes((Collection)category.getTargetRecipes().stream().map(it -> new JeiTweakerRecipe((JeiRecipe)it, ingredientManager, fixerManager)).collect(Collectors.toList()), category.id());
    }

    private void registerCatalystsFor(IRecipeCatalystRegistration registration, JeiCategory category) {
        ResourceLocation id = category.id();
        Arrays.stream(category.catalysts()).map(RawJeiIngredient::cast).forEach(ing -> registration.addRecipeCatalyst(ing.getType().toJeiIngredientType(registration.getIngredientManager()), ing.getType().toJeiType(ing.getWrapped()), new ResourceLocation[]{id}));
    }

    private <T, U> void hideIngredientsFor(IIngredientManager manager, IngredientType<T, U> type) {
        Collection hiddenIngredients = StateManager.INSTANCE.actionsState().getHiddenIngredientsForType(type);
        IIngredientType<U> jeiType = type.toJeiIngredientType(manager);
        List removals = manager.getAllIngredients(jeiType).stream().map(type::toJeiTweakerType).filter(ingredient -> hiddenIngredients.stream().anyMatch(it -> type.match(it, ingredient))).map(type::toJeiType).collect(Collectors.toList());
        if (removals.isEmpty()) {
            return;
        }
        manager.removeIngredientsAtRuntime(jeiType, removals);
    }

    private <T, U> void addItemsFor(IIngredientManager manager, IngredientType<T, U> type) {
        IIngredientType<U> jeiType = type.toJeiIngredientType(manager);
        Collection additions = StateManager.INSTANCE.actionsState().getCustomIngredientsForType(type).stream().map(type::toJeiType).collect(Collectors.toList());
        if (additions.isEmpty()) {
            return;
        }
        manager.addIngredientsAtRuntime(jeiType, additions);
    }

    private void hideRecipeCategories(IRecipeManager manager) {
        Set<ResourceLocation> availableCategories = this.getJeiCategoriesFrom(manager, true);
        Set<ResourceLocation> targetCategories = StateManager.INSTANCE.actionsState().getCategoriesToHide();
        Set hiddenCategories = targetCategories.stream().filter(availableCategories::contains).peek(arg_0 -> ((IRecipeManager)manager).hideRecipeCategory(arg_0)).collect(Collectors.toSet());
        Sets.difference(targetCategories, hiddenCategories).forEach(invalid -> CraftTweakerAPI.LOGGER.error("[JEITweaker] Unable to remove JEI category with id '{}' as it does not exist!", invalid));
    }

    private void hideRecipes(IRecipeManager manager) {
        StateManager.INSTANCE.actionsState().onHiddenRecipes((categoryId, recipeId) -> {
            Optional recipe = CraftTweakerAPI.getAccessibleElementsProvider().recipeManager().m_44043_(recipeId);
            if (recipe.isPresent()) {
                manager.hideRecipe((Object)((Recipe)recipe.get()), categoryId);
            } else {
                CraftTweakerAPI.LOGGER.error("[JEITweaker] Cannot hide recipe with id '{}' in category '{}' as it does not exist!", recipeId, categoryId);
            }
        });
    }

    private void storeCurrentCategories(IRecipeManager manager) {
        Set<ResourceLocation> allCategories = this.getJeiCategoriesFrom(manager, true);
        Set<ResourceLocation> nonHiddenCategories = this.getJeiCategoriesFrom(manager, false);
        StateManager.INSTANCE.jeiGlobalState().replaceJeiCategoriesWith(allCategories, nonHiddenCategories);
    }

    private Set<ResourceLocation> getJeiCategoriesFrom(IRecipeManager manager, boolean hidden) {
        return manager.createRecipeCategoryLookup().includeHidden().get().map(IRecipeCategory::getRecipeType).map(RecipeType::getUid).collect(Collectors.toSet());
    }
}

