/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.xplat;

import java.util.List;
import vazkii.botania.api.BotaniaAPI;
import vazkii.patchouli.api.PatchouliAPI;

public class BotaniaConfig {
    private static ConfigAccess config = null;
    private static ClientConfigAccess clientConfig = null;

    public static ConfigAccess common() {
        return config;
    }

    public static ClientConfigAccess client() {
        return clientConfig;
    }

    public static void setCommon(ConfigAccess access) {
        if (config != null) {
            BotaniaAPI.LOGGER.warn("ConfigAccess was replaced! Old {} New {}", (Object)config.getClass().getName(), (Object)access.getClass().getName());
        }
        config = access;
    }

    public static void setClient(ClientConfigAccess access) {
        if (clientConfig != null) {
            BotaniaAPI.LOGGER.warn("ClientConfigAccess was replaced! Old {} New {}", (Object)clientConfig.getClass().getName(), (Object)access.getClass().getName());
        }
        clientConfig = access;
    }

    public static void resetPatchouliFlags() {
        PatchouliAPI.get().setConfigFlag("botania:relics", BotaniaConfig.common().relicsEnabled());
        PatchouliAPI.get().setConfigFlag("botania:enchanter", BotaniaConfig.common().enchanterEnabled());
        PatchouliAPI.get().setConfigFlag("botania:ender_hand_pickpocket", BotaniaConfig.common().enderPickpocketEnabled());
    }

    public static interface ConfigAccess {
        public boolean blockBreakParticles();

        public boolean blockBreakParticlesTool();

        public boolean chargingAnimationEnabled();

        public boolean silentSpreaders();

        public int spreaderTraceTime();

        public boolean enderPickpocketEnabled();

        public boolean enchanterEnabled();

        public boolean relicsEnabled();

        public boolean invertMagnetRing();

        public int harvestLevelWeight();

        public int harvestLevelBore();

        public boolean gogSpawnWithLexicon();

        public int gogIslandScaleMultiplier();

        public boolean worldgenEnabled();

        public List<String> rannuncarpusItemBlacklist();

        public List<String> rannuncarpusModBlacklist();
    }

    public static interface ClientConfigAccess {
        public boolean lexiconRotatingItems();

        public boolean subtlePowerSystem();

        public boolean staticWandBeam();

        public boolean boundBlockWireframe();

        public boolean lexicon3dModel();

        public double flowerParticleFrequency();

        public boolean elfPortalParticlesEnabled();

        public boolean renderAccessories();

        public boolean enableSeasonalFeatures();

        public boolean enableFancySkybox();

        public boolean enableFancySkyboxInNormalWorlds();

        public int manaBarHeight();

        public boolean staticFloaters();

        public boolean debugInfo();

        public boolean referencesEnabled();

        public boolean splashesEnabled();
    }
}

