/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.proxy.IProxy;

public class ItemBaubleCosmetic
extends ItemBauble
implements ICosmeticBauble {
    private final Variant variant;

    public ItemBaubleCosmetic(Variant variant, Item.Properties props) {
        super(props);
        this.variant = variant;
        IProxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        if (this.variant == Variant.THINKING_HAND) {
            tooltip.add((Component)new TranslatableComponent("botaniamisc.cosmeticThinking").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        } else {
            tooltip.add((Component)new TranslatableComponent("botaniamisc.cosmeticBauble").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
        super.m_7373_(stack, world, tooltip, flags);
    }

    public static enum Variant {
        BLACK_BOWTIE,
        BLACK_TIE,
        RED_GLASSES(true),
        PUFFY_SCARF,
        ENGINEER_GOGGLES(true),
        EYEPATCH(true),
        WICKED_EYEPATCH(true),
        RED_RIBBONS(true),
        PINK_FLOWER_BUD(true),
        POLKA_DOTTED_BOWS(true),
        BLUE_BUTTERFLY(true),
        CAT_EARS(true),
        WITCH_PIN,
        DEVIL_TAIL,
        KAMUI_EYE,
        GOOGLY_EYES(true),
        FOUR_LEAF_CLOVER,
        CLOCK_EYE(true),
        UNICORN_HORN(true),
        DEVIL_HORNS(true),
        HYPER_PLUS(true),
        BOTANIST_EMBLEM,
        ANCIENT_MASK(true),
        EERIE_MASK(true),
        ALIEN_ANTENNA(true),
        ANAGLYPH_GLASSES(true),
        ORANGE_SHADES(true),
        GROUCHO_GLASSES(true),
        THICK_EYEBROWS(true),
        LUSITANIC_SHIELD,
        TINY_POTATO_MASK(true),
        QUESTGIVER_MARK(true),
        THINKING_HAND(true);

        private final boolean isHead;

        private Variant(boolean isHead) {
            this.isHead = isHead;
        }

        private Variant() {
            this(false);
        }
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            Variant variant = ((ItemBaubleCosmetic)stack.m_41720_()).variant;
            if (variant.isHead) {
                bipedModel.f_102808_.m_104299_(ms);
                switch (variant) {
                    case RED_GLASSES: 
                    case ENGINEER_GOGGLES: 
                    case ANAGLYPH_GLASSES: {
                        ms.m_85837_(0.0, -0.225, -0.3);
                        ms.m_85841_(0.7f, -0.7f, -0.7f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case EYEPATCH: {
                        ms.m_85837_(0.125, -0.225, -0.3);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                        ms.m_85841_(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case WICKED_EYEPATCH: {
                        ms.m_85837_(-0.125, -0.225, -0.3);
                        ms.m_85841_(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case RED_RIBBONS: {
                        ms.m_85837_(0.0, -0.65, 0.2);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case PINK_FLOWER_BUD: {
                        ms.m_85837_(0.275, -0.6, 0.0);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case POLKA_DOTTED_BOWS: {
                        ms.m_85836_();
                        ms.m_85837_(0.275, -0.4, 0.0);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.m_85849_();
                        ms.m_85837_(-0.275, -0.4, 0.0);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case BLUE_BUTTERFLY: {
                        ms.m_85836_();
                        ms.m_85837_(0.275, -0.4, 0.0);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.m_85849_();
                        ms.m_85837_(0.275, -0.4, 0.0);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(-45.0f));
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case CAT_EARS: {
                        ms.m_85837_(0.0, -0.5, (double)-0.175f);
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case GOOGLY_EYES: {
                        ms.m_85837_(0.0, -0.225, -0.3);
                        ms.m_85841_(0.9f, -0.9f, -0.9f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case CLOCK_EYE: {
                        ms.m_85837_(0.1, -0.225, (double)-0.3f);
                        ms.m_85841_(0.4f, -0.4f, -0.4f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case UNICORN_HORN: {
                        ms.m_85837_(0.0, -0.7, -0.3);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                        ms.m_85841_(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case DEVIL_HORNS: {
                        ms.m_85837_(0.0, (double)-0.4f, (double)-0.175f);
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case HYPER_PLUS: {
                        ms.m_85837_((double)-0.15f, (double)-0.45f, (double)-0.3f);
                        ms.m_85841_(0.2f, -0.2f, -0.2f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.m_85837_((double)1.45f, 0.0, 0.0);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case ANCIENT_MASK: {
                        ms.m_85837_(0.0, -0.3, -0.3);
                        ms.m_85841_(0.7f, -0.7f, -0.7f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case EERIE_MASK: {
                        ms.m_85837_(0.0, -0.25, -0.3);
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case ALIEN_ANTENNA: {
                        ms.m_85837_(0.0, -0.65, 0.2);
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case ORANGE_SHADES: {
                        ms.m_85837_(0.0, -0.3, -0.3);
                        ms.m_85841_(0.7f, -0.7f, -0.7f);
                        int color = -1291845633;
                        RenderHelper.renderItemCustomColor(living, stack, color, ms, buffers, light, OverlayTexture.f_118083_);
                        break;
                    }
                    case GROUCHO_GLASSES: {
                        ms.m_85837_(0.0, -0.1, -0.3);
                        ms.m_85841_(0.75f, -0.75f, -0.75f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case THICK_EYEBROWS: {
                        ms.m_85836_();
                        ms.m_85837_(-0.1, -0.3, -0.3);
                        ms.m_85841_(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.m_85849_();
                        ms.m_85837_(0.1, -0.3, -0.3);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                        ms.m_85841_(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case TINY_POTATO_MASK: {
                        ms.m_85837_(0.0, -0.3, -0.3);
                        ms.m_85841_(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case QUESTGIVER_MARK: {
                        ms.m_85837_(0.0, -0.8, -0.2);
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case THINKING_HAND: {
                        ms.m_85837_(-0.1, 0.0, -0.3);
                        ms.m_85845_(Vector3f.f_122227_.m_122240_(-15.0f));
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                }
            } else {
                bipedModel.f_102810_.m_104299_(ms);
                switch (variant) {
                    case BLACK_BOWTIE: {
                        ms.m_85837_(0.0, 0.1, -0.13);
                        ms.m_85841_(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case BLACK_TIE: 
                    case PUFFY_SCARF: {
                        ms.m_85837_(0.0, 0.25, -0.15);
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case WITCH_PIN: {
                        ms.m_85837_(-0.1, 0.15, -0.15);
                        ms.m_85841_(0.2f, -0.2f, -0.2f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case DEVIL_TAIL: {
                        ms.m_85837_(0.0, 0.55, 0.2);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                        ms.m_85841_(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case KAMUI_EYE: {
                        ms.m_85836_();
                        ms.m_85837_(0.4, 0.1, -0.2);
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.m_85849_();
                        ms.m_85837_(-0.4, 0.1, -0.2);
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                        ms.m_85841_(0.5f, -0.5f, -0.5f);
                        RenderHelper.renderItemCustomColor(living, stack, -16777140, ms, buffers, light, OverlayTexture.f_118083_);
                        break;
                    }
                    case FOUR_LEAF_CLOVER: {
                        ms.m_85837_(0.1, 0.1, -0.13);
                        ms.m_85841_(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case BOTANIST_EMBLEM: {
                        ms.m_85837_(0.0, 0.375, -0.13);
                        ms.m_85841_(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case LUSITANIC_SHIELD: {
                        ms.m_85837_(0.0, 0.35, 0.13);
                        ms.m_85845_(Vector3f.f_122227_.m_122240_(8.0f));
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                        ms.m_85841_(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                }
            }
        }

        private static void renderItem(ItemStack stack, PoseStack ms, MultiBufferSource buffers, int light) {
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.NONE, light, OverlayTexture.f_118083_, ms, buffers, 0);
        }
    }
}

