/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manaweave;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemManaweaveArmor
extends ItemManasteelArmor {
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)ModItems.manaweaveHelm), new ItemStack((ItemLike)ModItems.manaweaveChest), new ItemStack((ItemLike)ModItems.manaweaveLegs), new ItemStack((ItemLike)ModItems.manaweaveBoots)});

    public ItemManaweaveArmor(EquipmentSlot type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getManaweaveArmorMaterial(), props);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return ClientProxy.jingleTheBells ? "botania:textures/model/armor_manaweave_holiday.png" : "botania:textures/model/armor_manaweave.png";
    }

    @Nonnull
    public String m_5671_(ItemStack stack) {
        String name = super.m_5671_(stack);
        if (IXplatAbstractions.INSTANCE.isPhysicalClient() && ClientProxy.jingleTheBells) {
            name = name.replaceAll("manaweave", "santaweave");
        }
        return name;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(ModItems.manaweaveHelm);
            case EquipmentSlot.CHEST -> stack.m_150930_(ModItems.manaweaveChest);
            case EquipmentSlot.LEGS -> stack.m_150930_(ModItems.manaweaveLegs);
            case EquipmentSlot.FEET -> stack.m_150930_(ModItems.manaweaveBoots);
            default -> false;
        };
    }

    @Override
    public MutableComponent getArmorSetName() {
        return new TranslatableComponent("botania.armorset.manaweave.name");
    }

    @Override
    public void addInformationAfterShift(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        if (IXplatAbstractions.INSTANCE.isPhysicalClient() && ClientProxy.jingleTheBells) {
            list.add((Component)new TranslatableComponent("botaniamisc.santaweaveInfo"));
            list.add((Component)new TextComponent(""));
        }
        super.addInformationAfterShift(stack, world, list, flags);
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        list.add((Component)new TranslatableComponent("botania.armorset.manaweave.desc0").m_130940_(ChatFormatting.GRAY));
        list.add((Component)new TranslatableComponent("botania.armorset.manaweave.desc1").m_130940_(ChatFormatting.GRAY));
    }
}

