/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.proxy.IProxy;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class ItemSextant
extends Item {
    public static final ResourceLocation MULTIBLOCK_ID = ResourceLocationHelper.prefix("sextant");
    private static final int MAX_RADIUS = 256;
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourceZ";

    public ItemSextant(Item.Properties builder) {
        super(builder);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int count) {
        if (this.m_8105_(stack) - count < 10 || !(living instanceof Player) || world.f_46443_) {
            return;
        }
        int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
        if (y != Integer.MIN_VALUE) {
            double radius = ItemSextant.calculateRadius(stack, living);
            if (count % 10 == 0) {
                WispParticleData data = WispParticleData.wisp(0.3f, 0.0f, 1.0f, 1.0f, 1.0f);
                for (int i = 0; i < 360; ++i) {
                    float radian = (float)((double)i * Math.PI / 180.0);
                    double xp = (double)x + Math.cos(radian) * radius;
                    double zp = (double)z + Math.sin(radian) * radius;
                    world.m_7106_((ParticleOptions)data, xp + 0.5, (double)(y + 1), zp + 0.5, 0.0, (double)0.01f, 0.0);
                }
            }
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity living, int time) {
        if (!(living instanceof Player)) {
            return;
        }
        double radius = ItemSextant.calculateRadius(stack, living);
        if (1.0 < radius && radius <= 256.0) {
            IStateMatcher matcher = PatchouliAPI.get().predicateMatcher(Blocks.f_50652_, s -> !s.m_60795_());
            int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
            int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
            int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
            int iradius = (int)radius + 1;
            if (y != Integer.MIN_VALUE) {
                HashMap<BlockPos, IStateMatcher> map = new HashMap<BlockPos, IStateMatcher>();
                for (int i = 0; i < iradius * 2 + 1; ++i) {
                    for (int j = 0; j < iradius * 2 + 1; ++j) {
                        int xp = x + i - iradius;
                        int zp = z + j - iradius;
                        if ((int)Math.floor(MathHelper.pointDistancePlane(xp, zp, x, z)) != iradius - 1) continue;
                        map.put(new BlockPos(xp - x, 0, zp - z), matcher);
                    }
                }
                IMultiblock sparse = PatchouliAPI.get().makeSparseMultiblock(map).setId(MULTIBLOCK_ID);
                IProxy.INSTANCE.showMultiblock(sparse, (Component)new TextComponent("r = " + (int)radius), new BlockPos(x, y, z), Rotation.NONE);
            }
        }
    }

    private void reset(Level world, ItemStack stack) {
        ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        if (world.f_46443_) {
            IProxy.INSTANCE.clearSextantMultiblock();
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            BlockHitResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 128.0, false);
            if (rtr.m_6662_() == HitResult.Type.BLOCK) {
                if (!world.f_46443_) {
                    BlockPos pos = rtr.m_82425_();
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_X, pos.m_123341_());
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, pos.m_123342_());
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_Z, pos.m_123343_());
                }
                player.m_6672_(hand);
            }
        } else {
            this.reset(world, stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private static double calculateRadius(ItemStack stack, LivingEntity living) {
        int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
        Vec3 source = new Vec3((double)x, (double)y, (double)z);
        WispParticleData data = WispParticleData.wisp(0.2f, 1.0f, 0.0f, 0.0f, 1.0f);
        living.f_19853_.m_7106_((ParticleOptions)data, source.f_82479_ + 0.5, source.f_82480_ + 1.0, source.f_82481_ + 0.5, 0.0, (double)0.1f, 0.0);
        Vec3 centerVec = VecHelper.fromEntityCenter((Entity)living);
        Vec3 diffVec = source.m_82546_(centerVec);
        Vec3 lookVec = living.m_20154_();
        double mul = diffVec.f_82480_ / lookVec.f_82480_;
        lookVec = lookVec.m_82490_(mul).m_82549_(centerVec);
        lookVec = new Vec3((double)Mth.m_14107_((double)lookVec.f_82479_), lookVec.f_82480_, (double)Mth.m_14107_((double)lookVec.f_82481_));
        return MathHelper.pointDistancePlane(source.f_82479_, source.f_82481_, lookVec.f_82479_, lookVec.f_82481_);
    }

    public static class Hud {
        public static void render(PoseStack ms, Player player, ItemStack stack) {
            ItemStack onUse = player.m_21211_();
            int time = player.m_21212_();
            if (onUse == stack && stack.m_41720_().m_8105_(stack) - time >= 10) {
                boolean inRange;
                double radius = ItemSextant.calculateRadius(stack, (LivingEntity)player);
                Font font = Minecraft.m_91087_().f_91062_;
                int x = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + 30;
                int y = Minecraft.m_91087_().m_91268_().m_85446_() / 2;
                Object s = Integer.toString((int)radius);
                boolean bl = inRange = 0.0 < radius && radius <= 256.0;
                if (!inRange) {
                    s = ChatFormatting.RED + (String)s;
                }
                font.m_92750_(ms, (String)s, (float)(x - font.m_92895_((String)s) / 2), (float)(y - 4), 0xFFFFFF);
                if (inRange) {
                    radius += 4.0;
                    RenderSystem.m_69472_();
                    RenderSystem.m_69832_((float)3.0f);
                    Tesselator.m_85913_().m_85915_().m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85814_);
                    RenderSystem.m_157429_((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    for (int i = 0; i < 361; ++i) {
                        float radian = (float)((double)i * Math.PI / 180.0);
                        float xp = (float)x + Mth.m_14089_((float)radian) * (float)radius;
                        float yp = (float)y + Mth.m_14031_((float)radian) * (float)radius;
                        Tesselator.m_85913_().m_85915_().m_85982_(ms.m_85850_().m_85861_(), xp, yp, 0.0f).m_5752_();
                    }
                    Tesselator.m_85913_().m_85914_();
                    RenderSystem.m_69493_();
                }
            }
        }
    }
}

