/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;

public class EntityManaStorm
extends Entity {
    private static final String TAG_TIME = "time";
    private static final String TAG_BURST_COLOR = "burstColor";
    private static final String TAG_BURSTS_FIRED = "burstsFired";
    private static final String TAG_DEATH_TIME = "deathTime";
    public static final int TOTAL_BURSTS = 250;
    public static final int DEATH_TIME = 200;
    public int liveTime;
    public int burstColor;
    public int burstsFired;
    public int deathTime;

    public EntityManaStorm(EntityType<EntityManaStorm> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.liveTime;
        int diffTime = Math.max(1, 30 - (int)((float)this.liveTime / 45.0f));
        if (this.burstsFired < 250 && this.liveTime % diffTime == 0) {
            if (!this.f_19853_.f_46443_) {
                this.spawnBurst();
            }
            ++this.burstsFired;
        }
        if (this.burstsFired >= 250) {
            ++this.deathTime;
            if (this.deathTime >= 200) {
                this.m_146870_();
                this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 8.0f, true, Explosion.BlockInteraction.DESTROY);
            }
        }
    }

    private void spawnBurst() {
        EntityManaBurst burst = (EntityManaBurst)ModEntities.MANA_BURST.m_20615_(this.f_19853_);
        burst.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        float motionModifier = 0.5f;
        burst.setColor(this.burstColor);
        burst.setMana(120);
        burst.setStartingMana(340);
        burst.setMinManaLoss(50);
        burst.setManaLossPerTick(1.0f);
        burst.setGravity(0.0f);
        burst.setSourceLens(new ItemStack((ItemLike)ModItems.lensStorm));
        Vec3 motion = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_().m_82490_((double)motionModifier);
        burst.m_20256_(motion);
        this.f_19853_.m_7967_((Entity)burst);
    }

    protected void m_7378_(@Nonnull CompoundTag cmp) {
        this.liveTime = cmp.m_128451_(TAG_TIME);
        this.burstColor = cmp.m_128451_(TAG_BURST_COLOR);
        this.burstsFired = cmp.m_128451_(TAG_BURSTS_FIRED);
        this.deathTime = cmp.m_128451_(TAG_DEATH_TIME);
    }

    protected void m_7380_(@Nonnull CompoundTag cmp) {
        cmp.m_128405_(TAG_TIME, this.liveTime);
        cmp.m_128405_(TAG_BURST_COLOR, this.burstColor);
        cmp.m_128405_(TAG_BURSTS_FIRED, this.burstsFired);
        cmp.m_128405_(TAG_DEATH_TIME, this.deathTime);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

